/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwText;

import oracle.ewt.lwAWT.lwText.LWTextComponent;
import oracle.ewt.timer.Periodic;

final class CursorIdler
implements Runnable {
    private static final int _IDLE_TIME = 600;
    private static CursorIdler _sCursorIdler;
    private long _idleRate = 600L;
    private int _referenceCount;
    private LWTextComponent _idlee;
    private Periodic _periodic;
    private boolean _isCursorDrawn;

    private CursorIdler() {
        this.addRef();
    }

    static CursorIdler getCursorIdler() {
        if (_sCursorIdler == null) {
            _sCursorIdler = new CursorIdler();
        }
        return _sCursorIdler;
    }

    public void setBlinkRate(long l) {
        this._idleRate = l;
    }

    public long getBlinkRate() {
        return this._idleRate;
    }

    public void setIdlee(LWTextComponent lWTextComponent) {
        if (lWTextComponent != null && lWTextComponent.getSelectionStart() == lWTextComponent.getSelectionEnd()) {
            this._schedule();
        } else if (this._periodic != null) {
            this._periodic.cancel();
        }
        this._idlee = lWTextComponent;
    }

    public LWTextComponent getIdlee() {
        return this._idlee;
    }

    public int addRef() {
        ++this._referenceCount;
        return this._referenceCount;
    }

    public int release() {
        --this._referenceCount;
        if (this._referenceCount == 0) {
            _sCursorIdler = null;
            if (this._periodic != null) {
                this._periodic.kill();
            }
            this._periodic = null;
        }
        return this._referenceCount;
    }

    public void run() {
        LWTextComponent lWTextComponent = this.getIdlee();
        boolean bl = this._isCursorDrawn = !this._isCursorDrawn;
        if (lWTextComponent != null && lWTextComponent.getSelectionStart() == lWTextComponent.getSelectionEnd()) {
            if (this._isCursorDrawn) {
                lWTextComponent.paintSelection();
            } else {
                lWTextComponent.eraseSelection();
            }
        }
    }

    public void schedule(LWTextComponent lWTextComponent) {
        LWTextComponent lWTextComponent2 = this.getIdlee();
        if (lWTextComponent2 == null || lWTextComponent2 == lWTextComponent) {
            if (lWTextComponent2 == null) {
                this.setIdlee(lWTextComponent);
            }
            this._schedule();
        }
    }

    public void cancel(LWTextComponent lWTextComponent) {
        if (this.getIdlee() == lWTextComponent) {
            this.setIdlee(null);
        }
    }

    private void _schedule() {
        if (this.getBlinkRate() > 0L) {
            this._getPeriodic().schedule(this.getBlinkRate());
        }
        this._isCursorDrawn = true;
    }

    private Periodic _getPeriodic() {
        if (this._periodic == null || this._periodic.isKilled()) {
            this._periodic = new Periodic((Runnable)this, "CursorIdler");
        }
        return this._periodic;
    }
}

