/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT.lwWindow.laf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import oracle.ewt.lwAWT.lwWindow.Desktop;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.lwAWT.lwWindow.WindowManager;
import oracle.ewt.lwAWT.lwWindow.laf.BaseWindowMover;

final class KeyWindowMover
extends BaseWindowMover
implements ActionListener,
MouseListener {
    private static final int _KEY_MOVE_INCREMENT = 10;

    public KeyWindowMover(LWWindow lWWindow) {
        super(lWWindow);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.beginReshaping();
    }

    public void keyPressed(KeyEvent keyEvent) {
        Point point = this.getWindowLocation();
        int n = point.x;
        int n2 = point.y;
        switch (keyEvent.getKeyCode()) {
            case 37: {
                n -= 10;
                break;
            }
            case 39: {
                n += 10;
                break;
            }
            case 38: {
                n2 -= 10;
                break;
            }
            case 40: {
                n2 += 10;
            }
        }
        if (n != point.x || n2 != point.y) {
            LWWindow lWWindow = this.getWindow();
            Dimension dimension = lWWindow.getSize();
            n = Math.max(-dimension.width + 10, n);
            n2 = Math.max(0, n2);
            Desktop desktop = lWWindow.getDesktop();
            Component component = desktop.getDesktopComponent();
            Dimension dimension2 = component.getSize();
            n = Math.min(n, dimension2.width - 10);
            n2 = Math.min(n2, dimension2.height - 10);
            this.setWindowLocation(n, n2);
            WindowManager windowManager = desktop.getWindowManager();
            windowManager.moveWindow(lWWindow, n, n2);
        }
        super.keyPressed(keyEvent);
    }

    protected MouseListener getMouseGrab() {
        return this;
    }
}

