/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.meter;

import java.awt.Graphics;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.lwAWT.AbstractPainterComponent;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.MeterUI;
import oracle.ewt.timer.Periodic;

public class BusyBar
extends AbstractPainterComponent {
    private Periodic _timer;
    private int _timerSpeed = 50;
    private String _label;
    private int _state = 0;
    boolean _running;

    public BusyBar() {
        this.setAlignment(3);
    }

    public Object getUIClassID() {
        return "BusyBarUI";
    }

    public synchronized void start() {
        this._running = true;
        if (this.isShowing()) {
            this._start();
        }
        this._fireAccessibleBusy(true);
    }

    public synchronized void stop() {
        this._running = false;
        this._stop();
        this._fireAccessibleBusy(true);
    }

    public void setLabel(String string) {
        if (string != this._label) {
            this._label = string;
            this.repaint();
        }
    }

    public String getLabel() {
        return this._label;
    }

    public synchronized void setSpeed(int n) {
        this._timerSpeed = n;
        if (this._timer != null) {
            this._timer.schedule(n);
        }
    }

    public int getSpeed() {
        return this._timerSpeed;
    }

    public void removeNotify() {
        super.removeNotify();
        this._stop();
    }

    public void paintInterior(Graphics graphics) {
        super.paintInterior(graphics);
        if (this._timer == null) {
            this._start();
        }
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    protected Object getPaintData(Object object) {
        Object object2 = null;
        if (object == null || object == "State") {
            object2 = IntegerUtils.getInteger((int)this._state);
        } else if (object == PaintContext.LABEL_KEY) {
            String string = this.getLabel();
            if (string != null && string.length() > 0) {
                object2 = string;
            }
        } else {
            object2 = super.getPaintData(object);
        }
        return object2;
    }

    public Painter getPainter() {
        return ((MeterUI)this.getUI()).getPainter(this);
    }

    private synchronized void _start() {
        if (this._running) {
            if (this._timer == null) {
                this._timer = new Periodic(new _RunnableImpl());
                this._timer.setName("BusyBar");
                this._timer.setDaemon(true);
            }
            this._timer.schedule(this._timerSpeed);
        }
    }

    synchronized void _stop() {
        if (this._timer != null) {
            this._timer.kill();
            this._timer = null;
        }
    }

    private void _fireAccessibleBusy(boolean bl) {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange("AccessibleState", bl ? null : AccessibleState.BUSY, bl ? AccessibleState.BUSY : null);
        }
    }

    private class Access
    extends AccessibleLWComponent {
        public Access() {
            super(BusyBar.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (BusyBar.this._running) {
                accessibleStateSet.add(AccessibleState.BUSY);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_BAR;
        }
    }

    private class _RunnableImpl
    implements Runnable {
        private _RunnableImpl() {
        }

        public void run() {
            if (BusyBar.this.isShowing()) {
                BusyBar.this._state = BusyBar.this._state + 1;
                BusyBar.this.repaint();
            } else {
                BusyBar.this._stop();
            }
        }
    }
}

