/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;

public class FilterClassLocator
extends BaseClassLocator {
    private BaseClassLocator _locator;
    private PackageNameFilter _pFilter;
    private ClassNameFilter _cFilter;

    public FilterClassLocator(BaseClassLocator locator, PackageNameFilter pFilter, ClassNameFilter cFilter) {
        this._locator = locator;
        this._pFilter = pFilter;
        this._cFilter = cFilter;
    }

    @Override
    public void getPackages(String packagePrefix, Collection<String> out) {
        try {
            this.getPackagesImpl(packagePrefix, out, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        this.getPackagesImpl(packagePrefix, out, true);
    }

    @Override
    public void getClassesInPackage(String packagePrefix, Collection<String> out) {
        if (this._pFilter.acceptPackageName(packagePrefix)) {
            out.addAll(this._locator.getClassesInPackage(packagePrefix));
        }
    }

    @Override
    public void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        FilterClassLocator.checkInterrupt();
        if (this._pFilter.acceptPackageName(packagePrefix)) {
            out.addAll(this._locator.getClassesInPackageInterruptibly(packagePrefix));
        }
    }

    @Override
    public void getAllClasses(Collection<String> out, ClassNameFilter classNameFilter) {
        try {
            this.getAllClassesImpl(out, classNameFilter, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        this.getAllClassesImpl(out, filter, true);
    }

    @Override
    public void getAllPackages(Collection<String> out, PackageNameFilter packageNameFilter) {
        try {
            this.getAllPackagesImpl(out, packageNameFilter, false);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        this.getAllPackagesImpl(out, filter, true);
    }

    @Override
    public void buildIndex() {
        this._locator.buildIndex();
    }

    @Override
    public void buildIndexInterruptibly() throws InterruptedException {
        this._locator.buildIndexInterruptibly();
    }

    @Override
    public URL getURL(String fqClassName) {
        if (this.classFilterAcceptsClassName(fqClassName)) {
            return this._locator.getURL(fqClassName);
        }
        return null;
    }

    @Override
    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        if (this.classFilterAcceptsClassName(fqClassName)) {
            return this._locator.getURLInterruptibly(fqClassName);
        }
        return null;
    }

    @Override
    public URL getSourceURL(String fqClassName) {
        if (this.classFilterAcceptsClassName(fqClassName)) {
            return this._locator.getSourceURL(fqClassName);
        }
        return null;
    }

    @Override
    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        if (this.classFilterAcceptsClassName(fqClassName)) {
            return this._locator.getSourceURLInterruptibly(fqClassName);
        }
        return null;
    }

    @Override
    public URL getClassURL(String fqClassName) {
        if (this.classFilterAcceptsClassName(fqClassName)) {
            return this._locator.getClassURL(fqClassName);
        }
        return null;
    }

    @Override
    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        if (this.classFilterAcceptsClassName(fqClassName)) {
            return this._locator.getClassURLInterruptibly(fqClassName);
        }
        return null;
    }

    @Override
    public URL getResourceURL(String resourceName) {
        return this._locator.getResourceURL(resourceName);
    }

    private String[] separatePackageAndName(String fqClassName) {
        int index = fqClassName.lastIndexOf(46);
        if (index > 0) {
            return new String[]{fqClassName.substring(0, index), fqClassName.substring(index + 1)};
        }
        return new String[]{"", fqClassName};
    }

    private boolean classFilterAcceptsClassName(String fqClassName) {
        String[] packageAndName = this.separatePackageAndName(fqClassName);
        return this._cFilter.acceptClassName(packageAndName[1], packageAndName[0]);
    }

    private void getAllClassesImpl(Collection<String> out, ClassNameFilter classNameFilter, boolean checkInterrupt) throws InterruptedException {
        Collection<String> allClasses;
        if (checkInterrupt) {
            FilterClassLocator.checkInterrupt();
            allClasses = this._locator.getAllClassesInterruptibly(classNameFilter);
        } else {
            allClasses = this._locator.getAllClasses(classNameFilter);
        }
        Iterator<String> iter = allClasses.iterator();
        while (iter.hasNext()) {
            String fqClassName;
            if (checkInterrupt) {
                FilterClassLocator.checkInterrupt();
            }
            if (!this.classFilterAcceptsClassName(fqClassName = iter.next())) continue;
            out.add(fqClassName);
        }
    }

    private void getPackagesImpl(String packagePrefix, Collection<String> out, boolean checkInterrupt) throws InterruptedException {
        Collection<String> packages;
        if (checkInterrupt) {
            FilterClassLocator.checkInterrupt();
            packages = this._locator.getPackagesInterruptibly(packagePrefix);
        } else {
            packages = this._locator.getPackages(packagePrefix);
        }
        for (String onePackage : packages) {
            String packageName;
            if (checkInterrupt) {
                FilterClassLocator.checkInterrupt();
            }
            if (!this._pFilter.acceptPackageName(packageName = packagePrefix.isEmpty() ? onePackage : packagePrefix + "." + onePackage)) continue;
            out.add(onePackage);
        }
    }

    private void getAllPackagesImpl(Collection<String> out, PackageNameFilter packageNameFilter, boolean checkInterrupt) throws InterruptedException {
        Collection<String> packages;
        if (checkInterrupt) {
            FilterClassLocator.checkInterrupt();
            packages = this._locator.getAllPackagesInterruptibly(packageNameFilter);
        } else {
            packages = this._locator.getAllPackages(packageNameFilter);
        }
        for (String onePackage : packages) {
            if (checkInterrupt) {
                FilterClassLocator.checkInterrupt();
            }
            if (!this._pFilter.acceptPackageName(onePackage)) continue;
            out.add(onePackage);
        }
    }
}

