/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem.plaf;

import com.oracle.jdeveloper.nbwindowsystem.NbToolbarsFS;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.ide.Ide;
import oracle.ide.controller.Menubar;
import oracle.ide.resource.IdeArb;
import org.netbeans.swing.tabcontrol.plaf.TabControlButton;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class ActionsUtils {
    private ActionsUtils() {
    }

    public static void addMenuListeners() {
        JMenu windowMenu;
        Menubar menuMgr = Ide.getMenubar();
        JMenu viewMenu = Menubar.getJMenu((String)"View");
        if (viewMenu != null) {
            viewMenu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    NbToolbarsFS fs = (NbToolbarsFS)Lookup.getDefault().lookup(NbToolbarsFS.class);
                    fs.refresh(true);
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
        }
        if ((windowMenu = Menubar.getJMenu((String)"Window")) != null) {
            windowMenu.addMenuListener(new MenuListener(){
                private String orginalCloseWindowActionLabel;

                @Override
                public void menuSelected(MenuEvent e) {
                    this.updateCloseWindowActionLabel();
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }

                private void updateCloseWindowActionLabel() {
                    Action closeWindowAction = (Action)FileUtil.getConfigObject((String)"/Actions/Window/org-netbeans-core-windows-actions-CloseWindowAction.instance", Action.class);
                    if (closeWindowAction == null) {
                        return;
                    }
                    TopComponent tc = TopComponent.getRegistry().getActivated();
                    String tcDisplayName = null;
                    if (tc != null) {
                        tcDisplayName = tc.getDisplayName();
                    }
                    if (tcDisplayName != null) {
                        tcDisplayName = tcDisplayName.trim();
                    }
                    String actionLabel = tcDisplayName != null && tcDisplayName.length() > 0 ? NbBundle.getMessage(ActionsUtils.class, (String)"FMT_Close", (Object)tcDisplayName) : IdeArb.getString((int)281);
                    closeWindowAction.putValue("Name", actionLabel);
                }
            });
        }
    }

    public static void showDropDownList() {
        TabControlButton buttonFileList = ActionsUtils.findFileListButton();
        if (buttonFileList == null) {
            return;
        }
        if (buttonFileList != null) {
            buttonFileList.getAction().actionPerformed(new ActionEvent(buttonFileList, 1001, "pressed"));
        }
    }

    private static TabControlButton findFileListButton() {
        Collection buttons = ActionsUtils.findAllComponentsByType((Container)Ide.getMainWindow(), TabControlButton.class);
        TabControlButton button = (TabControlButton)ActionsUtils.findObjectByClassName(buttons, "TabControlButtonFactory$DropDownButton");
        return button;
    }

    private static <T> T findObjectByClassName(Collection<T> objects, String className) {
        for (T o : objects) {
            if (o == null || !o.getClass().getName().endsWith(className)) continue;
            return o;
        }
        return null;
    }

    private static <T> Collection<T> findAllComponentsByType(Container root, Class searchType) {
        HashSet components = new HashSet();
        ActionsUtils.searchForAllComponentsByType(root, components, searchType);
        return components;
    }

    private static <T> void searchForAllComponentsByType(Container root, Collection<T> allComponents, Class searchType) {
        if (searchType.isInstance(root)) {
            allComponents.add(root);
        }
        for (Component c : root.getComponents()) {
            if (!(c instanceof Container)) continue;
            ActionsUtils.searchForAllComponentsByType((Container)c, allComponents, searchType);
        }
    }
}

