/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.composite;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import oracle.ide.composite.BaseCompositeFileElementProxy;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.LazyLoadable;
import oracle.ide.model.Locatable;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public class DefaultCompositeFileElementProxy
extends BaseCompositeFileElementProxy {
    private final Observer _compositeContainerObserver = new Observer(){

        @Override
        public final void update(Object observed, UpdateMessage change) {
            if (!CompositeFileElementRegistry.isRegisteredCompositeProxy(DefaultCompositeFileElementProxy.this)) {
                ((Subject)observed).detach(this);
                return;
            }
            int messageId = change.getMessageID();
            if (messageId != UpdateMessage.CHILD_ADDED && messageId != UpdateMessage.CHILD_REMOVED) {
                return;
            }
            CompositeFileElementRegistry.fireCompositeStateChanged(DefaultCompositeFileElementProxy.this.getCompositeElementMetaClass());
        }
    };
    private final Observer _compositeOpenObserver = new Observer(){

        @Override
        public final void update(Object observed, UpdateMessage change) {
            if (!CompositeFileElementRegistry.isRegisteredCompositeProxy(DefaultCompositeFileElementProxy.this)) {
                ((Subject)observed).detach(this);
                return;
            }
            if (change.getMessageID() != UpdateMessage.OBJECT_OPENED) {
                return;
            }
            CompositeFileElementRegistry.fireCompositeStateChanged(DefaultCompositeFileElementProxy.this.getCompositeElementMetaClass());
            ((Subject)observed).detach(this);
        }
    };
    private final String _viewType;
    private final Class _compositeElementClass;

    public DefaultCompositeFileElementProxy() {
        this._viewType = null;
        this._compositeElementClass = null;
    }

    @Deprecated
    public DefaultCompositeFileElementProxy(Class compositeElementClass) {
        this._viewType = null;
        this._compositeElementClass = compositeElementClass;
    }

    @Deprecated
    public DefaultCompositeFileElementProxy(String viewType, Class compositeElementClass) {
        this._viewType = viewType;
        this._compositeElementClass = compositeElementClass;
    }

    @Override
    public String getViewType() {
        if (this._viewType != null) {
            return this._viewType;
        }
        return super.getViewType();
    }

    @Override
    @Deprecated
    public Class getCompositeElementClass() {
        if (this._compositeElementClass != null) {
            return this._compositeElementClass;
        }
        return super.getCompositeElementClass();
    }

    @Override
    public URL[] getCompositeFileURLs(Element compositeElement) {
        this.attachContainerStateObserver(compositeElement);
        Collection compositeFileUrls = this.getContainerFileURLs(compositeElement);
        return compositeFileUrls.toArray(new URL[0]);
    }

    protected void attachContainerStateObserver(Element element) {
        Subject compositeSubject;
        if (element instanceof Subject) {
            compositeSubject = (Subject)((Object)element);
            compositeSubject.detach(this._compositeContainerObserver);
            compositeSubject.attach(this._compositeContainerObserver);
        }
        if (!this.isContainerStyleRecursive()) {
            return;
        }
        if (!element.mayHaveChildren()) {
            return;
        }
        if (element instanceof Subject && element instanceof LazyLoadable && !((LazyLoadable)((Object)element)).isOpen()) {
            compositeSubject = (Subject)((Object)element);
            compositeSubject.detach(this._compositeOpenObserver);
            compositeSubject.attach(this._compositeOpenObserver);
            return;
        }
        Iterator itr = element.getChildren();
        while (itr != null && itr.hasNext()) {
            this.attachContainerStateObserver((Element)itr.next());
        }
    }

    protected Collection getContainerFileURLs(Element compositeElement) {
        LinkedHashSet compositeFileUrls = new LinkedHashSet();
        this.addParentURL(compositeFileUrls, compositeElement);
        this.addChildURLs(compositeFileUrls, compositeElement);
        return compositeFileUrls;
    }

    protected boolean isContainerStyleRecursive() {
        return true;
    }

    protected void addParentURL(Collection compositeFileUrls, Element parent) {
        this.addLocatableURL(compositeFileUrls, parent);
    }

    protected void addChildURLs(Collection compositeFileUrls, Element parent) {
        if (!parent.mayHaveChildren()) {
            return;
        }
        Iterator itr = parent.getChildren();
        while (itr != null && itr.hasNext()) {
            this.addLocatableURL(compositeFileUrls, itr.next());
        }
        if (!this.isContainerStyleRecursive()) {
            return;
        }
        itr = parent.getChildren();
        while (itr != null && itr.hasNext()) {
            this.addChildURLs(compositeFileUrls, (Element)itr.next());
        }
    }

    protected void addLocatableURL(Collection compositeFileUrls, Object o) {
        if (!(o instanceof Locatable)) {
            return;
        }
        URL url = ((Locatable)o).getURL();
        if (url != null) {
            compositeFileUrls.add(url);
        }
    }
}

