/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class ExportProductPreferencesDialog {
    public static boolean invokeDialog() {
        Window window = IdeUtil.findActiveModalWindow();
        window = window != null ? window : IdeUtil.getMainWindow();
        try {
            Preferences.getPreferences().save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        URLChooser chooser = DialogUtil.newURLChooser();
        DefaultURLFilter filter = new DefaultURLFilter(IdeArb.getString(550), ".xml");
        chooser.clearChooseableURLFilters();
        chooser.addChooseableURLFilter((URLFilter)filter);
        chooser.addChooseableURLFilter((URLFilter)new DefaultURLFilter(IdeArb.getString(551)));
        chooser.setURLFilter((URLFilter)filter);
        chooser.setSelectionMode(0);
        chooser.setSelectionScope(0);
        int result = chooser.showSaveDialog(window);
        if (result != 0) {
            return false;
        }
        URL url = chooser.getSelectedURL();
        if ("".equals(URLFileSystem.getSuffix((URL)url))) {
            url = URLFileSystem.convertSuffix((URL)url, (String)"", (String)".xml");
        }
        if (URLFileSystem.exists((URL)url) && !MessageDialog.confirm((Component)window, (Object)IdeArb.getString(484), (String)IdeArb.getString(485), null, (boolean)true)) {
            return false;
        }
        if (!URLFileSystem.canCreate((URL)url)) {
            MessageDialog.error((Component)window, (Object)IdeArb.format(247, URLFileSystem.getPlatformPathName((URL)url)), (String)IdeArb.getString(246), null);
            return false;
        }
        try {
            Preferences.getPreferences().exportPreferences(url);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return true;
    }
}

