/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.EventObject;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuListener;
import oracle.ide.controls.BaseToggleToolButton;
import oracle.ide.controls.MenuItem;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.MenuToolButtonUtils;
import oracle.ide.controls.RadioMenuItem;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleMenuItem;
import oracle.ide.controls.ToolButton;
import oracle.ide.util.GraphicsUtils;
import oracle.javatools.ui.themes.Themes;

public class ActionMenuToolButton
extends BaseToggleToolButton {
    protected static final Action[] NULL_ACTIONS = new Action[0];
    protected static final PopupMenuListener POPUP_MENU_LISTENER = MenuToolButton.POPUP_MENU_LISTENER;
    protected static final Icon POPUP_ICON;
    protected static final Icon POPUP_ICON_BRIGHT;
    private static Icon POPUP_ICON_DISABLED;
    protected static final int POPUP_WIDTH;
    protected static final String ACTION_SHOW_POPUP_MENU = "ShowPopupMenu";
    protected JPopupMenu _popup;
    private Image _capturedImage;
    private AccessibleContext _accessibleContext;
    private AWTEventListener _awtListener;
    private boolean _popupAlreadyShown;
    private Boolean useBrightDropDownArrow = null;

    public ActionMenuToolButton(Action action) {
        super(action);
        this.setHorizontalAlignment(2);
        ButtonCaptureAdapter adapter = new ButtonCaptureAdapter();
        this.addComponentListener(adapter);
        this.addMouseListener(adapter);
        this.addMouseMotionListener(adapter);
        this.addPropertyChangeListener(adapter);
        this.createKeyBindings(adapter);
        this._accessibleContext = new ActionMenuToolButtonAccessibleContext();
        this._awtListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event.getSource() == ActionMenuToolButton.this && event.getID() == 501) {
                    ActionMenuToolButton.this._popupAlreadyShown = ActionMenuToolButton.this.isPopupVisible();
                }
            }
        };
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return this._accessibleContext;
    }

    private void createKeyBindings(final ButtonCaptureAdapter adapter) {
        AbstractAction showPopupMenuAction = new AbstractAction(ACTION_SHOW_POPUP_MENU){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ActionMenuToolButton.this.hasPopup()) {
                    adapter.showPopupMenu(e);
                }
            }
        };
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), ACTION_SHOW_POPUP_MENU);
        showPopupMenuAction.putValue("ActionCommandKey", ACTION_SHOW_POPUP_MENU);
        this.getActionMap().put(ACTION_SHOW_POPUP_MENU, showPopupMenuAction);
    }

    public void setMenuActions(Action[] actions) {
        if (actions == null) {
            this.releasePopupMenu();
        } else {
            if (this._popup == null) {
                this.createPopupMenu();
            } else {
                this._popup.removeAll();
            }
            for (int i = 0; i < actions.length; ++i) {
                Action action = actions[i];
                if (action instanceof ToggleAction) {
                    ToggleAction toggleAction = (ToggleAction)action;
                    JMenuItem menuItem = toggleAction.isRadio() ? new RadioMenuItem(toggleAction) : (toggleAction.isToggle() ? new ToggleMenuItem(toggleAction) : new MenuItem(toggleAction));
                    this._popup.add(menuItem);
                    continue;
                }
                if (action != null) {
                    this._popup.add(action);
                    continue;
                }
                this._popup.addSeparator();
            }
        }
    }

    @Override
    protected ButtonModel createModel() {
        return new JToggleButton.ToggleButtonModel(){

            @Override
            public boolean isSelected() {
                return ActionMenuToolButton.this.isPopupVisible();
            }

            @Override
            public void setPressed(boolean b) {
                super.setPressed(b);
                if (!b && !ActionMenuToolButton.this.isPopupVisible()) {
                    ActionMenuToolButton.this._capturedImage = null;
                }
            }

            @Override
            public int getMnemonic() {
                if (Boolean.TRUE.equals(ActionMenuToolButton.this.getClientProperty("hideActionText"))) {
                    return 0;
                }
                return super.getMnemonic();
            }
        };
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.width += POPUP_WIDTH + 1;
        return size;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this._popup != null) {
            SwingUtilities.updateComponentTreeUI(this._popup);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this._awtListener);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Toolkit.getDefaultToolkit().addAWTEventListener(this._awtListener, 16L);
    }

    @Override
    public void paint(Graphics g) {
        if (this._capturedImage != null && (this.isPopupVisible() || this.getModel().isPressed())) {
            g.drawImage(this._capturedImage, 0, 0, this);
            return;
        }
        this._capturedImage = null;
        super.paint(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.isEnabled() && (this.getModel().isRollover() || this.getModel().isSelected())) {
            int x = w - POPUP_WIDTH - 1;
            boolean inset = true;
            Color oldColor = g.getColor();
            Color controlShadow = null;
            if (Themes.isThemed()) {
                controlShadow = Themes.getActiveTheme().getPartProperties("toolbarbutton.separator").getColor("color");
            } else {
                controlShadow = SystemColor.controlShadow;
                g.setColor(SystemColor.controlLtHighlight);
                g.drawLine(x + 1, 1, x + 1, h - 1 - 1);
            }
            g.setColor(controlShadow);
            g.drawLine(x, 1, x, h - 1 - 1);
            g.setColor(oldColor);
        }
        Icon currentIcon = null;
        if (Themes.isThemed() && POPUP_ICON_DISABLED != null) {
            Icon popupIcon = null;
            popupIcon = this.useBrightDropDownArrow(this) ? POPUP_ICON_BRIGHT : POPUP_ICON;
            currentIcon = this.isEnabled() ? popupIcon : POPUP_ICON_DISABLED;
        } else {
            currentIcon = POPUP_ICON;
        }
        int xoff = -1;
        int x = w - 1 - (POPUP_WIDTH + POPUP_ICON.getIconWidth()) / 2;
        int y = (h - currentIcon.getIconHeight()) / 2;
        currentIcon.paintIcon(this, g, x, y);
    }

    @Override
    protected void configurePropertiesFromAction(Action a) {
        super.configurePropertiesFromAction(a);
        this.setMenuActions(a != null ? (Action[])a.getValue("ActionMenuActions") : NULL_ACTIONS);
    }

    @Override
    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new ActionMenuButtonActionPropertyChangeListener(this, a);
    }

    @Override
    protected ActionListener createActionListener() {
        return new FilterActionEvents(this);
    }

    protected JPopupMenu createPopupMenu() {
        if (this._popup != null) {
            this.releasePopupMenu();
        }
        this._popup = new JPopupMenu();
        this._popup.addPopupMenuListener(POPUP_MENU_LISTENER);
        this.invalidate();
        return this._popup;
    }

    protected void releasePopupMenu() {
        if (this._popup != null) {
            this._popup.removePopupMenuListener(POPUP_MENU_LISTENER);
            this._popup = null;
            this.invalidate();
        }
    }

    protected boolean hasPopup() {
        return this._popup != null;
    }

    protected boolean isPopupVisible() {
        return this._popup != null && this._popup.isVisible();
    }

    public JPopupMenu getPopup() {
        return this._popup;
    }

    private static Image createDisabledImage(Image i, int p) {
        GrayFilter filter = new GrayFilter(true, p);
        FilteredImageSource prod = new FilteredImageSource(i.getSource(), filter);
        Image grayImage = Toolkit.getDefaultToolkit().createImage(prod);
        return grayImage;
    }

    private boolean useBrightDropDownArrow(AbstractButton b) {
        if (this.useBrightDropDownArrow != null) {
            return this.useBrightDropDownArrow;
        }
        this.useBrightDropDownArrow = b.getParent() != null && b.getParent().getClass().getName().contains("org.openide.awt.Toolbar") ? Boolean.valueOf(true) : Boolean.valueOf(false);
        return this.useBrightDropDownArrow;
    }

    static {
        POPUP_ICON_DISABLED = null;
        POPUP_ICON = Themes.isThemed() ? Themes.getActiveTheme().getPartProperties("toolbarbutton.drop").getIcon("icon") : MenuToolButton.POPUP_ICON;
        Icon icon = POPUP_ICON_BRIGHT = Themes.isThemed() ? Themes.getActiveTheme().getPartProperties("toolbarbutton.drop.bright").getIcon("icon") : MenuToolButton.POPUP_ICON;
        if (POPUP_ICON instanceof ImageIcon) {
            Image disabledImage = ((ImageIcon)POPUP_ICON).getImage();
            POPUP_ICON_DISABLED = GraphicsUtils.createImageIcon((Image)ActionMenuToolButton.createDisabledImage(disabledImage, 35));
        }
        POPUP_WIDTH = Math.max(3 + POPUP_ICON.getIconWidth() + 4, 13);
    }

    private final class ActionMenuToolButtonAccessibleContext
    extends AbstractButton.AccessibleAbstractButton {
        private ActionMenuToolButtonAccessibleContext() {
            super(ActionMenuToolButton.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }
    }

    private static final class ButtonCaptureAdapter
    implements MouseInputListener,
    ComponentListener,
    PropertyChangeListener {
        private BufferedImage _buttonImage;
        private boolean _captured;

        private ButtonCaptureAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!this._captured) {
                this.captureButtonImage(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.mouseEntered(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ActionMenuToolButton b = (ActionMenuToolButton)e.getComponent();
            if (!b._popupAlreadyShown && b.hasPopup() && b._popup.getComponentCount() > 0 && this.isInPopup(e)) {
                this.showPopupMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.uncaptureImage(e);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.uncaptureImage(e);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.uncaptureImage(e);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("icon") || propertyName.equals("foreground") || propertyName.equals("background") || propertyName.equals("border") || propertyName.equals("opaque") || propertyName.equals("contentAreaFilled") || propertyName.equals("borderPainted") || propertyName.equals("rolloverEnabled") || propertyName.equals("rolloverIcon") || propertyName.equals("UI")) {
                this.uncaptureImage(e);
            }
        }

        private void showPopupMenu(EventObject e) {
            ActionMenuToolButton b = (ActionMenuToolButton)e.getSource();
            if (!this._captured) {
                this.capturePopupImage(e);
            }
            b._capturedImage = this._captured ? this._buttonImage : null;
            MenuToolButtonUtils.showComponentPopupMenu(b, b._popup);
        }

        private void captureButtonImage(EventObject e) {
            AbstractButton b = (AbstractButton)e.getSource();
            if (b.isEnabled() && b.isRolloverEnabled()) {
                BufferedImage image = this.getBufferedImage(b);
                if (!b.getModel().isRollover()) {
                    b.getModel().setRollover(true);
                }
                Graphics2D g2 = image.createGraphics();
                g2.setClip(0, 0, b.getWidth() - POPUP_WIDTH, b.getHeight());
                b.paintAll(g2);
                g2.dispose();
            }
        }

        private void capturePopupImage(EventObject e) {
            AbstractButton b = (AbstractButton)e.getSource();
            if (b.isEnabled() && b.isRolloverEnabled()) {
                BufferedImage image = this.getBufferedImage(b);
                Graphics2D g2 = image.createGraphics();
                b.putClientProperty("capture", "down");
                b.paint(image.createGraphics());
                g2.setClip(b.getWidth() - POPUP_WIDTH, 0, POPUP_WIDTH, b.getHeight());
                b.paintAll(g2);
                g2.dispose();
                this._captured = true;
                b.putClientProperty("capture", null);
            }
        }

        private void uncaptureImage(EventObject e) {
            ActionMenuToolButton b = (ActionMenuToolButton)e.getSource();
            b._capturedImage = null;
            this._captured = false;
        }

        private BufferedImage getBufferedImage(AbstractButton b) {
            if (this._buttonImage == null) {
                this._buttonImage = new BufferedImage(b.getWidth(), b.getHeight(), 2);
            }
            return this._buttonImage;
        }

        private boolean isInPopup(MouseEvent e) {
            ActionMenuToolButton b = (ActionMenuToolButton)e.getComponent();
            return SwingUtilities.isLeftMouseButton(e) && b.isEnabled() && b.hasPopup() && b.contains(e.getX(), e.getY()) && e.getX() >= b.getWidth() - POPUP_WIDTH;
        }
    }

    protected static class FilterActionEvents
    implements ActionListener,
    Serializable {
        private ActionMenuToolButton _button;

        public FilterActionEvents(ActionMenuToolButton button) {
            this._button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.canPerformAction()) {
                this._button.fireActionPerformed(e);
            }
        }

        protected boolean canPerformAction() {
            return !this._button.isPopupVisible() && this._button._capturedImage == null;
        }
    }

    private static class ActionMenuButtonActionPropertyChangeListener
    extends ToolButton.DefaultActionPropertyChangeListener {
        public ActionMenuButtonActionPropertyChangeListener(ActionMenuToolButton button, Action action) {
            super(button, action);
        }

        protected void _propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("ActionMenuActions")) {
                this.menuActionsChanged(e);
            } else {
                super._propertyChange(e);
            }
        }

        protected void menuActionsChanged(PropertyChangeEvent e) {
            Action[] actions = (Action[])e.getNewValue();
            ActionMenuToolButton button = (ActionMenuToolButton)this.getAdaptee();
            button.setMenuActions(actions != null ? actions : NULL_ACTIONS);
        }
    }
}

