/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.util.Arrays;
import java.util.Comparator;
import javax.swing.DefaultComboBoxModel;

public class SortedComboBoxModel
extends DefaultComboBoxModel {
    private Comparator _comp = DEFAULT_COMPARATOR;
    public static final Comparator DEFAULT_COMPARATOR = new DefaultComparator();

    public void setComparator(Comparator comp) {
        if (comp == null) {
            comp = DEFAULT_COMPARATOR;
        }
        if (comp != this._comp) {
            this._comp = comp;
            Object[] objs = this.toArray();
            Arrays.sort(objs, this._comp);
            for (int i = 0; i < objs.length; ++i) {
                super.addElement(objs[i]);
            }
        }
    }

    @Override
    public void addElement(Object obj) {
        if (obj == null) {
            return;
        }
        Object[] objs = this.toArray();
        for (int i = 0; i < objs.length; ++i) {
            if (this._comp.compare(obj, objs[i]) >= 0) continue;
            this.add(i, obj);
            return;
        }
        super.addElement(obj);
    }

    private void add(int index, Object element) {
        this.insertElementAt(element, index);
    }

    private Object[] toArray() {
        Object[] arr = new Object[this.getSize()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.getElementAt(i);
        }
        return arr;
    }

    private static final class DefaultComparator
    implements Comparator {
        private DefaultComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = o1.toString();
            String s2 = o2.toString();
            return s1.compareTo(s2);
        }
    }
}

