/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs;

import java.awt.Dimension;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.DialogSizeKeeper;

public class SizeKeeperCallback
implements DialogRunnerCallback {
    private final String _key;
    private String _defaultHeight;
    private String _defaultWidth;
    private static final String WIDTH_KEY = ".width";
    private static final String HEIGHT_KEY = ".height";

    public SizeKeeperCallback(String key) {
        this._key = key;
    }

    public SizeKeeperCallback(String key, Dimension defaultSize) {
        this(key);
        if (defaultSize != null) {
            this._defaultWidth = String.valueOf(defaultSize.width);
            this._defaultHeight = String.valueOf(defaultSize.height);
        }
    }

    public void dialogAboutToRun(JDialog dlg) {
        DialogSizeKeeper.attachToComponent(dlg, this._key);
        if (dlg instanceof JEWTDialog) {
            String sheight;
            String swidth;
            JEWTDialog jewtDialog = (JEWTDialog)dlg;
            if (this._defaultWidth != null && this._defaultHeight != null) {
                swidth = Ide.getProperty(this._key + WIDTH_KEY, this._defaultWidth);
                sheight = Ide.getProperty(this._key + HEIGHT_KEY, this._defaultHeight);
            } else {
                swidth = Ide.getProperty(this._key + WIDTH_KEY);
                sheight = Ide.getProperty(this._key + HEIGHT_KEY);
            }
            if (swidth != null && sheight != null) {
                Dimension initialSize = new Dimension(Integer.parseInt(swidth), Integer.parseInt(sheight));
                jewtDialog.setMaximumInitialSize(initialSize);
                jewtDialog.setMinimumSize(jewtDialog.getPreferredSize());
                jewtDialog.setPreferredSize(initialSize);
            }
        }
    }

    public String getKey() {
        return this._key;
    }
}

