/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.explorer;

import javax.swing.Icon;
import oracle.ide.model.DefaultDisplayable;
import oracle.ide.model.Displayable;

public class IconOverlay {
    private final Displayable _displayable;

    public IconOverlay(Displayable displayable) {
        this._displayable = displayable;
    }

    public IconOverlay(Icon icon) {
        this(icon, null, null);
    }

    public IconOverlay(final Icon icon, final String shortLabel, final String toolTipText) {
        this._displayable = new DefaultDisplayable(){

            @Override
            public final String getShortLabel() {
                return shortLabel;
            }

            @Override
            public final Icon getIcon() {
                return icon;
            }

            @Override
            public final String getToolTipText() {
                return toolTipText;
            }
        };
    }

    public Displayable getDisplayable() {
        return this._displayable;
    }

    public String getShortLabel() {
        return this._displayable != null ? this._displayable.getShortLabel() : null;
    }

    public Icon getIcon() {
        return this._displayable != null ? this._displayable.getIcon() : null;
    }

    public String getToolTipText() {
        return this._displayable != null ? this._displayable.getToolTipText() : null;
    }
}

