/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.extension.rules.functions;

import java.net.URL;
import java.util.Map;
import oracle.ide.extension.rules.RuleEvaluationContext;
import oracle.ide.extension.rules.RuleEvaluationException;
import oracle.ide.extension.rules.RuleFunction;
import oracle.ide.extension.rules.RuleFunctionParameter;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;

public final class ContextObjectIsNamed
extends RuleFunction {
    private static final String WORKSPACE = "workspace-name";
    private static final String PROJECT = "project-name";
    private static final String NODE = "node-name";

    @Override
    public boolean evaluate(RuleEvaluationContext ruleContext, Map<String, RuleFunctionParameter> parameters) throws RuleEvaluationException {
        String[] contexts;
        for (String contextName : contexts = new String[]{WORKSPACE, PROJECT, NODE}) {
            try {
                RuleFunctionParameter param = this.getRequiredParameterOrThrow(parameters, contextName);
                Node locatable = null;
                if (param.getName().equals(WORKSPACE)) {
                    locatable = ruleContext.getIdeContext().getWorkspace();
                } else if (param.getName().equals(PROJECT)) {
                    locatable = ruleContext.getIdeContext().getProject();
                } else if (param.getName().equals(NODE)) {
                    locatable = ruleContext.getIdeContext().getNode();
                }
                if (locatable != null) {
                    URL url = locatable.getURL();
                    if (url == null) {
                        return false;
                    }
                    String locatableName = URLFileSystem.getFileName((URL)url);
                    return locatableName.equals(param.getValue());
                }
            }
            catch (RuleEvaluationException rve) {
                continue;
            }
            return false;
        }
        return false;
    }
}

