/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import oracle.ide.Ide;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.util.Assert;

public class DialogWatcher
implements AWTEventListener {
    private static DialogWatcher INSTANCE;

    private DialogWatcher() {
    }

    public static void install() {
        Assert.check((INSTANCE == null ? 1 : 0) != 0);
        INSTANCE = new DialogWatcher();
        Toolkit tk = Toolkit.getDefaultToolkit();
        tk.addAWTEventListener(INSTANCE, 64L);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        int eventID = event.getID();
        switch (eventID) {
            case 200: {
                this.whenWindowOpened((WindowEvent)event);
            }
        }
    }

    private void whenWindowOpened(WindowEvent event) {
        JDialog dialog;
        JRootPane rootPane;
        InputMap inputMap;
        Window window = event.getWindow();
        if (window instanceof JDialog && !this.hasMultiInputMap(inputMap = (rootPane = (dialog = (JDialog)window).getRootPane()).getInputMap(1))) {
            this.addInputMap(rootPane);
        }
    }

    private boolean hasMultiInputMap(InputMap inputMap) {
        if (inputMap == null) {
            return false;
        }
        if (inputMap instanceof MultiInputMap) {
            return true;
        }
        return this.hasMultiInputMap(inputMap.getParent());
    }

    private void addInputMap(JRootPane rootPane) {
        ActionMap newActionMap = new ActionMap();
        MultiInputMap multiInputMap = new MultiInputMap();
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap globalKeyMap = keyStrokeOptions.getGlobalKeyMap();
        this.addKeys(globalKeyMap, multiInputMap, newActionMap, 17);
        this.addKeys(globalKeyMap, multiInputMap, newActionMap, 18);
        this.addKeys(globalKeyMap, multiInputMap, newActionMap, 19);
        if (multiInputMap.size() > 0) {
            InputMap inputMap = rootPane.getInputMap(1);
            multiInputMap.setParent(inputMap);
            rootPane.setInputMap(1, multiInputMap);
            ActionMap actionMap = rootPane.getActionMap();
            newActionMap.setParent(actionMap);
            rootPane.setActionMap(newActionMap);
        }
    }

    private void addKeys(KeyStrokeMap globalKeyMap, MultiInputMap inputMap, ActionMap actionMap, int commandId) {
        InputMap installed = (InputMap)UIManager.get("TextArea.focusInputMap");
        Integer bind = commandId;
        ActionDelegate actionDelegate = new ActionDelegate(commandId);
        List<KeyStrokes> keyStrokeList = globalKeyMap.getKeyStrokesFor(commandId);
        for (int i = 0; i < keyStrokeList.size(); ++i) {
            KeyStroke keyStroke;
            KeyStrokes keyStrokes = keyStrokeList.get(i);
            if (keyStrokes.getLength() == 1 && installed.get(keyStroke = keyStrokes.getKeyStroke(0)) != null) continue;
            inputMap.put(keyStrokes, (Object)bind);
            actionMap.put(bind, actionDelegate);
        }
    }

    static class ActionDelegate
    extends AbstractAction {
        private int _commandID;

        public ActionDelegate(int commandID) {
            this._commandID = commandID;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component sourceComponent;
            Window windowAncestor;
            Component focusOwner;
            Object source = e.getSource();
            if (source instanceof Component && (focusOwner = (windowAncestor = SwingUtilities.getWindowAncestor(sourceComponent = (Component)source)).getFocusOwner()) instanceof JTextComponent) {
                JTextComponent textComponent = (JTextComponent)focusOwner;
                switch (this._commandID) {
                    case 17: {
                        textComponent.cut();
                        break;
                    }
                    case 18: {
                        textComponent.copy();
                        break;
                    }
                    case 19: {
                        textComponent.paste();
                    }
                }
            }
        }
    }
}

