/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.lang.ref.WeakReference;
import javax.swing.InputMap;
import javax.swing.JComponent;
import oracle.ide.keyboard.IdeInputMapUIResource;
import oracle.ide.keyboard.MultiInputMap;

public final class GrabbableFocusManager
implements KeyEventDispatcher {
    private static GrabbableFocusManager INSTANCE;
    private WeakReference<Component> _lastFocusedComponent;
    private boolean _lastFocusedComponentHadMultiInputMap;
    private WeakReference<Component> _lastPressed;
    private Component _eatTyped;
    private Component _eatReleased;

    private GrabbableFocusManager() {
    }

    public static GrabbableFocusManager install() {
        if (INSTANCE == null) {
            GrabbableFocusManager gfm = new GrabbableFocusManager();
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            if (kfm instanceof DefaultKeyboardFocusManager) {
                kfm.addKeyEventDispatcher(gfm);
                INSTANCE = gfm;
            }
        }
        return INSTANCE;
    }

    public static GrabbableFocusManager getGrabbableFocusManager() {
        return INSTANCE;
    }

    public void eatNextTypedReleased() {
        this._eatReleased = this._lastPressed == null ? null : (Component)this._lastPressed.get();
        this._eatTyped = this._eatReleased;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent anEvent) {
        Component focusedComponent = anEvent.getComponent();
        boolean hasMultiInputMap = this.hasMultiInputMap(focusedComponent);
        IdeInputMapUIResource.setMustIgnore(hasMultiInputMap);
        return this.processKeyEvent_eat(focusedComponent, anEvent);
    }

    private boolean hasMultiInputMap(Component focusedComponent) {
        if (this._lastFocusedComponent == null || this._lastFocusedComponent.get() != focusedComponent) {
            this._lastFocusedComponent = new WeakReference<Component>(focusedComponent);
            this._lastFocusedComponentHadMultiInputMap = false;
            while (!this._lastFocusedComponentHadMultiInputMap && focusedComponent instanceof JComponent) {
                JComponent component = (JComponent)focusedComponent;
                for (InputMap inputMap = component.getInputMap(1); !this._lastFocusedComponentHadMultiInputMap && inputMap != null; inputMap = inputMap.getParent()) {
                    if (!(inputMap instanceof MultiInputMap)) continue;
                    this._lastFocusedComponentHadMultiInputMap = true;
                }
                focusedComponent = focusedComponent.getParent();
            }
        }
        return this._lastFocusedComponentHadMultiInputMap;
    }

    private boolean processKeyEvent_eat(Component focusedComponent, KeyEvent anEvent) {
        switch (anEvent.getID()) {
            case 401: {
                this._lastPressed = new WeakReference<Component>(focusedComponent);
                if (this._eatTyped == null || this._eatTyped == focusedComponent) break;
                this._eatReleased = null;
                this._eatTyped = null;
                break;
            }
            case 400: {
                if (this._eatTyped == null) break;
                if (this._eatTyped == focusedComponent) {
                    this._eatTyped = null;
                    anEvent.consume();
                    break;
                }
                this._eatReleased = null;
                this._eatTyped = null;
                break;
            }
            case 402: {
                if (this._eatReleased == null) break;
                if (this._eatReleased == focusedComponent) {
                    this._eatTyped = null;
                    this._eatReleased = null;
                    anEvent.consume();
                    break;
                }
                this._eatReleased = null;
                this._eatTyped = null;
            }
        }
        return anEvent.isConsumed();
    }
}

