/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.keyboard;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.GrabbableFocusManager;
import oracle.ide.keyboard.KeyStrokes;
import oracle.ide.keyboard.KeyUtil;

public final class MultiInputMap
extends InputMap {
    public static final Action NULL_ACTION = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    public static final Object NULL_ACTION_BIND = NULL_ACTION;
    private final HashMap _map = new HashMap();
    private static final KeyStrokes _sequence = new KeyStrokes();
    private boolean _bTerminator = false;

    public MultiInputMap() {
        this(false);
    }

    public MultiInputMap(boolean bTerminator) {
        this._bTerminator = bTerminator;
    }

    public static boolean isInKeySequence() {
        return _sequence.getLength() != 0;
    }

    private static void reset() {
        _sequence.clear();
    }

    private static boolean isRepeat(KeyStroke ks) {
        boolean bRet = false;
        KeyStroke ksLast = _sequence.getLast();
        if (ksLast != null && ks.equals(ksLast)) {
            bRet = true;
        }
        return bRet;
    }

    @Override
    public Object get(KeyStroke keyStroke) {
        Object ret = null;
        if (!(keyStroke.getKeyChar() != '\uffff' || keyStroke.isOnKeyRelease() || KeyUtil.isModifierKey(keyStroke) || MultiInputMap.isRepeat(keyStroke))) {
            _sequence.add(keyStroke);
            ret = this._map.get(_sequence);
            if (ret == null) {
                InputMap parent;
                if (_sequence.getLength() == 1 && (parent = this.getParent()) != null) {
                    ret = parent.get(keyStroke);
                }
                if (this._bTerminator) {
                    _sequence.clear();
                } else {
                    _sequence.removeLast();
                }
            } else if (ret != NULL_ACTION_BIND) {
                _sequence.clear();
                Action actionObj = Ide.getIdeActionMap().get(ret);
                if (actionObj instanceof IdeAction) {
                    ((IdeAction)actionObj).updateAction();
                }
            }
        }
        if (ret != null) {
            GrabbableFocusManager gfm = GrabbableFocusManager.getGrabbableFocusManager();
            gfm.eatNextTypedReleased();
        }
        return ret;
    }

    public void put(KeyStrokes keyStrokes, Object actionMapKey) {
        this._map.put(keyStrokes, actionMapKey);
        if (keyStrokes.getLength() > 1) {
            this.put(keyStrokes.getKeyStroke(0), NULL_ACTION_BIND);
        }
    }

    @Override
    public void put(KeyStroke keyStroke, Object actionMapKey) {
        this.put(new KeyStrokes(keyStroke), actionMapKey);
    }

    @Override
    public void remove(KeyStroke key) {
        this._map.remove(key);
        MultiInputMap.reset();
    }

    @Override
    public void clear() {
        this._map.clear();
        MultiInputMap.reset();
    }

    @Override
    public KeyStroke[] keys() {
        Set keys = this._map.keySet();
        KeyStroke[] ret = new KeyStroke[keys.size()];
        Iterator i = keys.iterator();
        int j = 0;
        while (i.hasNext()) {
            KeyStrokes kss = (KeyStrokes)i.next();
            if (kss.getLength() != 1) continue;
            ret[j++] = kss.getKeyStroke(0);
        }
        return ret;
    }

    @Override
    public int size() {
        return this._map.size();
    }
}

