/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.util.MetaClass;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.model.Node;
import oracle.ide.model.RootElementRecognizerHookHelper;
import oracle.ide.xml.XMLRecognizer;
import oracle.javatools.data.HashStructure;

class DocTypeRecognizerHookHelper {
    static Map<XMLRecognizer.Doctype, MetaClass<Node>> findDocTypeMappings(HashStructure hs) {
        return Collections.unmodifiableMap(DocTypeRecognizerHookHelper.buildDocTypeMappings(hs));
    }

    private static Map<XMLRecognizer.Doctype, MetaClass<Node>> buildDocTypeMappings(HashStructure hs) {
        HashMap<XMLRecognizer.Doctype, MetaClass<Node>> mappings = new HashMap<XMLRecognizer.Doctype, MetaClass<Node>>();
        List xmlRecognizers = hs.getAsList("xml-recognizer");
        if (xmlRecognizers == null) {
            return mappings;
        }
        for (Object o : xmlRecognizers) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            DocTypeRecognizerHookHelper.addDocTypeMapping(childHs, mappings);
        }
        return mappings;
    }

    private static void addDocTypeMapping(HashStructure hs, Map<XMLRecognizer.Doctype, MetaClass<Node>> mappings) {
        List docTypes = hs.getAsList("doctype");
        if (docTypes == null) {
            return;
        }
        for (Object o : docTypes) {
            if (!(o instanceof HashStructure)) continue;
            HashStructure childHs = (HashStructure)o;
            String publicId = childHs.getString("public-id/#text");
            String systemId = childHs.getString("system-id/#text");
            LazyClassAdapter adapter = LazyClassAdapter.getInstance(childHs);
            MetaClass metaClass = adapter.getMetaClass("node-type/#text");
            RootElementRecognizerHookHelper.registerXMLExtension(childHs);
            mappings.put(new XMLRecognizer.Doctype(publicId, systemId), metaClass);
        }
    }

    private DocTypeRecognizerHookHelper() {
    }
}

