/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.model.concurrent;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import oracle.ide.model.concurrent.CallableResultHandler;

public final class AsynchronousCallableCompletionService<T> {
    private final CompletionService<T> completionService;
    private final ExecutorService executorService;
    private final Set<Future<T>> futuresInProgress;
    private final ExecutorService futuresProcessingExecutor = Executors.newSingleThreadExecutor();
    private volatile CallableResultHandler<T> onDequeue;
    private Thread futuresProcessor = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                Future future;
                Set set = AsynchronousCallableCompletionService.this.futuresInProgress;
                synchronized (set) {
                    while (AsynchronousCallableCompletionService.this.futuresInProgress.isEmpty()) {
                        try {
                            AsynchronousCallableCompletionService.this.futuresInProgress.wait();
                        }
                        catch (InterruptedException e) {
                            System.out.println("The current thread has been interrupted while waiting.\nDrop what you're doing and return. ");
                            return;
                        }
                    }
                }
                if (AsynchronousCallableCompletionService.this.executorService.isShutdown()) continue;
                try {
                    future = AsynchronousCallableCompletionService.this.completionService.take();
                }
                catch (InterruptedException e) {
                    System.out.println("The current thread has been interrupted while dequeuing a\nFuture off the queue completion service. Return.");
                    return;
                }
                assert (future != null);
                assert (future.isDone());
                if (!future.isCancelled()) {
                    try {
                        AsynchronousCallableCompletionService.this.onDequeue.onCompletion(future.get());
                    }
                    catch (InterruptedException e) {
                        System.out.println("Interrupted while invoking Future.get. Returning");
                        e.printStackTrace();
                        return;
                    }
                    catch (ExecutionException e) {
                        AsynchronousCallableCompletionService.this.onDequeue.onException(e);
                    }
                }
                boolean removedSuceeded = false;
                Set set2 = AsynchronousCallableCompletionService.this.futuresInProgress;
                synchronized (set2) {
                    removedSuceeded = AsynchronousCallableCompletionService.this.futuresInProgress.remove(future);
                }
                assert (removedSuceeded);
            }
        }
    };

    public AsynchronousCallableCompletionService(ExecutorService executor, CallableResultHandler<T> asyncContentLevelCallback) {
        this.onDequeue = asyncContentLevelCallback;
        this.executorService = executor;
        this.completionService = new ExecutorCompletionService<T>(executor);
        this.futuresInProgress = Collections.synchronizedSet(new HashSet());
        this.futuresProcessingExecutor.execute(this.futuresProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(Callable<T> task) {
        if (this.isShutdown()) {
            throw new RejectedExecutionException("Service is shut down. No further tasks may be submitted");
        }
        Set<Future<T>> set = this.futuresInProgress;
        synchronized (set) {
            this.futuresInProgress.add(this.completionService.submit(task));
            this.futuresInProgress.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow(boolean mayInterruptIfRunning) {
        Set<Future<T>> set = this.futuresInProgress;
        synchronized (set) {
            this.futuresProcessor.interrupt();
            this.executorService.shutdownNow();
            this.cancelAllQueuedFutures(mayInterruptIfRunning);
        }
    }

    public boolean isShutdown() {
        return this.executorService == null ? true : this.executorService.isShutdown();
    }

    public boolean isTerminated() {
        return this.executorService == null ? true : this.executorService.isTerminated();
    }

    private void cancelAllQueuedFutures(boolean mayInterruptIfRunning) {
        for (Future<T> nextUncancelledFuture : this.futuresInProgress) {
            nextUncancelledFuture.cancel(mayInterruptIfRunning);
        }
        this.futuresInProgress.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int operationsInProgressSize() {
        Set<Future<T>> set = this.futuresInProgress;
        synchronized (set) {
            return this.futuresInProgress.size();
        }
    }
}

