/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import javax.ide.util.MetaClass;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.refactoring.BaseActionHandler;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;

final class ActionHandlerInfo
extends HashStructureAdapter {
    static final String ACTIONHANDLER_CLASS = "actionhandler-class";
    static final String ACTIONHANDLER_OPERATION = "operation";
    static final String ACTIONHANDLER_ELEMENT_CLASS = "element-class";
    static final String BYPASSED_GLOBAL_ACTION_HANDLER_VALIDATOR_CLASSES = "bypassed-global-action-handler-validator-classes";
    static final String EXTENSION_ID = "#__extension-id";

    ActionHandlerInfo(HashStructure hash) {
        super(hash);
    }

    BaseActionHandler getActionHandler() {
        return LazyClassAdapter.getInstance(this._hash).createInstance(BaseActionHandler.class, ACTIONHANDLER_CLASS);
    }

    Class<? extends BaseActionHandler> getActionHandlerClass() {
        Class<BaseActionHandler> cls = this.getClass(ACTIONHANDLER_CLASS, BaseActionHandler.class);
        if (cls == null) {
            String extensionId = this._hash.getString(EXTENSION_ID);
            String handlerClsName = this._hash.getString(ACTIONHANDLER_CLASS);
            if (handlerClsName != null) {
                throw new NullPointerException("Action handler class " + handlerClsName + " could not be resolved in extension " + extensionId + "!");
            }
            throw new NullPointerException("Class attribute missing from handler declaration in extension " + extensionId + "!");
        }
        return cls;
    }

    String getActionHandlerOperation() {
        String actionHandlerOperation = this._hash.getString(ACTIONHANDLER_OPERATION);
        if (actionHandlerOperation == null || "".equals(actionHandlerOperation)) {
            String extensionId = this._hash.getString(EXTENSION_ID);
            throw new NullPointerException("Action handler service operation not specified in extension " + extensionId + "!");
        }
        return actionHandlerOperation;
    }

    Class getActionHandlerElementClass() {
        Class<Object> cls = this.getClass(ACTIONHANDLER_ELEMENT_CLASS, Object.class);
        if (cls == null) {
            String extensionId = this._hash.getString(EXTENSION_ID);
            String elementClsName = this._hash.getString(ACTIONHANDLER_ELEMENT_CLASS);
            if (elementClsName != null) {
                throw new NullPointerException("Action handler element class " + elementClsName + " could not be resolved in extension " + extensionId + "!");
            }
            throw new NullPointerException("Class attribute missing from handler declaration in extension " + extensionId + "!");
        }
        return cls;
    }

    String getActionHandlerClassName() {
        String name = this._hash.getString(ACTIONHANDLER_CLASS);
        if (name == null) {
            String extensionId = this._hash.getString(EXTENSION_ID);
            throw new NullPointerException("Class attribute missing from handler declaration in extension " + extensionId + "!");
        }
        return name;
    }

    String[] getBypassedGlobalActionHandlerValidatorClasses() {
        String name = this._hash.getString(BYPASSED_GLOBAL_ACTION_HANDLER_VALIDATOR_CLASSES);
        if (name == null) {
            return new String[0];
        }
        String[] names = name.split(" *, *");
        for (int i = 0; i < names.length; ++i) {
            names[i] = names[i].trim();
        }
        return names;
    }

    String getActionHandlerExtensionId() {
        return this._hash.getString(EXTENSION_ID);
    }

    String getActionHandlerElementClassName() {
        String name = this._hash.getString(ACTIONHANDLER_ELEMENT_CLASS);
        if (name == null) {
            String extensionId = this._hash.getString(EXTENSION_ID);
            throw new NullPointerException("Element class attribute missing from handler declaration in extension " + extensionId + "!");
        }
        return name;
    }

    private <T> Class<? extends T> getClass(String key, Class<T> clazz) {
        try {
            MetaClass metaClass = LazyClassAdapter.getInstance(this._hash).getMetaClass(key);
            if (metaClass != null) {
                return metaClass.toClass().asSubclass(clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }
}

