/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.refactoring.AbstractActionHandlerService;
import oracle.ide.refactoring.BaseActionHandler;
import oracle.ide.refactoring.CompositeMoveHandler;
import oracle.ide.refactoring.GlobalActionHandlerValidator;
import oracle.ide.refactoring.MoveActionHandler;
import oracle.ide.refactoring.MoveArchiveContentsValidator;
import oracle.ide.util.Assert;

public final class MoveHandlerService
extends AbstractActionHandlerService<MoveActionHandler> {
    private static MoveHandlerService INSTANCE = new MoveHandlerService();
    private final GlobalActionHandlerValidator<MoveActionHandler>[] _globalValidations = new GlobalActionHandlerValidator[]{new MoveArchiveContentsValidator()};

    private MoveHandlerService() {
    }

    public static void registerActionHandler(Class<? extends Element> classKey, Class<? extends MoveActionHandler> refactoringActionHandlerClass) {
        INSTANCE._registerActionHandler(classKey, refactoringActionHandlerClass);
    }

    public static void registerActionHandler(String elementClassName, String refactoringActionHandlerClassName, String extensionId) {
        INSTANCE._registerActionHandler(elementClassName, refactoringActionHandlerClassName, extensionId, new String[0]);
    }

    static void registerActionHandler(String elementClassName, String refactoringActionHandlerClassName, String extensionId, String[] bypassedGlobalActionHandlerValidatorClasses) {
        INSTANCE._registerActionHandler(elementClassName, refactoringActionHandlerClassName, extensionId, bypassedGlobalActionHandlerValidatorClasses);
    }

    public static void registerLookupHelper(BaseActionHandler.LookupHelper<? extends MoveActionHandler> lookupHelper) {
        INSTANCE._registerLookupHelper(lookupHelper);
    }

    public static MoveActionHandler createMoveHandler(Context context) {
        MoveActionHandler moveActionHandler;
        if (context.containsProperty(MoveActionHandler.class.getName()) && (moveActionHandler = (MoveActionHandler)context.getProperty(MoveActionHandler.class.getName())) != null) {
            return moveActionHandler;
        }
        return INSTANCE._createActionHandler(context);
    }

    @Override
    protected MoveActionHandler _createActionHandler(Context context) {
        MoveActionHandler globalValidationHandler;
        Element[] selections = context.getSelection();
        Assert.check((selections != null && selections.length > 0 ? 1 : 0) != 0);
        ArrayList<Element> stillActiveSelections = new ArrayList<Element>(Arrays.asList(selections));
        List<Class<Element>> selectedSubtypes = this.getAllSelectedElementSubtypes(context.getSelection());
        HashMap<AbstractActionHandlerService.HandlerData, List<Element>> handlers = new HashMap<AbstractActionHandlerService.HandlerData, List<Element>>();
        for (Class<Element> elementSubtype : selectedSubtypes) {
            if (stillActiveSelections.isEmpty()) break;
            AbstractActionHandlerService.HandlerData actionHandlerData = this.getHandlerData(elementSubtype, context);
            if (actionHandlerData == null) continue;
            ArrayList<Element> arrayList = new ArrayList<Element>();
            ListIterator iter = stillActiveSelections.listIterator();
            while (iter.hasNext()) {
                Element e = (Element)iter.next();
                if (elementSubtype.isInstance(e)) {
                    arrayList.add(e);
                    iter.remove();
                    continue;
                }
                Class nextElementHandlerClass = this._getHandlerClass(e.getClass(), context);
                if (nextElementHandlerClass == null || !actionHandlerData.getActionHandlerClass().equals(nextElementHandlerClass)) continue;
                arrayList.add(e);
                iter.remove();
            }
            if (arrayList.isEmpty()) continue;
            handlers.put(actionHandlerData, arrayList);
        }
        if ((globalValidationHandler = this.checkGlobalActionHandlerValidators(context, handlers, this._globalValidations)) != null) {
            return globalValidationHandler;
        }
        try {
            if (handlers.size() == 1) {
                Iterator iter = handlers.entrySet().iterator();
                final Map.Entry entry = iter.next();
                Constructor constructor = ((AbstractActionHandlerService.HandlerData)entry.getKey()).getActionHandlerClass().getConstructor(Context.class);
                context.setProperty(MoveActionHandler.SelectedElementProvider.class.getName(), new MoveActionHandler.SelectedElementProvider(){

                    public List<? extends Element> getSelectedElements() {
                        return (List)entry.getValue();
                    }
                });
                return (MoveActionHandler)constructor.newInstance(context);
            }
            if (handlers.size() > 1) {
                HashSet<MoveActionHandler> actionHandlers = new HashSet<MoveActionHandler>();
                for (Map.Entry entry : handlers.entrySet()) {
                    Constructor c = ((AbstractActionHandlerService.HandlerData)entry.getKey()).getActionHandlerClass().getConstructor(Context.class);
                    final List selectedElements = (List)entry.getValue();
                    context.setProperty(MoveActionHandler.SelectedElementProvider.class.getName(), new MoveActionHandler.SelectedElementProvider(){

                        public List<? extends Element> getSelectedElements() {
                            return selectedElements;
                        }
                    });
                    MoveActionHandler actionHandler = (MoveActionHandler)c.newInstance(context);
                    actionHandlers.add(actionHandler);
                }
                CompositeMoveHandler composite = new CompositeMoveHandler(actionHandlers);
                return composite;
            }
        }
        catch (InstantiationException e) {
            Assert.fail((Exception)e);
        }
        catch (NoSuchMethodException e) {
            Assert.fail((Exception)e);
        }
        catch (InvocationTargetException e) {
            Assert.fail((Exception)e);
        }
        catch (IllegalAccessException e) {
            Assert.fail((Exception)e);
        }
        return null;
    }
}

