/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JFrame;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.refactoring.AbstractRenameActionHandler;
import oracle.ide.refactoring.ActionHandlerConfirmationDialog;
import oracle.ide.resource.RenameDialogArb;
import org.openide.util.RequestProcessor;

public abstract class SimpleRenameActionHandler<T extends Element>
extends AbstractRenameActionHandler<T> {
    private static final RequestProcessor processor = new RequestProcessor(SimpleRenameActionHandler.class);
    private ActionHandlerConfirmationDialog confirmationDialog;

    protected SimpleRenameActionHandler(Context context) {
        super(context);
    }

    @Override
    public final void doit() {
        this.confirmationDialog = this.createRenameConfirmationDialog((JFrame)((Object)Ide.getMainWindow()));
        if (this.runDialog()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SimpleRenameActionHandler.this.doRename();
                }
            };
            if (EventQueue.isDispatchThread()) {
                processor.execute(runnable);
            } else {
                runnable.run();
            }
        }
    }

    protected abstract boolean doRename();

    protected abstract Component createDialogContent();

    protected Component createRenameDetailsComponent() {
        return null;
    }

    protected final void setStatus(String text, Icon icon) {
        this.confirmationDialog.setStatus(text, icon);
    }

    protected final void clearStatus() {
        this.setStatus("", null);
    }

    protected final void renameDetailsAvailable(boolean detailsAvailable) {
        this.confirmationDialog.setDetailsAvailable(detailsAvailable);
    }

    private final ActionHandlerConfirmationDialog createRenameConfirmationDialog(JFrame dialogOwner) {
        ActionHandlerConfirmationDialog detailDialog = ActionHandlerConfirmationDialog.createDialog(dialogOwner, RenameDialogArb.getString(1), this.createDialogContent(), this.createRenameDetailsComponent());
        detailDialog.setButtonTextWhenDetailsHidden(RenameDialogArb.getString(3), true);
        detailDialog.setButtonTextWhenDetailsShown(RenameDialogArb.getString(4), false);
        detailDialog.setHelpTopicId("f1_rename_html");
        return detailDialog;
    }

    private boolean runDialog() {
        boolean ret = false;
        if (this.confirmationDialog.runDialog()) {
            ret = true;
        }
        this.confirmationDialog.dispose();
        return ret;
    }

    protected final void setOKButtonEnabled(boolean enabled) {
        if (this.confirmationDialog != null) {
            this.confirmationDialog.setOKButtonEnabled(enabled);
        }
    }

    public static boolean renameNode(Node element, String newName) {
        Node node = element;
        try {
            URL oldUrl = node.getURL();
            File file = new File(oldUrl.toURI());
            File parentFile = file.getParentFile();
            if (parentFile != null) {
                String newFilePath = new File(parentFile, newName).getPath();
                URL newUrl = URLFactory.newFileURL((String)newFilePath);
                boolean succeeded = URLFileSystem.renameTo((URL)node.getURL(), (URL)newUrl);
                return succeeded;
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return false;
    }
}

