/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.Arrays;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.ide.util.TriStateBoolean;

public final class IntersectedFilters {
    private final PatternFilters[] _filters;
    private final int _n;

    public IntersectedFilters(PatternFilters[] filters) {
        int okCount = 0;
        int n = filters.length;
        for (int i = 0; i < n; ++i) {
            if (filters[i] == null) continue;
            ++okCount;
        }
        if (okCount == n) {
            this._filters = filters;
            this._n = n;
        } else {
            PatternFilters[] trimmedFilters = new PatternFilters[okCount];
            int j = 0;
            for (int i = 0; i < n; ++i) {
                PatternFilters pf = filters[i];
                if (pf == null) continue;
                trimmedFilters[j++] = pf;
            }
            this._filters = trimmedFilters;
            this._n = okCount;
        }
    }

    public IntersectedFilters(IntersectedFilters ... filters) {
        this._filters = IntersectedFilters.intersect(filters);
        this._n = this._filters.length;
    }

    public IntersectedFilters(IntersectedFilters filters1, IntersectedFilters filters2) {
        this._filters = IntersectedFilters.intersect(filters1, filters2);
        this._n = this._filters.length;
    }

    public IntersectedFilters(PatternFilters filters1) {
        this(new PatternFilters[]{filters1});
    }

    public IntersectedFilters(PatternFilters filters1, PatternFilters filters2) {
        this(new PatternFilters[]{filters1, filters2});
    }

    public IntersectedFilters(PatternFilters filters1, PatternFilters filters2, PatternFilters filters3) {
        this(new PatternFilters[]{filters1, filters2, filters3});
    }

    public IntersectedFilters intersectWith(PatternFilters filters) {
        return filters != null ? new IntersectedFilters(IntersectedFilters.intersect(filters, this)) : this;
    }

    public IntersectedFilters intersectWith(IntersectedFilters filters) {
        return filters != null ? new IntersectedFilters(IntersectedFilters.intersect(filters, this)) : this;
    }

    public TriStateBoolean inferFromFilters(String relPath) {
        TriStateBoolean result = TriStateBoolean.TRUE;
        for (int i = 0; i < this._n; ++i) {
            PatternFilters pf = this._filters[i];
            if (!pf.containsFilters()) continue;
            TriStateBoolean bool = pf.inferFromFilters(relPath);
            if (bool.isFalse()) {
                return TriStateBoolean.FALSE;
            }
            result = result.and(bool);
        }
        return result;
    }

    public boolean isIncluded(String relPath) {
        for (int i = 0; i < this._n; ++i) {
            PatternFilters pf = this._filters[i];
            if (!pf.containsFilters() || pf.isIncluded(relPath)) continue;
            return false;
        }
        return true;
    }

    private static PatternFilters[] intersect(IntersectedFilters ... filters) {
        int length = 0;
        for (IntersectedFilters filter : filters) {
            if (filter == null) continue;
            length += filter._n;
        }
        PatternFilters[] result = new PatternFilters[length];
        int count = 0;
        for (IntersectedFilters filter : filters) {
            if (filter == null) continue;
            int n = filter._n;
            System.arraycopy(filter._filters, 0, result, count, n);
            count += n;
        }
        return result;
    }

    private static PatternFilters[] intersect(PatternFilters filters1, IntersectedFilters filters2) {
        int n1 = filters1 != null ? 1 : 0;
        int n2 = filters2 != null ? filters2._n : 0;
        int n = n1 + n2;
        PatternFilters[] filters = new PatternFilters[n];
        if (filters1 != null) {
            filters[0] = filters1;
        }
        if (filters2 != null) {
            System.arraycopy(filters2._filters, 0, filters, n1, n2);
        }
        return filters;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof IntersectedFilters && Arrays.equals((Object[])this._filters, (Object[])((IntersectedFilters)object)._filters);
    }

    public int hashCode() {
        int code = 0;
        for (int i = 0; i < this._n; ++i) {
            code = code * 37 + this._filters[i].hashCode();
        }
        return code;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("IntersectedFilters [");
        for (int i = 0; i < this._n; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            PatternFilter[] filters = this._filters[i].getFilters();
            builder.append("[");
            for (int j = 0; j < filters.length; ++j) {
                if (j > 0) {
                    builder.append(",");
                }
                builder.append(filters[j]);
            }
            builder.append("]");
        }
        builder.append("]");
        return builder.toString();
    }
}

