/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking.shutter;

import java.awt.Component;
import java.awt.Container;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.ide.Ide;
import oracle.ide.controls.GlobalMouseDispatcher;
import oracle.ide.util.Assert;
import oracle.ide.view.TitledContainer;
import oracle.ideimpl.docking.TitledPanelHolder;
import oracle.ideimpl.docking.shutter.ShutterManager;
import oracle.ideimpl.docking.shutter.ShutterMargin;
import oracle.ideimpl.docking.shutter.ShutterPanel;
import oracle.ideimpl.docking.shutter.ShutterTab;

public final class MouseActivationController {
    private static final int STATE_NORMAL = 0;
    private static final int STATE_RAISED = 1;
    private static final int STATE_RAISE_PENDING = 2;
    private static final int STATE_RERAISE_PENDING = 3;
    private static final int STATE_HIDE_PENDING = 4;
    private static final int DEFAULT_RAISE_DELAY_MSEC = 400;
    private static final int DEFAULT_RERAISE_DELAY_MSEC = 125;
    private static final int DEFAULT_HIDE_DELAY_MSEC = 400;
    private static final int DEFAULT_HIDE_TOGGLE_DELAY_MSEC = 500;
    private static final int DEFAULT_AUTO_EXTEND_RAISE_DELAY_MSEC = 400;
    private final EventListener _eventListener = new EventListener();
    private int _state;
    private Timer _timer;
    private ShutterTab _shutterTab;
    private TitledPanelHolder _holder;
    private long _autoRaiseTime;
    private transient boolean _listening;
    private boolean forAutoExpand;
    private int raiseDelay = 400;
    private static final double DELTA_IN_DISTANCE_THAT_SIGNIFIES_STOP = 2.0;
    private Point _lastMousePosition = null;

    public MouseActivationController() {
        this(false);
    }

    public int raiseDelay() {
        return this.raiseDelay;
    }

    public void raiseDelay(int newValue) {
        this.raiseDelay = newValue;
    }

    public void reset() {
        this.startHideTimer();
    }

    public MouseActivationController(boolean forAutoExpand) {
        this.forAutoExpand = forAutoExpand;
    }

    public void raiseInHolder(ShutterTab shutterTab, TitledPanelHolder holder) {
        if (this.getState() == 0) {
            this._shutterTab = shutterTab;
            this._holder = holder;
            this.startRaiseTimer();
        }
    }

    public void mouseEntered(ShutterTab shutterTab, TitledPanelHolder holder) {
        switch (this.getState()) {
            case 0: {
                break;
            }
            case 1: {
                if (this._shutterTab == shutterTab && this._holder == holder) break;
                this._shutterTab = shutterTab;
                this._holder = holder;
                this.startReraiseTimer();
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            default: {
                this.assertUnexpectedState();
            }
        }
    }

    public void mouseMoved(ShutterTab shutterTab, TitledPanelHolder holder) {
        switch (this.getState()) {
            case 0: {
                Point presentMouseLocation = MouseInfo.getPointerInfo().getLocation();
                if (this._lastMousePosition == null) {
                    this._lastMousePosition = presentMouseLocation;
                    this._shutterTab = shutterTab;
                    this._holder = holder;
                    break;
                }
                if (this._shutterTab == shutterTab && this._holder == holder) {
                    double dist = this._lastMousePosition.distance(presentMouseLocation.getX(), presentMouseLocation.getY());
                    if (dist < 2.0) {
                        this._lastMousePosition = null;
                        this.startRaiseTimer();
                        break;
                    }
                    this._lastMousePosition = presentMouseLocation;
                    break;
                }
                this._shutterTab = shutterTab;
                this._holder = holder;
                this._lastMousePosition = presentMouseLocation;
                break;
            }
            case 2: {
                this.stopTimer();
                this._shutterTab = shutterTab;
                this._holder = holder;
                this.startRaiseTimer();
                break;
            }
            case 3: {
                this.stopTimer();
                this._shutterTab = shutterTab;
                this._holder = holder;
                this.startReraiseTimer();
                break;
            }
            case 4: {
                this.stopTimer();
                this.setState(1);
                this.mouseEntered(shutterTab, holder);
                break;
            }
            default: {
                this.mouseEntered(shutterTab, holder);
            }
        }
    }

    public void mouseExited(ShutterTab shutterTab) {
        int state = this.getState();
        switch (state) {
            case 3: {
                this.stopTimer();
                this.setState(1);
                break;
            }
            case 2: {
                this.stopTimer();
                this._shutterTab = null;
                this._holder = null;
                this.setState(0);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(ShutterTab shutterTab, TitledPanelHolder holder) {
        int flags = 4;
        switch (this.getState()) {
            case 0: {
                this._shutterTab = shutterTab;
                this._holder = holder;
                this._shutterTab.raisePanel(this._holder, 4);
                this.setState(1);
                this.addGlobalMouseListener();
                break;
            }
            case 2: {
                this.stopTimer();
                this.addGlobalMouseListener();
                this._shutterTab = shutterTab;
                this._holder = holder;
                try {
                    this._shutterTab.raisePanel(this._holder, 4);
                    break;
                }
                finally {
                    this.setState(1);
                }
            }
            case 3: 
            case 4: {
                this.stopTimer();
                this._shutterTab = shutterTab;
                this._holder = holder;
                try {
                    this._shutterTab.raisePanel(this._holder, 4);
                    break;
                }
                finally {
                    this.setState(1);
                }
            }
            case 1: {
                ShutterPanel shutterPanel = ShutterManager.getInstance().getShutterPanel();
                boolean isAccessible = shutterPanel.isClientAccessible(holder);
                if (!isAccessible || !this._shutterTab.isSelected()) {
                    this._shutterTab = shutterTab;
                    this._holder = holder;
                    this._shutterTab.raisePanel(this._holder, 4);
                    break;
                }
                if (System.currentTimeMillis() - this._autoRaiseTime <= (long)MouseActivationController.getHideToggleDelay()) break;
                this.removeGlobalMouseListener();
                this._shutterTab.retractPanel(4);
                this._shutterTab = null;
                this._holder = null;
                this.setState(0);
                break;
            }
        }
    }

    public void dragEnter(ShutterTab shutterTab, TitledPanelHolder holder) {
        switch (this.getState()) {
            case 0: {
                this._shutterTab = shutterTab;
                this._holder = holder;
                this._shutterTab.raisePanel(this._holder, 0);
                this.setState(1);
                break;
            }
            case 1: {
                if (this._shutterTab == shutterTab && this._holder == holder) break;
                this._shutterTab = shutterTab;
                this._holder = holder;
                this._shutterTab.raisePanel(this._holder, 0);
                break;
            }
            default: {
                this.assertUnexpectedState();
            }
        }
    }

    public void dragOver(ShutterTab shutterTab, TitledPanelHolder holder) {
        if (this._shutterTab != shutterTab || this._holder != holder) {
            this.dragEnter(shutterTab, holder);
        }
    }

    private int getState() {
        return this._state;
    }

    private void setState(int state) {
        this._state = state;
        this._autoRaiseTime = 0L;
    }

    private void startRaiseTimer() {
        this.setState(2);
        int delay = this.forAutoExpand ? this.raiseDelay : MouseActivationController.getRaiseDelay();
        this.startTimer(delay);
    }

    private void startReraiseTimer() {
        this.setState(3);
        this.startTimer(MouseActivationController.getReraiseDelay());
    }

    private void startHideTimer() {
        this.setState(4);
        this.startTimer(MouseActivationController.getHideDelay());
    }

    private void startTimer(int delay) {
        this._timer = new Timer(delay, this._eventListener);
        this._timer.setRepeats(false);
        this._timer.start();
    }

    private void stopTimer() {
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }

    private void addGlobalMouseListener() {
        GlobalMouseDispatcher mouseDispatcher = GlobalMouseDispatcher.getInstance();
        mouseDispatcher.addMouseListener(this._eventListener);
        this._listening = true;
    }

    private void removeGlobalMouseListener() {
        GlobalMouseDispatcher mouseDispatcher = GlobalMouseDispatcher.getInstance();
        mouseDispatcher.removeMouseListener(this._eventListener);
        this._listening = false;
    }

    private void assertUnexpectedState() {
        Assert.println((String)("Unexpected state:" + MouseActivationController.getStateName(this.getState())));
        Assert.println((String)("Timer :" + (this._timer == null ? "off" : "on")));
        Assert.println((String)("GlobalMouseListener :" + (this._listening ? "on" : "off")));
        Assert.printStackTrace();
    }

    private static boolean isOverTooltip(MouseEvent e) {
        Component component = e.getComponent();
        Window windowAncestor = SwingUtilities.getWindowAncestor(component);
        return windowAncestor != null ? MouseActivationController.containsTooltip(windowAncestor) : false;
    }

    private static boolean containsTooltip(Container container) {
        int componentCount = container.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component child = container.getComponent(i);
            if (!(child instanceof Container)) continue;
            Container childContainer = (Container)child;
            if (childContainer instanceof JToolTip) {
                return true;
            }
            if (!MouseActivationController.containsTooltip(childContainer)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOverFloatingComponent(MouseEvent e) {
        for (Component comp = e.getComponent(); comp != null; comp = comp.getParent()) {
            if (!(comp instanceof ShutterPanel) && !(comp instanceof ShutterTab) && !(comp instanceof ShutterMargin)) continue;
            return true;
        }
        return false;
    }

    private static boolean isShutterPanelChild(Component component) {
        return SwingUtilities.getAncestorOfClass(ShutterPanel.class, component) != null;
    }

    private static boolean isInEditorOrDockable(Component component) {
        return SwingUtilities.getAncestorOfClass(TitledContainer.class, component) != null;
    }

    private static int getRaiseDelay() {
        return MouseActivationController.getIntProperty("Docking.raiseShutterDelay", 400);
    }

    private static int getReraiseDelay() {
        return MouseActivationController.getIntProperty("Docking.reraiseShutterDelay", 125);
    }

    private static int getHideDelay() {
        return MouseActivationController.getIntProperty("Docking.hideShutterDelay", 400);
    }

    private static int getHideToggleDelay() {
        return MouseActivationController.getIntProperty("Docking.hideToggleDelay", 500);
    }

    private static int getIntProperty(String propertyName, int defaultValue) {
        String propertyValue = Ide.getProperty(propertyName);
        return propertyValue != null ? Integer.valueOf(propertyValue) : defaultValue;
    }

    private static String getStateName(int state) {
        return state == 0 ? "STATE_NORMAL" : (state == 2 ? "STATE_RAISE_PENDING" : (state == 3 ? "STATE_RERAISE_PENDING" : (state == 1 ? "STATE_RAISED" : (state == 4 ? "STATE_HIDE_PENDING" : "???"))));
    }

    private final class EventListener
    implements ActionListener,
    MouseListener {
        private EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (MouseActivationController.this.getState()) {
                case 2: {
                    MouseActivationController.this.stopTimer();
                    try {
                        MouseActivationController.this._shutterTab.raisePanel(MouseActivationController.this._holder, 0);
                        break;
                    }
                    finally {
                        MouseActivationController.this.setState(1);
                        MouseActivationController.this._autoRaiseTime = System.currentTimeMillis();
                        MouseActivationController.this.addGlobalMouseListener();
                    }
                }
                case 3: {
                    boolean isSelected = MouseActivationController.this._shutterTab.isSelected();
                    MouseActivationController.this.stopTimer();
                    try {
                        MouseActivationController.this._shutterTab.raisePanel(MouseActivationController.this._holder, 0);
                        MouseActivationController.this._shutterTab.setSelected(isSelected);
                        break;
                    }
                    finally {
                        MouseActivationController.this.setState(1);
                        MouseActivationController.this._autoRaiseTime = System.currentTimeMillis();
                    }
                }
                case 4: {
                    MouseActivationController.this.stopTimer();
                    MouseActivationController.this.removeGlobalMouseListener();
                    if (MouseActivationController.this._shutterTab != null) {
                        MouseActivationController.this._shutterTab.retractPanel(0);
                        MouseActivationController.this._shutterTab = null;
                    }
                    MouseActivationController.this._holder = null;
                    MouseActivationController.this.setState(0);
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    MouseActivationController.this.assertUnexpectedState();
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent e) {
            Component component = e.getComponent();
            int flags = 4;
            switch (MouseActivationController.this.getState()) {
                case 1: {
                    if (MouseActivationController.isShutterPanelChild(component)) {
                        MouseActivationController.this._shutterTab.setSelected(true);
                        break;
                    }
                    if (component == MouseActivationController.this._shutterTab || !MouseActivationController.isInEditorOrDockable(component)) break;
                    MouseActivationController.this.removeGlobalMouseListener();
                    MouseActivationController.this._shutterTab.retractPanel(4);
                    MouseActivationController.this._shutterTab = null;
                    MouseActivationController.this._holder = null;
                    MouseActivationController.this.setState(0);
                    break;
                }
                case 3: 
                case 4: {
                    if (MouseActivationController.isShutterPanelChild(component)) {
                        MouseActivationController.this.stopTimer();
                        try {
                            MouseActivationController.this._shutterTab.setSelected(true);
                            break;
                        }
                        finally {
                            MouseActivationController.this.setState(1);
                        }
                    }
                    if (component == MouseActivationController.this._shutterTab) break;
                    MouseActivationController.this.stopTimer();
                    MouseActivationController.this.removeGlobalMouseListener();
                    try {
                        MouseActivationController.this._shutterTab.retractPanel(4);
                        break;
                    }
                    finally {
                        MouseActivationController.this._shutterTab = null;
                        MouseActivationController.this._holder = null;
                        MouseActivationController.this.setState(0);
                    }
                }
                default: {
                    MouseActivationController.this.assertUnexpectedState();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            switch (MouseActivationController.this.getState()) {
                case 4: {
                    if (!MouseActivationController.isOverTooltip(e) && !MouseActivationController.isOverFloatingComponent(e)) break;
                    MouseActivationController.this.stopTimer();
                    MouseActivationController.this.setState(1);
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                default: {
                    MouseActivationController.this.assertUnexpectedState();
                }
            }
        }

        private boolean pointOverShutterPanel(Point p) {
            ShutterPanel shutterPanel = ShutterManager.getInstance().getShutterPanel();
            Component c = SwingUtilities.getDeepestComponentAt(shutterPanel, p.x, p.y);
            return c != null;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            switch (MouseActivationController.this.getState()) {
                case 3: {
                    if (MouseActivationController.this._shutterTab == null || MouseActivationController.this._shutterTab.isSelected()) break;
                    MouseActivationController.this.stopTimer();
                    MouseActivationController.this.startHideTimer();
                    break;
                }
                case 1: {
                    boolean hide;
                    boolean bl = MouseActivationController.this.forAutoExpand ? !this.pointOverShutterPanel(e.getPoint()) && !MouseActivationController.this._shutterTab.isSelected() : (hide = !MouseActivationController.this._shutterTab.isSelected());
                    if (MouseActivationController.this._shutterTab == null || !hide) break;
                    MouseActivationController.this.startHideTimer();
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    MouseActivationController.this.assertUnexpectedState();
                }
            }
        }
    }
}

