/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionHook;
import oracle.ide.ExtensionRegistry;
import oracle.ideimpl.extension.Bridge;
import oracle.ideimpl.extension.BridgeExtensionException;
import oracle.ideimpl.extension.BridgeExtensionRegistry;

public class BridgeExtensionHook
extends ExtensionHook {
    private static final String _BRIDGE_ID_ATTR = "bridge-id";
    private static final String _FROM_EXTENSION_ATTR = "from-extension";
    private static final String _TO_EXTENSION_ATTR = "to-extension";

    public void start(ElementStartContext context) {
        String bridgeId = this.getAttributeHelper(context, _BRIDGE_ID_ATTR, true, true);
        String fromExtensionId = this.getAttributeHelper(context, _FROM_EXTENSION_ATTR, true, true);
        String toExtensionId = this.getAttributeHelper(context, _TO_EXTENSION_ATTR, true, true);
        if (bridgeId != null && fromExtensionId != null && toExtensionId != null) {
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            Extension fromExtension = registry.findExtension(fromExtensionId);
            if (fromExtension == null) {
                this.log((ElementContext)context, Level.SEVERE, "Unknown extension id: " + fromExtensionId + ". The from-extension attribute's value must match the extension id of a dependency");
                return;
            }
            Extension toExtension = registry.findExtension(toExtensionId);
            if (toExtension == null) {
                this.log((ElementContext)context, Level.SEVERE, "Unknown extension id: " + toExtensionId + ". The to-extension attribute's value must match the extension id of a dependency");
                return;
            }
            Extension bridgeExtension = (Extension)context.getScopeData().get("extension");
            Bridge bridge = new Bridge(bridgeId, bridgeExtension, fromExtension, toExtension);
            try {
                BridgeExtensionRegistry.getInstance().registerBridge(bridge);
            }
            catch (BridgeExtensionException e) {
                this.log((ElementContext)context, Level.SEVERE, e.getMessage());
            }
        }
    }
}

