/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.model;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import oracle.ide.controls.ProgressTrackedTask;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectVersion;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.TechnologyScopeDetector;
import oracle.ide.model.TechnologyScopeManager;
import oracle.ide.model.Workspace;
import oracle.ide.task.Task;
import oracle.ide.task.TaskMonitor;
import oracle.ide.task.event.ProgressEvent;
import oracle.ide.task.event.TaskExitCode;
import oracle.ide.util.VersionNumber;
import oracle.ideimpl.model.TechnologyScopeUpdateMigrator;
import oracle.ideimpl.resource.NavigatorArb;

public class TechnologyScanTask
extends Task<Object>
implements ProgressTrackedTask {
    private final Workspace m_workspace;
    private final Collection<Project> m_projects;
    private final TechnologyScopeUpdateMigrator m_migrator;

    public TechnologyScanTask(Workspace workspace, Collection<Project> projects, TechnologyScopeUpdateMigrator migrator) {
        super(TechnologyScanTask.class.getName(), projects.size());
        this.m_workspace = workspace;
        this.m_projects = projects;
        this.m_migrator = migrator;
    }

    @Override
    public int getTimeLeftSeconds() {
        return 0;
    }

    @Override
    public Object getResult() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskExitCode performTask(TaskMonitor tc) throws Exception {
        int counter = 0;
        Map<Project, ConcurrentLinkedQueue<URL>> project2URLs = TechnologyScopeManager.getTechnologyScopeManager().getDetector().technologyScopesOfProjectBatch(this.m_workspace, this.m_projects);
        for (Project project : this.m_projects) {
            try {
                if (tc != null) {
                    tc.fireProgress(new ProgressEvent(this, ++counter, 3L, new String[]{MessageFormat.format(NavigatorArb.getString(4), project.getShortLabel())}));
                }
                ArrayList<String> allTechnologies = new ArrayList<String>();
                ConcurrentLinkedQueue<URL> urlQueue = project2URLs.get(project);
                while (urlQueue.peek() != TechnologyScopeDetector.END) {
                    ConcurrentLinkedQueue<URL> concurrentLinkedQueue = urlQueue;
                    synchronized (concurrentLinkedQueue) {
                        while (urlQueue.isEmpty()) {
                            urlQueue.wait();
                        }
                    }
                    URL url = (URL)urlQueue.remove();
                    if (url == TechnologyScopeDetector.END) break;
                    allTechnologies.addAll(TechnologyScopeManager.getTechnologyScopeManager().getDetector().detectTechnologyScopeIdsOfURL(project, url));
                }
                if (!allTechnologies.isEmpty()) {
                    TechnologyScopeConfiguration.getInstance(project).updateTechnologyScope(allTechnologies.toArray(new String[allTechnologies.size()]));
                }
                ProjectVersion version = new ProjectVersion(project);
                version.addVersion(this.m_migrator.getNodeMigratorHelperKey(), new VersionNumber(this.m_migrator.getNodeMigratorHelperVersion()));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return TaskExitCode.COMPLETED;
    }

    @Override
    public boolean isIndeterminate() {
        return true;
    }

    @Override
    public int getCurrentValue() {
        return 0;
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    @Override
    public int getMaximum() {
        return 0;
    }

    @Override
    public String getCurrentText() {
        return null;
    }

    @Override
    public String getTaskDescription() {
        return null;
    }

    @Override
    public void run() {
    }
}

