/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.remote;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.bali.xml.grammar.remote.GrammarLoadingPolicy;

public class DefaultGrammarLoadingPolicy
extends GrammarLoadingPolicy {
    public static final String LOAD_REMOTE_SCHEMAS_KEY = "jdev.load.remote.schemas";
    public static final String PRIVATE_LOAD_REMOTE_SCHEMAS_KEY = "private.jdev.load.remote.schemas";
    private final Map<String, Boolean> _reachabilityCache = new ConcurrentHashMap<String, Boolean>(5, 0.75f, 2);

    public boolean isRemote(URL url) {
        return "http".equals(url.getProtocol());
    }

    public GrammarLoadingPolicy.Policy getPolicy(URL url, GrammarLoadingPolicy.Type type) {
        if (this.isRemote(url)) {
            if (DefaultGrammarLoadingPolicy.shouldLoadRemoteSchemasByDefault() && type == GrammarLoadingPolicy.Type.XML_SCHEMA) {
                String urlKey = url.toExternalForm().intern();
                Boolean reachable = this._reachabilityCache.get(urlKey);
                if (reachable == null) {
                    reachable = this.performConnectionTest(url, true) ? Boolean.TRUE : Boolean.FALSE;
                    this._reachabilityCache.put(urlKey, reachable);
                }
                if (reachable.booleanValue()) {
                    return GrammarLoadingPolicy.Policy.LOAD;
                }
                return GrammarLoadingPolicy.Policy.ERROR_UNREACHABLE;
            }
            return GrammarLoadingPolicy.Policy.IGNORE;
        }
        if (this.performConnectionTest(url, false)) {
            return GrammarLoadingPolicy.Policy.LOAD;
        }
        return GrammarLoadingPolicy.Policy.ERROR_UNREACHABLE;
    }

    protected final boolean performConnectionTest(URL url, boolean useCache) {
        Boolean reachable = null;
        String urlKey = null;
        if (useCache) {
            urlKey = url.toExternalForm().intern();
            reachable = this._reachabilityCache.get(urlKey);
        }
        if (reachable == null) {
            reachable = this.performConnectionTestImpl(url) ? Boolean.TRUE : Boolean.FALSE;
            if (useCache) {
                this._reachabilityCache.put(urlKey, reachable);
            }
        }
        return reachable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performConnectionTestImpl(URL url) {
        boolean connectionWorked = true;
        InputStream in = null;
        try {
            in = url.openStream();
        }
        catch (Exception e) {
            connectionWorked = false;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return connectionWorked;
    }

    public static boolean shouldLoadRemoteSchemasByDefault() {
        String value = System.getProperty(LOAD_REMOTE_SCHEMAS_KEY);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        value = System.getProperty(PRIVATE_LOAD_REMOTE_SCHEMAS_KEY);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return false;
    }
}

