/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.tools;

import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarException;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.grammar.GrammarMetadataProvider;
import oracle.bali.xml.metadata.tools.MetadataFileGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandaloneMetadataFileGenerator {
    public static final void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage:  StandaloneMetadataFileGenerator schemaFile outputFile namespace [rootElement]");
            System.exit(1);
        }
        String schemaFile = args[0];
        String outputFileName = args[1];
        String ns = args[2];
        if ("null".equals(ns)) {
            ns = null;
        }
        String root = args.length >= 4 ? args[3] : null;
        StandaloneMetadataFileGenerator smfg = new StandaloneMetadataFileGenerator();
        smfg.run(schemaFile, outputFileName, ns, root);
    }

    public void run(String schemaFile, String outputFileName, String namespace) {
        this.run(schemaFile, outputFileName, namespace, null);
    }

    public void run(String schemaFile, String outputFileName, String ns, String root) {
        URL schemaURL = null;
        try {
            schemaURL = new URL(schemaFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (schemaURL == null) {
            try {
                File aFile = new File(schemaFile);
                schemaFile = aFile.getCanonicalPath();
                schemaFile = schemaFile.charAt(0) == '/' ? "file:" + schemaFile : "file:/" + schemaFile;
                schemaURL = new URL(schemaFile);
            }
            catch (Exception e) {
                System.err.println("Could not find file " + schemaFile);
                System.exit(1);
            }
        }
        SchemaGrammarProvider grammarProvider = new SchemaGrammarProvider();
        Grammar grammar = null;
        try {
            Set grammars = grammarProvider.addSchema(schemaURL);
            for (Grammar g : grammars) {
                String grammarNS = g.getTargetNamespace();
                if ((grammarNS == null || !grammarNS.equals(ns)) && (grammarNS != null || ns != null)) continue;
                grammar = g;
                break;
            }
        }
        catch (GrammarException ex) {
            System.err.println("grammar exception " + ex);
            ex.printStackTrace();
            System.exit(1);
        }
        if (grammar == null) {
            System.err.println("Could not find namespace " + ns);
            System.exit(1);
        }
        MetadataFileGenerator generator = this.createGenerator(null, null, null);
        this._buildMetadataFile(generator, grammar, outputFileName, root);
    }

    public void run(GrammarProvider gProvider, String outputDir, String ns, Set<QualifiedName> mdKeys) {
        GrammarResolver gResolver = new GrammarResolver(gProvider);
        GrammarMetadataProvider mProvider = new GrammarMetadataProvider(gResolver);
        MetadataFileGenerator generator = this.createGenerator(gResolver, mProvider, mdKeys);
        if (ns != null) {
            Grammar g = gProvider.getGrammarForNamespace(ns);
            if (g == null) {
                System.err.println("Could not find namespace " + ns);
                System.exit(1);
            }
            String outputFileName = outputDir + "/ns-metadata.xml";
            this._buildMetadataFile(generator, g, outputFileName, null);
        } else {
            Collection grammars = gProvider.getGrammars();
            Iterator itr_g = grammars.iterator();
            int i = 1;
            while (itr_g.hasNext()) {
                Grammar g = (Grammar)itr_g.next();
                String outputFileName = outputDir + "/ns-metadata" + i + ".xml";
                this._buildMetadataFile(generator, g, outputFileName, null);
                ++i;
            }
        }
    }

    protected MetadataFileGenerator createGenerator(GrammarResolver gResolver, MetadataProvider mProvider, Set<QualifiedName> mdKeys) {
        return new MetadataFileGenerator(gResolver, mProvider, mdKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _buildMetadataFile(MetadataFileGenerator generator, Grammar g, String fileName, String root) {
        StringBuffer sb = new StringBuffer();
        generator.generate(sb, g, root);
        FileWriter outputWriter = null;
        try {
            outputWriter = new FileWriter(fileName);
            outputWriter.write(sb.toString());
            outputWriter.flush();
            outputWriter.close();
        }
        catch (Exception e) {
            System.err.println("exception writing to output file" + e);
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            try {
                if (outputWriter != null) {
                    outputWriter.close();
                }
            }
            catch (Exception e) {
                System.err.println("exception writing to output file" + e);
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

