/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.sax;

import java.util.Enumeration;
import oracle.bali.xml.grammar.QualifiedName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public abstract class PrefixAssistingXmlFilter
extends XMLFilterImpl {
    private final NamespaceSupport _nsSupport = new NamespaceSupport();
    private boolean _passXmlnsAttributes = false;
    private static final Attributes _EMPTY_ATTRIBUTES = new AttributesImpl();

    protected PrefixAssistingXmlFilter(XMLReader base) {
        super(base);
    }

    protected PrefixAssistingXmlFilter() {
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this._nsSupport.reset();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this._nsSupport.popContext();
        super.endElement(uri, localName, qName);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(uri, localName, qName, atts);
        this._nsSupport.pushContext();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
        this._nsSupport.declarePrefix(prefix, uri);
    }

    public void setFeature(String name, boolean state) throws SAXNotRecognizedException, SAXNotSupportedException {
        super.setFeature(name, state);
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            this._passXmlnsAttributes = state;
        }
    }

    protected void addAttribute(AttributesImpl attrs, QualifiedName qualifiedName, String type, String value) {
        String qName;
        String uri = qualifiedName.getNamespace();
        String localName = qualifiedName.getName();
        if (uri == null) {
            qName = localName;
            uri = "";
        } else {
            String prefix = this._nsSupport.getPrefix(uri);
            if (prefix == null) {
                throw new IllegalArgumentException("Can't add attribute " + localName + " with NS " + uri + " because the " + "namespace has no prefix here!");
            }
            int qNameSize = prefix.length() + 1 + localName.length();
            StringBuffer qNameBuffer = new StringBuffer(qNameSize);
            qNameBuffer.append(prefix);
            qNameBuffer.append(':');
            qNameBuffer.append(localName);
            qName = qNameBuffer.toString();
        }
        attrs.addAttribute(uri, localName, qName, type, value);
    }

    protected void startElementHelper(QualifiedName qualifiedName) throws SAXException {
        this.startElementHelper(qualifiedName, _EMPTY_ATTRIBUTES);
    }

    protected void startElementHelper(QualifiedName qualifiedName, Attributes attrs) throws SAXException {
        String uri = qualifiedName.getNamespace();
        String localName = qualifiedName.getName();
        this._nsSupport.pushContext();
        String qName = this._getElementQName(uri, localName);
        if (qName == null) {
            this.startPrefixMapping("", uri);
            qName = localName;
        }
        super.startElement(uri, localName, qName, attrs);
    }

    protected void endElementHelper(QualifiedName qualifiedName) throws SAXException {
        Enumeration<String> declaredPrefixes = this._nsSupport.getDeclaredPrefixes();
        while (declaredPrefixes.hasMoreElements()) {
            String curPrefix = declaredPrefixes.nextElement();
            this.endPrefixMapping(curPrefix);
        }
        String uri = qualifiedName.getNamespace();
        String localName = qualifiedName.getName();
        String qName = this._getElementQName(uri, localName);
        this.endElement(uri, localName, qName);
    }

    private String _getElementQName(String uri, String localName) {
        String currentDefaultNamespace = this._nsSupport.getURI("");
        if (currentDefaultNamespace != null && currentDefaultNamespace.equals(uri)) {
            return localName;
        }
        String prefix = this._nsSupport.getPrefix(uri);
        if (prefix != null) {
            return prefix + ':' + localName;
        }
        return null;
    }
}

