/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.capture.redshift.online;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.migration.cloud.core.utils.RunSQLcl;
import oracle.dbtools.migration.cloud.core.utils.SQLCLException;
import oracle.dbtools.migration.cloud.ui.backendDelegation.BackendDelegatorRaptorTask;
import oracle.jdbc.OracleCallableStatement;

public class RedshiftOnlineCapture {
    private Connection m_targetConnection = null;
    private RunSQLcl m_runSQLcl;
    private String m_sourceRepositoryConnectionName;
    private String m_sourceSelectedSchemas;

    public RedshiftOnlineCapture(RunSQLcl runSQLcl, Connection connection, String string, String[] stringArray) {
        this.m_runSQLcl = runSQLcl;
        this.m_targetConnection = connection;
        this.m_sourceRepositoryConnectionName = string;
        this.setSourceSelectedSchemas(stringArray);
    }

    public void onlineCaptureByBridgeCommand(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLException, SQLCLException, IOException, ExecutionException {
        if (this.truncateCaptureStageTables(this.getTargetConnection())) {
            backendDelegatorRaptorTask.checkCanProceed();
            String[] stringArray = this.getOnlineRedshiftBridgeCommands(this.getTargetConnection());
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i].replaceFirst("<REDSHIFT_JDBC_CONNECTION>", "\\$" + this.getSourceRepositoryConnectionName()).replaceAll("<SCHEMA_ARRAY>", this.getSourceSelectedSchemas()).trim();
                backendDelegatorRaptorTask.checkCanProceed();
                this.getRunSQLcl().runSQLScript(string);
            }
            backendDelegatorRaptorTask.checkCanProceed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getOnlineRedshiftBridgeCommands(Connection connection) throws SQLException {
        String[] stringArray = null;
        OracleCallableStatement oracleCallableStatement = null;
        String string = "sqldev_migrepos".toUpperCase() + ".BRIDGECOMMANDSARRAY";
        String string2 = "{call ? := " + "sqldev_migrepos".toUpperCase() + ".REDSHIFT_CAPTURE.getOnlineRedshiftBridgeCommands}";
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(string2);
            oracleCallableStatement.registerOutParameter(1, 2003, string);
            oracleCallableStatement.executeUpdate();
            stringArray = (String[])oracleCallableStatement.getARRAY(1).getArray();
        }
        finally {
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean truncateCaptureStageTables(Connection connection) throws SQLException, IOException {
        boolean bl = false;
        try (OracleCallableStatement oracleCallableStatement = null;){
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("{call " + "sqldev_migrepos".toUpperCase() + ".MIGRATION_REPOSITORY.truncateCaptureStageTables}");
            oracleCallableStatement.executeUpdate();
            bl = true;
        }
        return bl;
    }

    public String runOnlineRedshiftCapture() throws SQLRecoverableException, SQLException {
        String string = null;
        try (OracleCallableStatement oracleCallableStatement = null;){
            oracleCallableStatement = (OracleCallableStatement)this.getTargetConnection().prepareCall("{call ? := " + "sqldev_migrepos".toUpperCase() + ".REDSHIFT_CAPTURE.capture(?,?,?,?)}");
            oracleCallableStatement.registerOutParameter(1, 12, "VARCHAR");
            oracleCallableStatement.setInt(2, 11111);
            oracleCallableStatement.setInt(3, 5);
            oracleCallableStatement.setString(4, "REDSHIFT_PROJECT");
            oracleCallableStatement.setString(5, "Description for REDSHIFT_PROJECT");
            oracleCallableStatement.executeUpdate();
            string = oracleCallableStatement.getString(1);
        }
        return string;
    }

    public Connection getTargetConnection() {
        return this.m_targetConnection;
    }

    public void setTargetConnection(Connection connection) {
        this.m_targetConnection = connection;
    }

    public RunSQLcl getRunSQLcl() {
        return this.m_runSQLcl;
    }

    public String getSourceSelectedSchemas() {
        return this.m_sourceSelectedSchemas;
    }

    public void setSourceSelectedSchemas(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append("'").append(string).append("'");
        }
        this.m_sourceSelectedSchemas = stringBuilder.toString();
    }

    public String getSourceRepositoryConnectionName() {
        return this.m_sourceRepositoryConnectionName;
    }
}

