/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.capture.redshift.online;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.Connections;

public final class RedshiftQueryCapture {
    private static final Logger LOGGER = Logger.getLogger(RedshiftQueryCapture.class.getName());

    private RedshiftQueryCapture() {
        throw new UnsupportedOperationException("Error");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getRedshiftSchemaNames(String string) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        Connection connection = null;
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            connection = Connections.getInstance().getUniqueConnection(string);
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select distinct table_schema as schema_name from information_schema.tables where table_schema NOT IN ('pg_internal', 'information_schema', 'pg_catalog')");
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public static void executeSQLQueryNoResultSet(String string, Connection connection) throws SQLException {
        try (Statement statement = null;){
            statement = connection.createStatement();
            statement.executeQuery(string);
        }
    }
}

