/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.core.api.redshift;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.migration.cloud.capture.redshift.online.RedshiftDataUnloadAndLoad;
import oracle.dbtools.migration.cloud.capture.redshift.online.RedshiftOnlineCapture;
import oracle.dbtools.migration.cloud.convert.MigrationConvert;
import oracle.dbtools.migration.cloud.core.api.redshift.RedshiftMigrationUIDataInput;
import oracle.dbtools.migration.cloud.core.utils.MigrationConstants;
import oracle.dbtools.migration.cloud.core.utils.RunSQLcl;
import oracle.dbtools.migration.cloud.core.utils.SQLCLException;
import oracle.dbtools.migration.cloud.dataload.DwcsSQLQueryExecution;
import oracle.dbtools.migration.cloud.deploy.redshift.DeployExternalTables;
import oracle.dbtools.migration.cloud.deploy.redshift.DeployMetadataObjects;
import oracle.dbtools.migration.cloud.generate.MigrationGenerate;
import oracle.dbtools.migration.cloud.metadata.repository.MigrationRepository;
import oracle.dbtools.migration.cloud.report.redshift.RedshiftDataMigrationReport;
import oracle.dbtools.migration.cloud.ui.backendDelegation.BackendDelegatorRaptorTask;
import oracle.dbtools.migration.cloud.ui.utils.Utilities;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.jdeveloper.db.ConnectionException;

public class RedshiftMigration {
    private static final boolean DEBUG = false;
    private Logger redshiftMigrationLogger = Logger.getLogger(RedshiftMigration.class.getName());
    private RunSQLcl m_runSQLcl;
    protected RedshiftMigrationUIDataInput m_redshiftUIData = null;
    private LinkedHashMap<String, String> m_dataLoadCommandsHash = new LinkedHashMap();
    private HashMap<String, String> m_statusDataLoadTables = new HashMap();

    public RedshiftMigration() {
    }

    public RedshiftMigration(RedshiftMigrationUIDataInput redshiftMigrationUIDataInput) {
        this.m_redshiftUIData = redshiftMigrationUIDataInput;
    }

    public void instantiateRunSQLcl(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws FileNotFoundException, Exception {
        this.traceFlow("start instantiateRunSQLcl ...");
        this.traceFlow("user.dir=" + System.getProperty("user.dir"));
        this.traceFlow("file.separator=" + System.getProperty("file.separator"));
        this.traceFlow("filename=MigrationRepository.log");
        String string = this.m_redshiftUIData.getSqlScriptDirectory() + System.getProperty("file.separator") + MigrationConstants.migrationRepoLogFileName;
        backendDelegatorRaptorTask.checkCanProceed();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        WrapListenBufferOutputStream wrapListenBufferOutputStream = new WrapListenBufferOutputStream((OutputStream)bufferedOutputStream, null);
        wrapListenBufferOutputStream.setRemoveForcePrint(true);
        this.m_runSQLcl = new RunSQLcl(this.m_redshiftUIData.getTargetConnection(), wrapListenBufferOutputStream);
        this.setRunSQLcl(this.m_runSQLcl);
        backendDelegatorRaptorTask.checkCanProceed();
        this.traceFlow("end instantiateRunSQLcl ...");
    }

    public void installMigrationRepository(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLCLException, IOException, ExecutionException {
        this.traceFlow("start installMigrationRepository ...");
        backendDelegatorRaptorTask.checkCanProceed();
        MigrationRepository migrationRepository = new MigrationRepository(this.getRunSQLcl(), this.m_redshiftUIData.getTargetUserName());
        backendDelegatorRaptorTask.checkCanProceed();
        migrationRepository.createMigrationRepository();
        backendDelegatorRaptorTask.checkCanProceed();
        this.traceFlow("end installMigrationRepository ...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onlineRedshiftCapture(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLException, SQLCLException, IOException, Exception {
        this.traceFlow("start onlineRedshiftCapture ...");
        Connection connection = null;
        try {
            connection = Connections.getInstance().getUniqueConnection(this.m_redshiftUIData.getTargetConnectionString());
            backendDelegatorRaptorTask.checkCanProceed();
            RedshiftOnlineCapture redshiftOnlineCapture = new RedshiftOnlineCapture(this.getRunSQLcl(), connection, this.m_redshiftUIData.getSourceRepositoryConnectionName(), this.m_redshiftUIData.getSourceSelectedSchemas());
            backendDelegatorRaptorTask.checkCanProceed();
            redshiftOnlineCapture.onlineCaptureByBridgeCommand(backendDelegatorRaptorTask);
            backendDelegatorRaptorTask.checkCanProceed();
            redshiftOnlineCapture.runOnlineRedshiftCapture();
            backendDelegatorRaptorTask.checkCanProceed();
        }
        finally {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        this.traceFlow("end onlineRedshiftCapture ...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runConvert(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLException, Exception {
        this.traceFlow("start runConvert ...");
        backendDelegatorRaptorTask.checkCanProceed();
        Connection connection = null;
        try {
            connection = Connections.getInstance().getUniqueConnection(this.m_redshiftUIData.getTargetConnectionString());
            backendDelegatorRaptorTask.checkCanProceed();
            MigrationConvert migrationConvert = new MigrationConvert(connection, MigrationConstants.captureVersion);
            backendDelegatorRaptorTask.checkCanProceed();
            migrationConvert.runConvert();
        }
        finally {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        backendDelegatorRaptorTask.checkCanProceed();
        this.traceFlow("end runConvert ...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runGenerateDDL(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLException, Exception {
        this.traceFlow("start runGenerateDDL ...");
        backendDelegatorRaptorTask.checkCanProceed();
        Connection connection = null;
        try {
            connection = Connections.getInstance().getUniqueConnection(this.m_redshiftUIData.getTargetConnectionString());
            backendDelegatorRaptorTask.checkCanProceed();
            MigrationGenerate migrationGenerate = new MigrationGenerate(connection, MigrationConstants.convertVersion, this.m_redshiftUIData.getUserPreferences(), this.m_redshiftUIData.getMigrationRepositoryPassword(), this.m_redshiftUIData.isDropMigrationRepository());
            backendDelegatorRaptorTask.checkCanProceed();
            migrationGenerate.runGenerateDDL(backendDelegatorRaptorTask);
        }
        finally {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        backendDelegatorRaptorTask.checkCanProceed();
        this.traceFlow("end runGenerateDDL ...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runGenerateData(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLException, Exception {
        this.traceFlow("start runGenerateData ...");
        backendDelegatorRaptorTask.checkCanProceed();
        Connection connection = null;
        try {
            connection = Connections.getInstance().getUniqueConnection(this.m_redshiftUIData.getTargetConnectionString());
            backendDelegatorRaptorTask.checkCanProceed();
            MigrationGenerate migrationGenerate = new MigrationGenerate(connection, MigrationConstants.convertVersion, this.m_redshiftUIData.getAwsAccessKey(), this.m_redshiftUIData.getAwsSecretAccess(), this.m_redshiftUIData.getAwsS3BucketHTTPSLocation(), this.m_redshiftUIData.getAwsS3BucketURI(), this.m_redshiftUIData.getFileFormatDelimiter(), this.m_redshiftUIData.getUserPreferences(), this.m_redshiftUIData.getMigrationRepositoryPassword(), this.m_redshiftUIData.isDropMigrationRepository());
            backendDelegatorRaptorTask.checkCanProceed();
            migrationGenerate.runGenerateData(backendDelegatorRaptorTask);
        }
        finally {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        backendDelegatorRaptorTask.checkCanProceed();
        this.traceFlow("end runGenerateData ...");
    }

    public void writeUnloadAndDataLoadScripts(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws DBException, SQLException, Exception {
        this.traceFlow("start writeUnloadAndDataLoadScripts ...");
        backendDelegatorRaptorTask.checkCanProceed();
        RedshiftDataUnloadAndLoad redshiftDataUnloadAndLoad = new RedshiftDataUnloadAndLoad(this.m_redshiftUIData);
        backendDelegatorRaptorTask.checkCanProceed();
        redshiftDataUnloadAndLoad.writeUnloadAndDataLoadSqlScripts(backendDelegatorRaptorTask);
        this.traceFlow("end writeUnloadAndDataLoadScripts ...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployMetadataObjects(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws IOException, SQLException, Exception {
        this.traceFlow("start deployMetadataObjects ...");
        backendDelegatorRaptorTask.checkCanProceed();
        DeployMetadataObjects deployMetadataObjects = null;
        Connection connection = null;
        try {
            backendDelegatorRaptorTask.checkCanProceed();
            connection = Connections.getInstance().getUniqueConnection(this.m_redshiftUIData.getTargetConnectionString());
            deployMetadataObjects = new DeployMetadataObjects(connection, this.m_redshiftUIData.getSqlScriptDirectory(), this.m_redshiftUIData.isStartDeployment(), this.m_redshiftUIData.getSourceUpdatedDeployableSchemas());
            backendDelegatorRaptorTask.checkCanProceed();
            deployMetadataObjects.deployMetadataObjectsToTarget(backendDelegatorRaptorTask);
        }
        finally {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        backendDelegatorRaptorTask.checkCanProceed();
        this.traceFlow("end deployMetadataObjects ...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployExternalTables(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws IOException, SQLException, ExecutionException {
        this.traceFlow("start deployExternalTables ...");
        backendDelegatorRaptorTask.checkCanProceed();
        DeployExternalTables deployExternalTables = null;
        Connection connection = null;
        try {
            backendDelegatorRaptorTask.checkCanProceed();
            deployExternalTables = new DeployExternalTables(connection, this.m_redshiftUIData.getSqlScriptDirectory(), this.m_redshiftUIData.isStartDeployment());
            backendDelegatorRaptorTask.checkCanProceed();
            deployExternalTables.deployExternalTablesToTarget();
        }
        finally {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        backendDelegatorRaptorTask.checkCanProceed();
        this.traceFlow("end deployExternalTables ...");
    }

    public void dataUnloadAndLoad(BackendDelegatorRaptorTask backendDelegatorRaptorTask) throws SQLException, SQLCLException, IOException, ConnectionException, Exception {
        this.traceFlow("start dataUnloadAndLoad ...");
        backendDelegatorRaptorTask.checkCanProceed();
        DwcsSQLQueryExecution.dropOCACredential(this.getRunSQLcl(), "REDSHIFT_ADWC_CREDS");
        backendDelegatorRaptorTask.checkCanProceed();
        DwcsSQLQueryExecution.createOCACredential(this.getRunSQLcl(), "REDSHIFT_ADWC_CREDS", this.m_redshiftUIData.getAwsAccessKey(), this.m_redshiftUIData.getAwsSecretAccess());
        backendDelegatorRaptorTask.checkCanProceed();
        RedshiftDataUnloadAndLoad redshiftDataUnloadAndLoad = new RedshiftDataUnloadAndLoad(this.m_redshiftUIData);
        backendDelegatorRaptorTask.checkCanProceed();
        redshiftDataUnloadAndLoad.startUnloadToS3AndLoadToAdwc(backendDelegatorRaptorTask);
        this.m_dataLoadCommandsHash = redshiftDataUnloadAndLoad.getDataLoadCommandsHash();
        this.m_statusDataLoadTables = redshiftDataUnloadAndLoad.getStatusDataLoadTables();
        backendDelegatorRaptorTask.checkCanProceed();
        this.traceFlow("end dataUnloadAndLoad ...");
    }

    public void alterSessionToADWCAdmin() throws SQLCLException {
        this.getRunSQLcl().runSQLScript("ALTER SESSION SET CURRENT_SCHEMA=<username>".replace("<username>", this.m_redshiftUIData.getTargetUserName()));
    }

    public void alterSessionToMigrationRepos() throws SQLCLException {
        this.getRunSQLcl().runSQLScript(MigrationConstants.m_alterSessionToSqldevMigRepos);
    }

    public void generateDataMigrationReport() throws SQLException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>(this.m_dataLoadCommandsHash.keySet());
        RedshiftDataMigrationReport redshiftDataMigrationReport = new RedshiftDataMigrationReport(this.m_redshiftUIData, arrayList, this.m_statusDataLoadTables);
        redshiftDataMigrationReport.generateMigrationDataReport();
    }

    public void endRedshiftMigration() throws SQLException, SQLCLException, IOException, Exception {
        this.traceFlow("start endRedshiftMigration ...");
        Connection connection = null;
        try {
            connection = Connections.getInstance().getUniqueConnection(this.m_redshiftUIData.getTargetConnectionString());
            if (Connections.getInstance().lock(connection)) {
                DBUtil dBUtil;
                if (!this.m_redshiftUIData.getMigrationType().equals(Utilities.nls("REDSHIFT_PAGE_MIGRATION_CHOICE_ONLY_DDL")) && this.m_redshiftUIData.isStartDeployment()) {
                    this.generateDataMigrationReport();
                    this.lockAndExpirePasswordForGeneratedSchema(connection);
                }
                if (this.m_redshiftUIData.isDropMigrationRepository() && "sqldev_migrepos".equalsIgnoreCase((dBUtil = DBUtil.getInstance((Connection)connection)).executeReturnOneCol(MigrationConstants.migrationReposCheckQuery))) {
                    dBUtil.execute("DROP USER sqldev_migrepos CASCADE");
                }
                this.getRunSQLcl().dropScriptRunner();
            }
        }
        finally {
            if (connection != null && !connection.isClosed()) {
                Connections.getInstance().unlock(connection);
                connection.close();
            }
        }
        this.traceFlow("start endRedshiftMigration ...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockAndExpirePasswordForGeneratedSchema(Connection connection) throws SQLException, SQLCLException, Exception {
        ResultSet resultSet = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.m_redshiftUIData.getSourceUpdatedDeployableSchemas();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        try {
            resultSet = DBUtil.getInstance((Connection)connection).executeOracleQuery(this.getSchemasSelectedScripts(stringArray), null);
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
            resultSet.close();
            Enumeration enumeration = Collections.enumeration(arrayList);
            while (enumeration.hasMoreElements()) {
                DBUtil.getInstance((Connection)connection).execute("ALTER USER <generated_schema> account lock password expire".replace("<generated_schema>", (CharSequence)enumeration.nextElement()));
            }
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet(resultSet);
            throw throwable;
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
    }

    public RunSQLcl getRunSQLcl() {
        return this.m_runSQLcl;
    }

    public void setRunSQLcl(RunSQLcl runSQLcl) {
        this.m_runSQLcl = runSQLcl;
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    protected long getDiffTime(long l, long l2) {
        if (l2 > l) {
            return l2 - l;
        }
        return 0L;
    }

    private String getSchemasSelectedScripts(String[] stringArray) {
        String string = Utilities.convertToQuotedCommaSeparatedString(stringArray);
        String string2 = "SELECT schema_name FROM sqldev_migrepos.MD_GENERATE WHERE OBJECT_TYPE= 'SCHEMA' and schema_name in (<deployable_schemas>)".replace("<deployable_schemas>", string);
        return string2;
    }

    protected void traceFlow(String string) {
    }
}

