/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.core.utils;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.OracleDriver;

public class MigrationConnections {
    private Properties props = new Properties();
    private Connection m_MigReposConnection = null;
    private Connection m_TargetReposConnection = null;
    private String m_migReposUrl = null;
    private String m_migRepoUserName = null;
    private String m_migRepoPassword = null;
    private String m_targetReposUrl = null;
    private String m_targetRepoUserName = null;
    private String m_targetRepoPassword = null;

    public void setMigRepoURL(String string) {
        this.m_migReposUrl = string;
    }

    public void setMigRepoUserName(String string) {
        this.m_migRepoUserName = string;
    }

    public void setMigRepoPassword(String string) {
        this.m_migRepoPassword = string;
    }

    public void setMigReposConnection() {
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            this.props.put("user", this.m_migRepoUserName);
            this.props.put("password", this.m_migRepoPassword);
            try {
                this.m_MigReposConnection = DriverManager.getConnection(this.m_migReposUrl, this.props);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public Connection getMigReposConnection() {
        try {
            if (this.m_MigReposConnection == null || this.m_MigReposConnection.isClosed()) {
                this.m_MigReposConnection = DriverManager.getConnection(this.m_migReposUrl, this.props);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.m_MigReposConnection;
    }

    public void closeMigReposConnection() {
        try {
            if (this.m_MigReposConnection != null || !this.m_MigReposConnection.isClosed()) {
                this.m_MigReposConnection.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setTargetRepoURL(String string) {
        this.m_targetReposUrl = string;
    }

    public void setTargetRepoUserName(String string) {
        this.m_targetRepoUserName = string;
    }

    public void setTargetRepoPassword(String string) {
        this.m_targetRepoPassword = string;
    }

    public void setTargetReposConnection() {
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            this.props.put("user", this.m_targetRepoUserName);
            this.props.put("password", this.m_targetRepoPassword);
            try {
                this.m_TargetReposConnection = DriverManager.getConnection(this.m_targetReposUrl, this.props);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public Connection getTargetReposConnection() {
        try {
            if (this.m_TargetReposConnection == null || this.m_TargetReposConnection.isClosed()) {
                this.m_TargetReposConnection = DriverManager.getConnection(this.m_migReposUrl, this.props);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.m_TargetReposConnection;
    }
}

