/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.core.utils.timer;

import java.util.LinkedHashMap;
import java.util.Set;
import oracle.dbtools.migration.cloud.core.utils.timer.TaskTimeInterval;

public class TaskTimeRecorder {
    private static TaskTimeRecorder timeRecorder = null;
    LinkedHashMap<String, TaskTimeInterval> timeRecorderHashMap = new LinkedHashMap();

    private TaskTimeRecorder() {
    }

    public static TaskTimeRecorder getInstance() {
        if (timeRecorder == null) {
            timeRecorder = new TaskTimeRecorder();
        }
        return timeRecorder;
    }

    public void add(TaskTimeInterval taskTimeInterval) {
        if (taskTimeInterval.getIntervalTag() != null) {
            this.timeRecorderHashMap.put(taskTimeInterval.getIntervalTag(), taskTimeInterval);
        } else {
            System.out.println("TaskTimeInterval has no tag. Missed recording the timings.");
        }
    }

    public void add(String string, TaskTimeInterval taskTimeInterval) {
        this.timeRecorderHashMap.put(string, taskTimeInterval);
    }

    public TaskTimeInterval get(String string) {
        return this.timeRecorderHashMap.get(string);
    }

    public void currentStatus() {
        System.out.println("=================");
        Set<String> set = this.timeRecorderHashMap.keySet();
        for (String string : set) {
            TaskTimeInterval taskTimeInterval = this.timeRecorderHashMap.get(string);
            System.out.println(string + ":" + taskTimeInterval.getIntervalTime() + " ms");
        }
        System.out.println("=================");
    }
}

