/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.metadata.repository;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import oracle.dbtools.migration.cloud.core.api.ICloudMigration;
import oracle.jdbc.OracleCallableStatement;

public class MigrationRepositoryQuery
implements ICloudMigration {
    private Connection m_migReposConnection = null;

    public MigrationRepositoryQuery(Connection connection) {
        this.m_migReposConnection = connection;
    }

    public void runMigrationQuery() throws SQLException {
        String[] stringArray = this.getAllProjects();
        String string = this.getProjectDescription("Description for REDSHIFT_PROJECT");
        int[] nArray = this.getAllCaptureVersions("REDSHIFT_PROJECT");
        int[] nArray2 = this.getAllConvertVersions("REDSHIFT_PROJECT", 1);
        int[] nArray3 = this.getAllGenerateVersions("REDSHIFT_PROJECT", 1, 3);
    }

    @Override
    public String[] getAllProjects() throws SQLException {
        String[] stringArray = null;
        try (OracleCallableStatement oracleCallableStatement = null;){
            oracleCallableStatement = (OracleCallableStatement)this.getMigReposConnection().prepareCall("{call ? := MIGRATION_REPOSITORY_QUERY.getAllProjectNames}");
            oracleCallableStatement.registerOutParameter(1, 2003, "VARCHARARRAY");
            oracleCallableStatement.executeUpdate();
            stringArray = (String[])oracleCallableStatement.getARRAY(1).getArray();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProjectDescription(String string) throws SQLException {
        String string2 = null;
        try (OracleCallableStatement oracleCallableStatement = null;){
            oracleCallableStatement = (OracleCallableStatement)this.getMigReposConnection().prepareCall("{call ? := MIGRATION_REPOSITORY_QUERY.getProjectDescription(?)}");
            oracleCallableStatement.registerOutParameter(1, 12, "VARCHAR");
            oracleCallableStatement.setString(2, string);
            oracleCallableStatement.executeUpdate();
            string2 = oracleCallableStatement.getString(1);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getAllCaptureVersions(String string) {
        int[] nArray = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getMigReposConnection().prepareCall("{call ? := MIGRATION_REPOSITORY_QUERY.getAllCaptureVersions(?)}");
            oracleCallableStatement.registerOutParameter(1, 2003, "NUMBERARRAY");
            oracleCallableStatement.setString(2, string);
            oracleCallableStatement.executeUpdate();
            nArray = this.convertNumberToInteger((BigDecimal[])oracleCallableStatement.getARRAY(1).getArray());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getAllConvertVersions(String string, int n) {
        int[] nArray = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getMigReposConnection().prepareCall("{call ? := MIGRATION_REPOSITORY_QUERY.getAllConvertVersions(?,?)}");
            oracleCallableStatement.registerOutParameter(1, 2003, "NUMBERARRAY");
            oracleCallableStatement.setString(2, string);
            oracleCallableStatement.setInt(3, n);
            oracleCallableStatement.executeUpdate();
            nArray = this.convertNumberToInteger((BigDecimal[])oracleCallableStatement.getARRAY(1).getArray());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getAllGenerateVersions(String string, int n, int n2) {
        int[] nArray = null;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getMigReposConnection().prepareCall("{call ? := MIGRATION_REPOSITORY_QUERY.getAllGenerateVersions(?,?,?)}");
            oracleCallableStatement.registerOutParameter(1, 2003, "NUMBERARRAY");
            oracleCallableStatement.setString(2, string);
            oracleCallableStatement.setInt(3, n);
            oracleCallableStatement.setInt(4, n2);
            oracleCallableStatement.executeUpdate();
            nArray = this.convertNumberToInteger((BigDecimal[])oracleCallableStatement.getARRAY(1).getArray());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int createProject(String string, String string2) {
        OracleCallableStatement oracleCallableStatement = null;
        int n = this.generateProjectID();
        int n2 = this.generateConnectionID();
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getMigReposConnection().prepareCall("{call REDSHIFT_CAPTURE.CaptureConnections(?,?,?,?)}");
            oracleCallableStatement.setInt(1, n);
            oracleCallableStatement.setInt(2, n2);
            oracleCallableStatement.setString(3, string);
            oracleCallableStatement.setString(4, string2);
            oracleCallableStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        }
        return n;
    }

    @Override
    public void setSourceDatabaseConnection(Connection connection) {
    }

    @Override
    public boolean isSourceOnlineConnection() {
        return false;
    }

    @Override
    public String[] getAllSourceDatabases(Connection connection) {
        return null;
    }

    @Override
    public String[] getSelectedSourceDatabases() {
        return null;
    }

    @Override
    public void setSelectedSourceDatabases(String[] stringArray) {
    }

    @Override
    public void setDatatypeMapping(HashMap hashMap) {
    }

    @Override
    public HashMap getDatatypeMapping(int n, int n2) {
        return null;
    }

    @Override
    public HashMap getDatatypeMapping(int n) {
        return null;
    }

    @Override
    public boolean isOnlineGeneration() {
        return false;
    }

    @Override
    public void setTargetDatabaseConnection(Connection connection) {
    }

    public static void main(String[] stringArray) {
    }

    @Override
    public void setMigrationRepository(Connection connection) {
        boolean bl = false;
        try {
            bl = MigrationRepositoryQuery.doesRepositoryExist(connection);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            this.m_migReposConnection = connection;
        }
    }

    @Override
    public void setMigrationRepository(String string) {
        boolean bl = false;
        try {
            Connection connection = null;
            bl = MigrationRepositoryQuery.doesRepositoryExist(connection);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            // empty if block
        }
    }

    public static boolean doesRepositoryExist(Connection connection) {
        if (connection == null) {
            return false;
        }
        boolean bl = false;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select * from md_connections where 1=0");
            bl = true;
        }
        catch (SQLException sQLException) {
            bl = false;
        }
        return bl;
    }

    public int[] convertNumberToInteger(BigDecimal[] bigDecimalArray) {
        int[] nArray = new int[bigDecimalArray.length];
        for (int i = 0; i < bigDecimalArray.length; ++i) {
            nArray[i] = bigDecimalArray[i].intValueExact();
        }
        return nArray;
    }

    public int generateProjectID() {
        int n = (int)(Math.random() * 10000.0 + 1.0);
        return n;
    }

    public int generateConnectionID() {
        int n = (int)(Math.random() * 100.0 + 1.0);
        return n;
    }

    public Connection getMigReposConnection() {
        return this.m_migReposConnection;
    }
}

