/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.ui.controller;

import java.util.ArrayList;
import oracle.dbtools.migration.cloud.CloudMigrationsResources;
import oracle.dbtools.migration.cloud.ui.model.CloudMigrationModel;

public class CloudMigrationController {
    private static CloudMigrationModel model = null;
    private static CloudMigrationController controller = null;

    private CloudMigrationController() {
        model = CloudMigrationModel.getInstance();
    }

    public static CloudMigrationController getInstance() {
        if (controller == null) {
            return new CloudMigrationController();
        }
        return controller;
    }

    public String toString() {
        return null;
    }

    public void setMetadataRepository(String string) {
        model.setString("REPOSITORY_METADATA_REPOSITORY_NAME_KEY", string);
    }

    public Boolean getMetadataRepository() {
        return model.getBoolean("REPOSITORY_METADATA_REPOSITORY_NAME_KEY");
    }

    public void setRepositoryTruncateFlag(boolean bl) {
        model.setBoolean("REPOSITORY_PAGE_TRUNCATE_KEY", new Boolean(bl));
    }

    public Boolean getRepositoryTruncateFlag() {
        return model.getBoolean("REPOSITORY_PAGE_TRUNCATE_KEY");
    }

    public void setProjectName(String string) {
        model.setString("REPOSITORY_PAGE_PROJECT_NAME_KEY", string);
    }

    public String getProjectName() {
        return model.getString("REPOSITORY_PAGE_PROJECT_NAME_KEY");
    }

    public void setProjectDescription(String string) {
        model.setString("REPOSITORY_PAGE_PROJECT_DESCRIPTION_KEY", string);
    }

    public String getProjectDescription() {
        return model.getString("REPOSITORY_PAGE_PROJECT_DESCRIPTION_KEY");
    }

    public void setReposCaptureVersion(String string) {
        model.setString("REPOSITORY_PAGE_CAPTURE_VERSION_KEY", string);
    }

    public String getReposCaptureVersion() {
        return model.getString("REPOSITORY_PAGE_CAPTURE_VERSION_KEY");
    }

    public void setCaptureType(String string) {
        model.setString("REPOSITORY_PAGE_CAPTURE_TYPE_KEY", string);
    }

    public String getCaptureValue() {
        return model.getString("REPOSITORY_PAGE_CAPTURE_TYPE_KEY");
    }

    public boolean isNewCapture() {
        String string = model.getString("REPOSITORY_PAGE_CAPTURE_TYPE_KEY");
        String string2 = this.getNLS("SUMMARY_REPOSPAGE_TREENODE_CAPTURE_TYPE_NEW_LABEL");
        if (string == null) {
            return true;
        }
        return string.equals(string2);
    }

    public void setDataSourceAccessChoice(String string) {
        model.setString("DATASOURCE_ACCESS_CHOICE_KEY", string);
    }

    public String getDataSourceAccessChoice() {
        return model.getString("DATASOURCE_ACCESS_CHOICE_KEY");
    }

    public void setDataSourceOfflineFile(String string) {
        model.setString("DATASOURCE_OFFLINE_FILE_KEY", string);
    }

    public String getDataSourceOfflineFile() {
        return model.getString("DATASOURCE_OFFLINE_FILE_KEY");
    }

    public void setDataSourceOfflineFileEncoding(String string) {
        model.setString("DATASOURCE_OFFLINE_FILE_KEY", string);
    }

    public String setDataSourceOfflineFileEncoding() {
        return model.getString("DATASOURCE_OFFLINE_FILE_KEY");
    }

    public void setDataSourceOnlineDatabase(String string) {
        model.setString("DATASOURCE_ONLINE_DATABASE_KEY", string);
    }

    public String getDataSourceOfflineFileEncoding() {
        return model.getString("DATASOURCE_ONLINE_DATABASE_KEY");
    }

    public void setReposConvertVersion(String string) {
        model.setString("CONVERT_CONVERT_VERSION_KEY", string);
    }

    public String getReposConvertVersion() {
        return model.getString("CONVERT_CONVERT_VERSION_KEY");
    }

    public void setReposGenerateVersion(String string) {
        model.setString("GENERATE_VERSION_KEY", string);
    }

    public String getReposGenerateVersion() {
        return model.getString("GENERATE_VERSION_KEY");
    }

    protected String getNLS(String string) {
        return CloudMigrationsResources.get(string);
    }

    public void setGenerateAccessChoice(String string) {
        model.setString("GENERATE_ACCESS_CHOICE_KEY", string);
    }

    public String getGenerateAccessChoice() {
        return model.getString("GENERATE_ACCESS_CHOICE_KEY");
    }

    public void setRedshiftProjectName(String string) {
        model.setString("REDSHIFT_PROJECT_NAME_KEY", string);
    }

    public String getRedshiftProjectName() {
        return model.getString("REDSHIFT_PROJECT_NAME_KEY");
    }

    public void setRedshiftMigrationType(String string) {
        model.setString("REDSHIFT_MIGRATION_TYPE_KEY", string);
    }

    public String getRedshiftMigrationType() {
        return model.getString("REDSHIFT_MIGRATION_TYPE_KEY");
    }

    public void setRedshiftDatabase(String string) {
        model.setSourceConnection(string);
        model.setString("REDSHIFT_DATABASE_KEY", string);
        if (string.startsWith("IdeConnections%23")) {
            int n = "IdeConnections%23".length();
            int n2 = string.length();
            String string2 = string.substring(n, n2);
            model.setString("REDSHIFT_DATABASE_DISPLAY_NAME_KEY", string2);
        }
    }

    public String getRedshiftDatabase() {
        return model.getString("REDSHIFT_DATABASE_KEY");
    }

    public String getRedshiftDatabaseDisplayName() {
        return model.getString("REDSHIFT_DATABASE_DISPLAY_NAME_KEY");
    }

    public void setDWCSConnection(String string) {
        model.setTargetConnection(string);
        model.setString("DWCS_DATABASE_KEY", string);
        if (string.startsWith("IdeConnections%23")) {
            int n = "IdeConnections%23".length();
            int n2 = string.length();
            String string2 = string.substring(n, n2);
            model.setString("DWCS_DATABASE_DISPLAY_NAME_KEY", string2);
        }
    }

    public String getDWCSConnection() {
        return model.getString("DWCS_DATABASE_KEY");
    }

    public void setS3Credential(String string) {
        model.setString("REDSHIFT_S3_CREDENTIAL_KEY", string);
    }

    public String getS3Credential() {
        return model.getString("REDSHIFT_S3_CREDENTIAL_KEY");
    }

    public void setS3Bucket(String string) {
        model.setString("REDSHIFT_S3_BUCKET_KEY", string);
    }

    public String getS3Bucket() {
        return model.getString("REDSHIFT_S3_BUCKET_KEY");
    }

    public void setAWSSecretAccess(String string) {
        model.setString("REDSHIFT_AWS_SECRET_ACCESS_TYPE_KEY", string);
    }

    public String getAWSSecretAccess() {
        return model.getString("REDSHIFT_AWS_SECRET_ACCESS_TYPE_KEY");
    }

    public void setAWSAccessKey(String string) {
        model.setString("REDSHIFT_AWS_ACCESS_TYPE_KEY", string);
    }

    public String getAWSAccessKey() {
        return model.getString("REDSHIFT_AWS_ACCESS_TYPE_KEY");
    }

    public void addToSelectedSchemas(String string) {
        model.addSchemaToSelectedSchemasList(string);
    }

    public void addToSelectedSchemas(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            model.addSchemaToSelectedSchemasList(stringArray[i]);
        }
    }

    public void cleanSelectedSchemas() {
        model.cleanSelectedSchemas();
    }

    public String getSelectedSchemaAsString() {
        String[] stringArray = model.getSelectedSchemas();
        String string = "";
        for (int i = 0; i < stringArray.length - 1; ++i) {
            string = string + stringArray[0] + ",";
        }
        string = string + stringArray[stringArray.length - 1];
        return string;
    }

    public String[] getSelectedSchemas() {
        return model.getSelectedSchemas();
    }

    public void removeFromSelectedSchemas(String string) {
        model.removeFromSelectedSchemas(string);
    }

    public void addToAvailableSchemas(String string) {
        model.addSchemaToAvailableSchemasList(string);
    }

    public void addToAvailableSchemas(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            model.addSchemaToAvailableSchemasList(stringArray[i]);
        }
    }

    public String[] getAvailableSchemas() {
        return model.getAvailableSchemas();
    }

    public String getAvailableSchemaAsString() {
        String[] stringArray = model.getAvailableSchemas();
        String string = "";
        if (stringArray != null && stringArray.length > 0 && (stringArray != null || stringArray.length <= 0 || stringArray[0] == "")) {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                string = string + stringArray[i] + ",";
            }
            string = string + stringArray[stringArray.length - 1];
        }
        return string;
    }

    public void removeFromAvailableSchemas(String string) {
        model.removeFromAvailableSchemas(string);
    }

    public void cleanAvailableSchemas() {
        model.cleanAvailableSchemas();
    }

    public void setScriptDownloadDirectory(String string) {
        model.setString("SCRIPT_DOWNLOAD_DIRECTORY_KEY", string);
    }

    public void setScriptDownloadDirectoryCheckboxState(boolean bl) {
        model.setBoolean("SCRIPT_DIRECTORY_CHECKBOX_SELECTED", bl);
    }

    public void doMigrationNow(boolean bl) {
        model.setBoolean("REDSHIFT_MIGRATION_DO_NOW_KEY", bl);
    }

    public boolean isMigrationNow() {
        return model.getBoolean("REDSHIFT_MIGRATION_DO_NOW_KEY");
    }

    public void setDWCSMetadataRepository(String string) {
        model.setString("DWCS_SQLDEV_METADATA_REPOSITORY_KEY", string);
    }

    public void setAdvancedPreferences(boolean bl) {
        model.setBoolean("REDSHIFT_MIGRATION_SET_ADVANCED_PREFERENCES_KEY", bl);
    }

    public void setMigrationRepositoryPassword(String string) {
        model.setString("MIGRATION_REPOSITORY_PASSWORD_KEY", string);
    }

    public void dropMigrationRepository(boolean bl) {
        model.setBoolean("DWCS_DROP_MIGRATION_REPOSITORY_KEY", bl);
    }

    public void showMigrationRepositoryPassword(boolean bl) {
        model.setBoolean("DWCS_SHOW_MIGRATION_REPOSITORY_PASSWORD_KEY", bl);
    }

    public void setRedactMigrationRepositoryPassword(String string) {
        model.setString("DWCS_SHOW_MIGRATION_REPOSITORY_REDACTED_PASSWORD_KEY", string);
    }

    public void setSettingARSCompressionMethod(String string) {
        model.setString("ARS.COMPRESS", string);
    }

    public void setSettingARSDelimiter(String string) {
        model.setString("ARS.DELIMITER", string);
    }

    public void setSettingARSFixedWidth(String string) {
        model.setString("ARS.FIXEDWIDTH", string);
    }

    public void setSettingARSMaxFileSizeUnit(String string) {
        model.setString("ARS.MAXFILESIZEUNIT", string);
    }

    public void setSettingARSNull(String string) {
        model.setString("ARS.NULL", string);
    }

    public void setSettingARSParallel(Boolean bl) {
        model.setBoolean("ARS.PARALLEL", bl);
    }

    public void setSettingARSIsEscape(Boolean bl) {
        model.setBoolean("ARS.ESCAPE", bl);
    }

    public void setSettingARSAddQuotes(Boolean bl) {
        model.setBoolean("ARS.ADDQUOTES", bl);
    }

    public void setSettingARSEncrypt(Boolean bl) {
        model.setBoolean("ARS.ENCRYPT", bl);
    }

    public void setSettingARSOverwrite(Boolean bl) {
        model.setBoolean("ARS.OVERWRITE", bl);
    }

    public void setSettingARSManifest(Boolean bl) {
        model.setBoolean("ARS.MANIFEST", bl);
    }

    public void setSettingARSMaxFile(Boolean bl) {
        model.setBoolean("ARS.MAXFILE", bl);
    }

    public void setSettingARSMaxFileSize(Integer n) {
        model.setString("ARS.MAXFILESIZE", n.toString());
    }

    public void setSettingCPDBlockAsNull(Boolean bl) {
        model.setBoolean("CPD.BLKASNULL", bl);
    }

    public void setSettingCPDEscape(Boolean bl) {
        model.setBoolean("CPD.ESCAPE", bl);
    }

    public void setSettingCPDIgnoreBlockLines(Boolean bl) {
        model.setBoolean("CPD.IGNBLKLINES", bl);
    }

    public void setSettingCPDIgnoreMissingColumns(Boolean bl) {
        model.setBoolean("CPD.IGNMISCOLS", bl);
    }

    public void setSettingCPDRemoveQuotes(Boolean bl) {
        model.setBoolean("CPD.REMQUOTES", bl);
    }

    public void setSettingCPDTruncateLongColumns(Boolean bl) {
        model.setBoolean("CPD.TRUNCLNGCOLS", bl);
    }

    public void setSettingCPDIsFileType(Boolean bl) {
        model.setBoolean("CPD.ISFILETYPE", bl);
    }

    public void setSettingCPDRecordDelimiter(String string) {
        model.setString("CPD.RECDELIM", string);
    }

    public void setSettingCPD_rejlim(Integer n) {
        model.setInteger("CPD.REJLIM", n);
    }

    public void setSettingCPDSkipHeaders(String string) {
        model.setString("CPD.SKIPHDRS", string);
    }

    public void setSettingCPDCompress(String string) {
        model.setString("CPD.COMPRESS", string);
    }

    public void setSettingCPDCONVERRS(String string) {
        model.setString("CPD.CONVERRS", string);
    }

    public void setSettingCPDTrimSpaces(String string) {
        model.setString("CPD.TRIMSPACES", string);
    }

    public void setSettingCPDFileType(String string) {
        model.setString("CPD.FILETYPE", string);
    }

    public void setSettingCPDColumnDelimter(String string) {
        model.setString("CPD.COLDELIMITER", string);
    }

    public void setSettingCPDQuote(String string) {
        model.setString("CPD.QUOTE", string);
    }

    public void addToPreviouslyDeployedSchemas(ArrayList<String> arrayList) {
        for (String string : arrayList) {
            model.addSchemaToPreviouslyDeployedSchemasList(string);
        }
    }

    public void addToPreviouslyDeployedSchema(String string) {
        model.addSchemaToPreviouslyDeployedSchemasList(string);
    }

    public void removePreviouslyDeployedSchemas() {
        model.removePreviouslyDeployedSchemasList();
    }

    public void addNewDeployedSchema(String string) {
        model.addSchemaToNewDeployableSchemasList(string);
    }

    public void removeNewDeployedSchemas() {
        model.removePreviouslyDeployedSchemasList();
    }

    public void setNavigatorInvocationContext() {
        model.setNavigatorInvocationContext();
    }

    public void setMenuInvocationContext() {
        model.setMenuInvocationContext();
    }

    public boolean getNavigatorInvocationContext() {
        return model.getNavigatorInvocationContext();
    }

    public boolean getMenuInvocationContext() {
        return model.getMenuInvocationContext();
    }

    public void clearSchemaLists() {
        model.clearAllLists();
    }
}

