/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.ui.wizard.RedshiftPanels;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.dbtools.migration.cloud.capture.redshift.online.RedshiftQueryCapture;
import oracle.dbtools.migration.cloud.ui.controller.CloudMigrationController;
import oracle.dbtools.migration.cloud.ui.model.CloudMigrationModel;
import oracle.dbtools.migration.cloud.ui.validate.RedshiftAccessKeySecretAccessS3BucketValidationException;
import oracle.dbtools.migration.cloud.ui.validate.RedshiftAccessKeyValidationException;
import oracle.dbtools.migration.cloud.ui.validate.RedshiftConnectionValidationException;
import oracle.dbtools.migration.cloud.ui.validate.RedshiftS3BucketValidationException;
import oracle.dbtools.migration.cloud.ui.validate.RedshiftSecretAccessValidationException;
import oracle.dbtools.migration.cloud.ui.validate.Validator;
import oracle.dbtools.migration.cloud.ui.widgets.AvailableDatabasesShuttlePanel;
import oracle.dbtools.migration.cloud.ui.wizard.CloudMigrationWizardPanel;
import oracle.dbtools.migration.cloud.ui.wizard.RedshiftPanels.RedshiftConnectionUIPanel;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;

public class RedshiftPagePanel
extends CloudMigrationWizardPanel {
    private static boolean DEBUG = false;
    private boolean firstEntryFlag = false;
    JLabel migrationHeaderLabel;
    JLabel selectMedataRepositoryLabel;
    RedshiftConnectionUIPanel connPanel;
    JPanel contentReposPanel;
    JComboBox<String> credentialComboBox;
    JTextField myConnection;
    AvailableDatabasesShuttlePanel availableDatabasesShuttlePanel;
    private static CloudMigrationController cloudMigrationController;

    @Override
    public void onEntry(TraversableContext traversableContext) {
        if (DEBUG) {
            System.out.println("On Entry");
        }
        super.onEntry(traversableContext);
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    @Override
    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (DEBUG) {
            System.out.println("On Exit");
        }
        super.onExit(traversableContext);
        this.setFirstEntryFlag();
    }

    @Override
    protected void initGui() {
        cloudMigrationController = CloudMigrationController.getInstance();
        this.unsetFirstEntryFlag();
        this.availableDatabasesShuttlePanel = new AvailableDatabasesShuttlePanel();
        try {
            Serializable serializable;
            this.selectMedataRepositoryLabel = new JLabel(this.nls("REDSHIFT_SELECT_SOURCE_LABEL"));
            Font font = this.selectMedataRepositoryLabel.getFont();
            Font font2 = new Font(font.getFontName(), 1, font.getSize());
            this.selectMedataRepositoryLabel.setFont(font2);
            this.connPanel = new RedshiftConnectionUIPanel();
            this.connPanel.setConnectionPrompt(this.nls("REDSHIFT_CONNECTIONS"));
            this.connPanel.addComboListener(new ConnectionPanelItemListener());
            if (cloudMigrationController.getMenuInvocationContext()) {
                this.connPanel.setConnectionName(null);
                cloudMigrationController.clearSchemaLists();
            }
            if (cloudMigrationController.getNavigatorInvocationContext()) {
                this.connPanel.setConnectionName(cloudMigrationController.getRedshiftDatabase());
                ArrayList arrayList = new ArrayList();
                Collections.addAll(arrayList, new HashSet<String>(Arrays.asList(cloudMigrationController.getAvailableSchemas())).toArray(new String[0]));
                serializable = new ArrayList();
                Collections.addAll(serializable, cloudMigrationController.getSelectedSchemas());
                arrayList.removeAll((Collection<?>)((Object)serializable));
                cloudMigrationController.cleanAvailableSchemas();
                cloudMigrationController.addToAvailableSchemas(arrayList.toArray(new String[0]));
            }
            this.contentReposPanel = LayoutControl.GBC.createPanel();
            int n = 0;
            this.contentReposPanel.add((Component)this.selectMedataRepositoryLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            this.contentReposPanel.add((Component)((Object)this.connPanel), LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            serializable = this.getSchemaSelectionPanel();
            this.contentReposPanel.add((Component)serializable, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            JPanel jPanel = this.getMigrationChoicePanel();
            this.contentReposPanel.add((Component)jPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            LayoutControl.GBC.addVSpring((JPanel)this.contentReposPanel, (int)(++n));
            this.add(LayoutControl.GBC.createWizardPanel((Component)this.contentReposPanel));
            Connections.getInstance().addConnectionListener(new ConnectionListener(){

                public void connectionAdded(ConnectionEvent connectionEvent) {
                    this.resetConnections();
                }

                private void resetConnections() {
                    if (RedshiftPagePanel.this.connPanel != null) {
                        RedshiftPagePanel.this.connPanel.resetConnections();
                    }
                }

                public void connectionRemoved(ConnectionEvent connectionEvent) {
                    this.resetConnections();
                }

                public void connectionRenamed(ConnectionEvent connectionEvent) {
                    this.resetConnections();
                }

                public void connectionModified(ConnectionEvent connectionEvent) {
                }

                public void connectionOpened(ConnectionEvent connectionEvent) {
                }

                public void connectionClosed(ConnectionEvent connectionEvent) {
                }
            });
        }
        catch (Throwable throwable) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)throwable.getMessage(), (String)"Redshift", null);
            Logger.severe(((Object)((Object)this)).getClass(), (Throwable)throwable);
        }
    }

    private JPanel getSchemaSelectionPanel() throws Exception {
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        JPanel jPanel2 = this.availableDatabasesShuttlePanel.createShuttlePanel();
        jPanel.add((Component)jPanel2, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        if (cloudMigrationController.getMenuInvocationContext()) {
            cloudMigrationController.cleanAvailableSchemas();
            cloudMigrationController.cleanSelectedSchemas();
            this.availableDatabasesShuttlePanel.clearBothListModels();
        }
        if (cloudMigrationController.getNavigatorInvocationContext()) {
            this.updateSchemaInShuttleBox();
        }
        return jPanel;
    }

    private void updateSchemaInShuttleBox() throws Exception {
        String string = cloudMigrationController.getRedshiftDatabase();
        if (string == null) {
            this.availableDatabasesShuttlePanel.cleanBothLists();
            return;
        }
        String[] stringArray = cloudMigrationController.getAvailableSchemas();
        String[] stringArray2 = cloudMigrationController.getSelectedSchemas();
        if (string.trim().length() > 0 && stringArray2 != null && stringArray2.length == 0) {
            String[] stringArray3 = RedshiftQueryCapture.getRedshiftSchemaNames(string);
            this.availableDatabasesShuttlePanel.updateAvailableSchemasListModel(stringArray3);
            this.availableDatabasesShuttlePanel.addShuttleListener(new SchemaSelectionShuttleListener());
            cloudMigrationController.addToAvailableSchemas(stringArray3);
        } else if (string.trim().length() > 0 && stringArray2 != null && stringArray2.length > 0 && stringArray != null && stringArray.length >= 0) {
            this.availableDatabasesShuttlePanel.updateAvailableSchemasListModel(stringArray);
            this.availableDatabasesShuttlePanel.updateSelectedSchemasListModel(stringArray2);
            this.availableDatabasesShuttlePanel.addShuttleListener(new SchemaSelectionShuttleListener());
        } else {
            this.availableDatabasesShuttlePanel.cleanBothLists();
        }
    }

    private JPanel getMigrationChoicePanel() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        int n = 0;
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setText(this.nls("REDSHIFT_PAGE_MIGRATION_CHOICE_INCLUDE_DATA"));
        jCheckBox.setSelected(true);
        cloudMigrationController.setRedshiftMigrationType(this.nls("REDSHIFT_PAGE_MIGRATION_CHOICE_DDL_DATA"));
        jPanel.add((Component)jCheckBox, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        jPanel.add((Component)this.createDdlAndDataPanel(), LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (((JCheckBox)actionEvent.getSource()).isSelected()) {
                    cloudMigrationController.setRedshiftMigrationType(RedshiftPagePanel.this.nls("REDSHIFT_PAGE_MIGRATION_CHOICE_DDL_DATA"));
                } else {
                    cloudMigrationController.setRedshiftMigrationType(RedshiftPagePanel.this.nls("REDSHIFT_PAGE_MIGRATION_CHOICE_ONLY_DDL"));
                }
            }
        });
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        return jPanel;
    }

    private JPanel createDdlPanel() {
        return new JPanel();
    }

    private JPanel createDataPanel() {
        return this.createDdlAndDataPanel();
    }

    private JPanel createDdlAndDataPanel() {
        JPanel jPanel = LayoutControl.GBC.createPanel();
        final JTextField jTextField = new JTextField();
        JLabel jLabel = new JLabel(this.nls("REDSHIFT_MIGRATION_CHOICE_DDL_DATA_S3_BUCKET_URI_LABEL"));
        jLabel.setLabelFor(jTextField);
        final JTextField jTextField2 = new JTextField();
        JLabel jLabel2 = new JLabel(this.nls("SUMMARY_REDSHIFT_TREENODE_MIGRATION_AWS_ACCESS_KEY_LABEL"));
        jLabel2.setLabelFor(jTextField2);
        final JTextField jTextField3 = new JTextField();
        JLabel jLabel3 = new JLabel(this.nls("SUMMARY_REDSHIFT_TREENODE_MIGRATION_AWS_SECRET_ACCESS_LABEL"));
        jLabel3.setLabelFor(jTextField3);
        int n = 0;
        jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        jPanel.add((Component)jTextField2, LayoutControl.GBC.gbc((int)1, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jTextField2.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                cloudMigrationController.setAWSAccessKey(jTextField2.getText());
            }
        });
        jPanel.add((Component)jLabel3, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        jPanel.add((Component)jTextField3, LayoutControl.GBC.gbc((int)1, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jTextField3.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                cloudMigrationController.setAWSSecretAccess(jTextField3.getText());
            }
        });
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE));
        jPanel.add((Component)jTextField, LayoutControl.GBC.gbc((int)1, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                cloudMigrationController.setS3Bucket(jTextField.getText());
            }
        });
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        return jPanel;
    }

    @Override
    protected void updateUIFromModel(CloudMigrationModel cloudMigrationModel) {
        String string;
        if (DEBUG) {
            System.out.println("updateUIFromModel ......firstEntryFlag=" + this.isFirstEntryFlag());
        }
        if (cloudMigrationController.getMenuInvocationContext()) {
            if (!this.isFirstEntryFlag()) {
                cloudMigrationController.setRedshiftDatabase("");
                this.connPanel.setConnectionName(null);
                this.connPanel.getConnCombo().getModel().setSelectedItem("");
            } else {
                string = cloudMigrationController.getRedshiftDatabase();
                if (string != null) {
                    this.connPanel.setConnectionName(string);
                    this.connPanel.getConnCombo().getModel().setSelectedItem(string);
                }
            }
        }
        if (cloudMigrationController.getNavigatorInvocationContext() && (string = cloudMigrationController.getRedshiftDatabase()) != null) {
            this.connPanel.setConnectionName(string);
            this.connPanel.getConnCombo().getModel().setSelectedItem(string);
        }
    }

    @Override
    protected void updateModelFromUI(CloudMigrationModel cloudMigrationModel) {
    }

    @Override
    protected void updateModelFromController(CloudMigrationController cloudMigrationController) {
        if (DEBUG) {
            System.out.println("updateModelFromController ......");
        }
    }

    @Override
    protected void validatePage(TraversableContext traversableContext) throws TraversalException {
        CloudMigrationModel cloudMigrationModel = (CloudMigrationModel)((Object)traversableContext.get(CloudMigrationModel.KEY));
        this.validateRedshiftConnection(cloudMigrationModel);
        this.validateAvailableSchemas(cloudMigrationModel);
        this.validateSelectedSchemas(cloudMigrationModel);
        this.validateRedshiftAccessKey(cloudMigrationModel);
        this.validateRedshiftSecretAccess(cloudMigrationModel);
        this.validateRedshift3Bucket(cloudMigrationModel);
        try {
            this.validateRedshiftAccessKeySecretAccessS3Bucket(cloudMigrationModel);
        }
        catch (Exception exception) {
            throw new TraversalException((Object)exception);
        }
    }

    private void validateRedshiftConnection(CloudMigrationModel cloudMigrationModel) throws RedshiftConnectionValidationException {
        Validator.validateRedshiftConnection(cloudMigrationModel.getSourceConnection());
    }

    private void validateAvailableSchemas(CloudMigrationModel cloudMigrationModel) throws RedshiftConnectionValidationException {
        Validator.validateAvailablechemas(cloudMigrationModel.getAvailableSchemas(), cloudMigrationModel.getSelectedSchemas());
    }

    private void validateSelectedSchemas(CloudMigrationModel cloudMigrationModel) throws RedshiftConnectionValidationException {
        Validator.validateSelectedSchemas(cloudMigrationModel.getSelectedSchemas());
    }

    private void validateRedshiftAccessKey(CloudMigrationModel cloudMigrationModel) throws RedshiftAccessKeyValidationException {
        String string = cloudMigrationModel.getString("REDSHIFT_AWS_ACCESS_TYPE_KEY");
        Validator.validateRedshiftAccessKey(string);
    }

    private void validateRedshiftSecretAccess(CloudMigrationModel cloudMigrationModel) throws RedshiftSecretAccessValidationException {
        Validator.validateRedshiftSecretAccess(cloudMigrationModel.getString("REDSHIFT_AWS_SECRET_ACCESS_TYPE_KEY"));
    }

    private void validateRedshift3Bucket(CloudMigrationModel cloudMigrationModel) throws RedshiftS3BucketValidationException {
        Validator.validateRedshift3Bucket(cloudMigrationModel.getString("REDSHIFT_S3_BUCKET_KEY"));
    }

    private void validateRedshiftAccessKeySecretAccessS3Bucket(CloudMigrationModel cloudMigrationModel) throws RedshiftAccessKeySecretAccessS3BucketValidationException, Exception {
        Validator.validateRedshiftAccessKeySecretAccessS3Bucket(cloudMigrationModel);
    }

    public boolean isFirstEntryFlag() {
        return this.firstEntryFlag;
    }

    public void setFirstEntryFlag() {
        this.firstEntryFlag = true;
        if (DEBUG) {
            System.out.println("Set: First Entry Flag=" + this.firstEntryFlag);
        }
    }

    public void unsetFirstEntryFlag() {
        this.firstEntryFlag = false;
        if (DEBUG) {
            System.out.println("Unset: First Entry Flag=" + this.firstEntryFlag);
        }
    }

    class SchemaSelectionShuttleListener
    implements ShuttleListener {
        SchemaSelectionShuttleListener() {
        }

        public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
            RedshiftPagePanel.this.availableDatabasesShuttlePanel.updateBothList();
        }

        public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
            RedshiftPagePanel.this.availableDatabasesShuttlePanel.updateBothList();
        }

        public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
        }
    }

    class S3CredentialtemListener
    implements ItemListener {
        S3CredentialtemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Logger.info(this.getClass(), (String)("S3CredentialtemListener.itemStateChanged, " + itemEvent.getStateChange()));
            String string = (String)((JComboBox)itemEvent.getSource()).getSelectedItem();
            cloudMigrationController.setS3Credential(string);
        }
    }

    class MigrationTypeItemListener
    implements ItemListener {
        MigrationTypeItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            cloudMigrationController.setRedshiftMigrationType((String)((JComboBox)itemEvent.getSource()).getSelectedItem());
        }
    }

    class ConnectionPanelItemListener
    implements ItemListener {
        ConnectionPanelItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            String string = null;
            if (DEBUG) {
                System.out.println("ConnectionPanelItemListener.itemStateChanged ......" + itemEvent.getStateChange());
            }
            Logger.info(this.getClass(), (String)("ConnectionPanelItemListener.itemStateChanged, " + itemEvent.getStateChange()));
            Object object = ((JComboBox)itemEvent.getSource()).getSelectedItem();
            if (object != null) {
                string = (String)object;
            }
            try {
                if (string != null && string.length() > 0) {
                    RedshiftQueryCapture.getRedshiftSchemaNames(string);
                    cloudMigrationController.setRedshiftDatabase(string);
                } else {
                    cloudMigrationController.setRedshiftDatabase("");
                    RedshiftPagePanel.this.connPanel.setConnectionName(null);
                }
                RedshiftPagePanel.this.updateSchemaInShuttleBox();
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)"Redshift", null);
                cloudMigrationController.setRedshiftDatabase("");
                RedshiftPagePanel.this.connPanel.setConnectionName(null);
                RedshiftPagePanel.this.availableDatabasesShuttlePanel.cleanBothLists();
                RedshiftPagePanel.this.connPanel.getConnCombo().getModel().setSelectedItem("");
            }
        }
    }
}

