/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.bookmarks;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ide.Context;
import oracle.ide.bookmarks.Bookmark;
import oracle.ide.bookmarks.BookmarkComparator;
import oracle.ide.bookmarks.BookmarkEvent;
import oracle.ide.bookmarks.BookmarkListener;
import oracle.ide.bookmarks.BookmarkOptions;
import oracle.ide.bookmarks.URLBookmark;
import oracle.ide.config.Preferences;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.javatools.data.PropertyStorage;

public final class BookmarkManager {
    private Set<Bookmark> bookmarks = new ConcurrentSkipListSet<Bookmark>(new BookmarkComparator());
    private final int SIZE_NUMBERED_BOOKMARKS = 10;
    private List<Bookmark> numberedBookmarks = new ArrayList<Bookmark>(10);
    private static BookmarkManager INSTANCE = new BookmarkManager();
    private final List<BookmarkListener> listeners;

    private BookmarkManager() {
        for (int i = 0; i < 10; ++i) {
            this.numberedBookmarks.add(null);
        }
        this.listeners = new CopyOnWriteArrayList<BookmarkListener>();
    }

    public static BookmarkManager getBookmarkManager() {
        return INSTANCE;
    }

    public void addBookmark(Bookmark bookmark) {
        this.bookmarks.add(bookmark);
        this.fireBookmarkEvent(new BookmarkEvent(BookmarkEvent.Type.ADDITION, bookmark));
    }

    public void removeBookmark(Bookmark bookmark) {
        this.bookmarks.remove(bookmark);
        int index = this.numberedBookmarks.indexOf(bookmark);
        if (index > -1) {
            this.numberedBookmarks.set(index, null);
        }
        this.fireBookmarkEvent(new BookmarkEvent(BookmarkEvent.Type.REMOVAL, bookmark));
    }

    public void setBookmarkNumber(Bookmark bookmark, int number) {
        Bookmark oldBookmark;
        if (number > 10) {
            throw new IllegalArgumentException("Bookmark number out of range: 0-9");
        }
        if (!this.bookmarks.contains(bookmark)) {
            throw new IllegalStateException("Attempting to number a bookmark that hasn't been added (or has been removed)" + bookmark);
        }
        int index = this.numberedBookmarks.indexOf(bookmark);
        if (index > -1) {
            this.numberedBookmarks.set(index, null);
        }
        Bookmark bookmark2 = oldBookmark = number == -1 ? null : this.numberedBookmarks.get(number);
        if (number > -1) {
            this.numberedBookmarks.set(number, bookmark);
        }
        if (oldBookmark != null) {
            this.removeBookmark(oldBookmark);
        }
        this.fireBookmarkEvent(new BookmarkEvent(BookmarkEvent.Type.UPDATE, bookmark));
    }

    public void addBookmarkListener(BookmarkListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeBookmarkListener(BookmarkListener listener) {
        this.listeners.remove(listener);
    }

    public void fireBookmarkEvent(BookmarkEvent event) {
        for (BookmarkListener listener : this.listeners) {
            listener.bookmarksChanged(event);
        }
    }

    public Collection<Bookmark> getAllBookmarks() {
        return Collections.unmodifiableCollection(this.bookmarks);
    }

    Bookmark getNumberedBookmark(int number) {
        return this.numberedBookmarks.get(number);
    }

    void gotoNumberedBookmark(int index) {
        Bookmark bookmark = this.numberedBookmarks.get(index);
        if (bookmark != null) {
            bookmark.gotoBookmark();
        }
    }

    void removeAllBookmarks() {
        for (Object bookmark : this.bookmarks.toArray()) {
            this.removeBookmark((Bookmark)bookmark);
        }
    }

    public int getBookmarkNumber(Bookmark bookmark) {
        return this.numberedBookmarks.indexOf(bookmark);
    }

    public void cycleBookmark(Context context, boolean forward) {
        int index = 0;
        List<Bookmark> list = new ArrayList<Bookmark>(this.bookmarks);
        if ((list = this.filterBookmarksByTraversal(list)).isEmpty()) {
            return;
        }
        block5: for (int i = 0; i < list.size(); ++i) {
            Bookmark bookmark = list.get(i);
            switch (bookmark.compareTo(context)) {
                case EQUAL: {
                    if (forward) {
                        index = i + 1;
                        if (index < list.size()) break block5;
                        index = 0;
                        break block5;
                    }
                    index = i - 1;
                    if (index >= 0) break block5;
                    index = list.size() - 1;
                    break block5;
                }
                case AFTER: {
                    if (!forward) break block5;
                    index = i;
                    break block5;
                }
                case BEFORE: {
                    if (!forward) {
                        index = i;
                    }
                }
                default: {
                    continue block5;
                }
            }
        }
        Bookmark bookmark = list.get(index);
        bookmark.gotoBookmark();
    }

    private List<Bookmark> filterBookmarksByTraversal(List<Bookmark> bookmarks) {
        EditorManager editorManager;
        BookmarkOptions options = BookmarkOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        int traversal = options.getTraverseBehavior();
        if (traversal == 3) {
            return bookmarks;
        }
        ArrayList<Bookmark> filtered = new ArrayList<Bookmark>();
        if (traversal == 1) {
            editorManager = EditorManager.getEditorManager();
            Context context = editorManager.getCurrentEditor().getContext();
            if (context == null || context.getNode() == null || context.getNode().getURL() == null) {
                return Collections.emptyList();
            }
            URL url = context.getNode().getURL();
            for (Bookmark bookmark : bookmarks) {
                URL bookmarkURL;
                if (!(bookmark instanceof URLBookmark) || !url.equals(bookmarkURL = ((URLBookmark)bookmark).getURL())) continue;
                filtered.add(bookmark);
            }
        }
        if (traversal == 2) {
            editorManager = EditorManager.getEditorManager();
            HashSet<URL> editorURLs = new HashSet<URL>();
            for (Editor editor : editorManager.getAllEditors()) {
                Context context = editor.getContext();
                if (context == null || context.getNode() == null || context.getNode().getURL() == null) continue;
                editorURLs.add(context.getNode().getURL());
            }
            if (editorURLs.size() == 0) {
                return Collections.emptyList();
            }
            for (Bookmark bookmark : bookmarks) {
                URL bookmarkURL;
                if (!(bookmark instanceof URLBookmark) || !editorURLs.contains(bookmarkURL = ((URLBookmark)bookmark).getURL())) continue;
                filtered.add(bookmark);
            }
        }
        return filtered;
    }

    boolean hasNextPrevious() {
        EditorManager editorManager;
        Collection<Bookmark> bookmarks = this.getAllBookmarks();
        BookmarkOptions options = BookmarkOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        int traversal = options.getTraverseBehavior();
        if (traversal == 3) {
            return bookmarks.size() > 0;
        }
        int count = 0;
        if (traversal == 1) {
            editorManager = EditorManager.getEditorManager();
            Editor editor = editorManager.getCurrentEditor();
            if (editor == null) {
                return false;
            }
            Context context = editor.getContext();
            if (context == null || context.getNode() == null || context.getNode().getURL() == null) {
                return false;
            }
            URL url = context.getNode().getURL();
            for (Bookmark bookmark : bookmarks) {
                if (!(bookmark instanceof URLBookmark)) continue;
                URL bookmarkURL = ((URLBookmark)bookmark).getURL();
                if (url.equals(bookmarkURL)) {
                    ++count;
                }
                if (count <= 0) continue;
                return true;
            }
        }
        if (traversal == 2) {
            editorManager = EditorManager.getEditorManager();
            HashSet<URL> editorURLs = new HashSet<URL>();
            for (Editor editor : editorManager.getAllEditors()) {
                Context context = editor.getContext();
                if (context == null || context.getNode() == null || context.getNode().getURL() == null) continue;
                editorURLs.add(context.getNode().getURL());
            }
            if (editorURLs.size() == 0) {
                return false;
            }
            for (Bookmark bookmark : bookmarks) {
                if (!(bookmark instanceof URLBookmark)) continue;
                URL bookmarkURL = ((URLBookmark)bookmark).getURL();
                if (editorURLs.contains(bookmarkURL)) {
                    ++count;
                }
                if (count <= 0) continue;
                return true;
            }
        }
        return count > 0;
    }
}

