/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.macos;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import oracle.dbtools.util.Logger;
import oracle.ide.controller.IdeAction;

public abstract class MacOSSupport {
    private static final String ORACLE_IDE_IGNORE_CHECK_EXIT = "oracle.ide.ignore.checkExit";

    protected static Class<?> loadClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.severe(MacOSSupport.class, (Throwable)classNotFoundException);
            return null;
        }
    }

    protected final Object createHandler(Class<?> clazz, EventHandler eventHandler) {
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)eventHandler);
    }

    protected final void registerHandler(Object object, String string, Class<?> clazz, EventHandler eventHandler) {
        Class<?> clazz2 = object.getClass();
        try {
            Method method = clazz2.getDeclaredMethod(string, clazz);
            method.invoke(object, this.createHandler(clazz, eventHandler));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
            Logger.severe(MacOSSupport.class, (Throwable)exception);
        }
    }

    public void registerHandlers() {
        this.registerPreferencesHandler(this.createPreferencesHandler());
        this.registerAboutHandler(this.createAboutHandler());
        this.registerQuitHandler(this.createQuitHandler());
    }

    protected EventHandler createPreferencesHandler() {
        return new EventHandler(38);
    }

    protected EventHandler createAboutHandler() {
        return new EventHandler(79);
    }

    protected EventHandler createQuitHandler() {
        return new QuitHandler(this.getQuitResponseMethod());
    }

    protected Method getQuitResponseMethod() {
        Class<?> clazz = MacOSSupport.loadClass(this.getQuitResponseClassname());
        if (clazz != null) {
            try {
                return clazz.getDeclaredMethod(this.getQuitCancelResponseMethod(), new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                Logger.severe(MacOSSupport.class, (Throwable)exception);
            }
        }
        return null;
    }

    private void registerHandler(String string, String string2, EventHandler eventHandler) {
        Class<?> clazz;
        Object object = this.getOSIntegrationManager();
        if (object != null && (clazz = MacOSSupport.loadClass(string)) != null) {
            this.registerHandler(object, string2, clazz, eventHandler);
        }
    }

    protected void registerPreferencesHandler(EventHandler eventHandler) {
        this.registerHandler(this.getPreferencesHandlerClassname(), this.getPreferencesHandlerMethod(), eventHandler);
    }

    protected void registerAboutHandler(EventHandler eventHandler) {
        this.registerHandler(this.getAboutHandlerClassname(), this.getAboutHandlerMethod(), eventHandler);
    }

    protected void registerQuitHandler(EventHandler eventHandler) {
        String string = System.getProperty(ORACLE_IDE_IGNORE_CHECK_EXIT);
        if (string == null) {
            System.setProperty(ORACLE_IDE_IGNORE_CHECK_EXIT, Boolean.TRUE.toString());
        }
        this.registerHandler(this.getQuitHandlerClassname(), this.getQuitHandlerMethod(), eventHandler);
        if (string == null) {
            System.clearProperty(ORACLE_IDE_IGNORE_CHECK_EXIT);
        }
    }

    protected abstract String getPreferencesHandlerClassname();

    protected abstract String getAboutHandlerClassname();

    protected abstract String getQuitHandlerClassname();

    protected abstract String getQuitResponseClassname();

    protected abstract Object getOSIntegrationManager();

    protected String getPreferencesHandlerMethod() {
        return "setPreferencesHandler";
    }

    protected String getAboutHandlerMethod() {
        return "setAboutHandler";
    }

    protected String getQuitHandlerMethod() {
        return "setQuitHandler";
    }

    protected String getQuitCancelResponseMethod() {
        return "cancelQuit";
    }

    protected static class QuitHandler
    extends EventHandler {
        private final Method responseMethod;

        public QuitHandler(Method method) {
            super(4);
            this.responseMethod = method;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            this.responseMethod.invoke(objectArray[1], new Object[0]);
            return super.invoke(object, method, objectArray);
        }
    }

    protected static class EventHandler
    implements InvocationHandler {
        private final int cmdID;

        public EventHandler(int n) {
            this.cmdID = n;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            try {
                IdeAction ideAction = IdeAction.find((int)this.cmdID);
                ideAction.performAction();
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                Logger.warn(MacOSSupport.class, (Throwable)throwable);
            }
            return null;
        }
    }
}

