/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ssh.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.dbtools.util.Pair;

public enum SshConfigParameter {
    PreferredAuthentications(Type.STRING_LIST, "gssapi-with-mic", "publickey", "keyboard-interactive", "password"),
    IdentityFile(Type.STRING, false),
    NumberOfPasswordPrompts(Type.NUMBER, new String[0]),
    ConnectTimeout(Type.NUMBER, new String[0]),
    KexAlgorithms(Type.STRING_LIST, "diffie-hellman-group-exchange-sha1", "diffie-hellman-group1-sha1", "diffie-hellman-group14-sha1", "diffie-hellman-group-exchange-sha256", "ecdh-sha2-nistp256", "ecdh-sha2-nistp384", "ecdh-sha2-nistp521"),
    HostKeyAlgorithms(Type.STRING_LIST, "ssh-dss", "ssh-rsa", "ecdsa-sha2-nistp256", "ecdsa-sha2-nistp384", "ecdsa-sha2-nistp521"),
    Ciphers(Type.STRING_LIST, "blowfish-cbc", "3des-cbc", "aes128-cbc", "aes192-cbc", "aes256-cbc", "aes128-ctr", "aes192-ctr", "aes256-ctr", "3des-ctr,arcfour", "arcfour128", "arcfour256"),
    Macs(Type.STRING_LIST, "hmac-md5", "hmac-sha1", "hmac-md5-96", "hmac-sha1-96"),
    Compression(Type.STRING, "yes", "no"),
    ForwardAgent(Type.STRING, "yes", "no"),
    RequestTTY(Type.STRING, "yes", "no", "auto", "force"),
    ServerAliveInterval(Type.NUMBER, new String[0]);

    private final Type type;
    private final int lowerBound;
    private final int upperBound;
    private final Collection<String> allowedValues;
    private boolean unique;

    public static String convertToConfigString(List<Pair<SshConfigParameter, String>> values) {
        StringBuilder b = new StringBuilder();
        for (Pair<SshConfigParameter, String> pair : values) {
            SshConfigParameter param = (SshConfigParameter)((Object)pair.first());
            b.append(param.name()).append('=').append((String)pair.second()).append("\n");
        }
        return b.toString();
    }

    private SshConfigParameter(Type type, boolean unique) {
        this.type = type;
        this.unique = unique;
        this.lowerBound = 0;
        this.upperBound = Integer.MAX_VALUE;
        this.allowedValues = Collections.emptySet();
    }

    private SshConfigParameter(Type type, int lowerBound, int upperBound) {
        this.type = type;
        this.unique = true;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.allowedValues = Collections.emptySet();
    }

    private SshConfigParameter(Type type, String ... allowedValues) {
        this.type = type;
        this.unique = true;
        this.lowerBound = 0;
        this.upperBound = Integer.MAX_VALUE;
        this.allowedValues = allowedValues != null ? Collections.unmodifiableCollection(Arrays.asList(allowedValues)) : Collections.emptySet();
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getUpperBound() {
        return this.upperBound;
    }

    public Type getType() {
        return this.type;
    }

    public Collection<String> getAllowedValues() {
        return this.allowedValues;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public static enum Type {
        STRING,
        STRING_LIST,
        NUMBER;

    }

    public static interface ParameterValues {
        public static final String YES = "yes";
        public static final String NO = "no";
        public static final String FORCE = "force";
        public static final String AUTO = "auto";
    }
}

