/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.file;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.transfer.file.FileChunk;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.task.TransferTaskProgressListener;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.transfer.utility.MD5;
import oracle.dbtools.util.Logger;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class FileInfo {
    private Path path;
    @JsonIgnore
    private Location sourceLocation;
    @JsonIgnore
    private Location targetLocation;
    private String targetDir;
    @JsonManagedReference
    private List<FileChunk> fileChunks;
    private static long TEN_MB;
    public static long CHUNK_SIZE;
    private MD5 md5;
    private boolean transferred;
    private long length;
    public static final char SUFFIX_SEPARATOR = '-';
    private static DecimalFormat df;
    private List<TransferTaskProgressListener> listeners = new ArrayList<TransferTaskProgressListener>();
    private TransferTaskProgressMonitor progressMonitor;

    private FileInfo() {
    }

    public FileInfo(Path path, Location sourceLocation, Location targetLocation, String targetDir) {
        Logger.info(this.getClass(), (String)(path.toString() + ", " + targetLocation));
        this.path = path;
        this.sourceLocation = sourceLocation;
        this.targetLocation = targetLocation;
        this.targetDir = targetDir;
        this.fileChunks = new ArrayList<FileChunk>();
        this.md5 = new MD5();
    }

    public Path getPath() {
        return this.path;
    }

    public Location getSourceLocation() {
        return this.sourceLocation;
    }

    public Location getTargetLocation() {
        return this.targetLocation;
    }

    public String getTargetDir() {
        return this.targetDir;
    }

    public long getLength() {
        if (0L == this.length) {
            this.length = this.path.toFile().length();
        }
        return this.length;
    }

    public List<FileChunk> getFileChunks() {
        if (this.fileChunks.isEmpty()) {
            this.initFileChunks(CHUNK_SIZE);
        }
        return this.fileChunks;
    }

    public void initFileChunks(long chunkSize) {
        long length = this.getLength();
        if (chunkSize < 0L) {
            chunkSize = length;
        }
        int chunkCount = (int)(length / chunkSize);
        if ((long)((int)length) % chunkSize != 0L) {
            ++chunkCount;
        }
        String prefix = this.path.getFileName().toString();
        for (int i = 0; i < chunkCount; ++i) {
            String name = prefix + this.getSuffix(i);
            long offset = chunkSize * (long)i;
            long size = 0L;
            size = i < chunkCount - 1 ? chunkSize : length - offset;
            this.fileChunks.add(new FileChunk(this, name, this.targetDir, offset, size));
        }
    }

    private String getSuffix(int i) {
        assert (i < 15625);
        char[] charSeq = new char[4];
        charSeq[0] = 45;
        charSeq[3] = (char)(i % 25 + 97);
        charSeq[2] = (char)((i /= 25) % 25 + 97);
        charSeq[1] = (char)((i /= 25) % 25 + 97);
        return new String(charSeq);
    }

    public String getMd5() {
        long start = System.nanoTime();
        if (this.md5.getValue() == null) {
            this.md5.calculate(this.getPath().toString());
        }
        double elapsed = (double)(System.nanoTime() - start) / 1.0E9;
        Logger.info(this.getClass(), (String)(df.format(elapsed) + " seconds"));
        return this.md5.getValue();
    }

    public boolean isTransferred() {
        return this.transferred;
    }

    public void setTransferred(boolean transferred) {
        this.transferred = transferred;
    }

    public static String csvHeader() {
        return "Name,Path,md5";
    }

    public String csvRow() {
        return '\"' + this.path.getFileName().toString() + "\",\"" + this.path.toString() + "\",\"" + this.getMd5() + '\"';
    }

    public String asJson() {
        StringBuilder sb = new StringBuilder();
        sb.append('{').append("\"name\":\"").append(this.path.getFileName().toString()).append('\"').append(',').append("\"path\":\"").append(this.path.toString()).append('\"').append(',').append("\"targetDir\":\"").append(this.targetDir).append('\"').append(',').append("\"transferred\":").append(this.transferred).append(',').append("\"md5\":\"").append(this.getMd5()).append('\"').append("\n,").append("\"fileChunks\":[\n");
        String prefix = "    ";
        for (FileChunk chunk : this.getFileChunks()) {
            String[] lines;
            for (String line : lines = chunk.asJson().split("\n")) {
                sb.append(prefix).append(line).append('\n');
            }
            prefix = "   ,";
        }
        sb.append("]}");
        return sb.toString();
    }

    public InputStream asInputStream() throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(this.path.toString()), 13);
    }

    public void addListener(TransferTaskProgressListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.addListener(listener);
        }
    }

    public void removeListener(TransferTaskProgressListener listener) {
        this.listeners.remove(listener);
        if (this.progressMonitor != null) {
            this.progressMonitor.removeListener(listener);
        }
    }

    public TransferTaskProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setProgressMonitor(TransferTaskProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        if (progressMonitor != null) {
            for (TransferTaskProgressListener listener : this.listeners) {
                progressMonitor.addListener(listener);
            }
        }
    }

    static {
        CHUNK_SIZE = TEN_MB = 0xA00000L;
        df = new DecimalFormat("#0.0000");
    }
}

