/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.location;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import oracle.dbtools.transfer.TransferMessages;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.task.TransferRestartRequest;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.transfer.utility.MD5;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.transfer.validation.DataFileScriptGenerator;
import oracle.dbtools.util.Logger;

public class JSchLocation
extends Location {
    private static final JSch jsch = new JSch();
    private String host;
    private int port;
    private String user;
    private String keyFile;
    private String userData;
    private int timeout = 15000;
    protected Session session;

    public Session getSession() {
        return this.session;
    }

    public JSchLocation(String host, int port, String user, String keyFile) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.keyFile = keyFile;
    }

    protected JSchLocation() {
    }

    protected void init(Session session) {
        this.host = session.getHost();
        this.port = session.getPort();
        this.user = session.getUserName();
    }

    @Override
    public void connect() throws IOException {
        try {
            this.connectImpl();
            Logger.fine(this.getClass(), (String)String.valueOf(this));
        }
        catch (Exception e) {
            String msg = "Unable to connect";
            Logger.severe(this.getClass(), (String)msg, (Throwable)e);
            throw new IOException(msg, e);
        }
    }

    protected void connectImpl() throws JSchException {
        if (null == this.session) {
            throw new UnsupportedOperationException("Password must be set before calling connect");
        }
        if (!this.session.isConnected()) {
            this.session.setConfig("StrictHostKeyChecking", "no");
            Hashtable<String, String> config = new Hashtable<String, String>();
            config.put("cipher.s2c", "aes128-ctr,aes192-ctr");
            config.put("cipher.c2s", "aes128-ctr,aes192-ctr");
            config.put("CheckCiphers", "");
            this.session.setConfig(config);
            this.session.setServerAliveInterval(this.timeout);
            this.session.setTimeout(this.timeout);
            this.session.connect(this.timeout);
            Logger.info(this.getClass(), (String)String.valueOf(this));
        }
    }

    public void setPassword(String password) throws IOException {
        try {
            if (null == this.session) {
                if (this.keyFile != null && !this.keyFile.isEmpty() && !jsch.getIdentityNames().contains(this.keyFile)) {
                    jsch.addIdentity(new File(this.keyFile).getAbsolutePath(), password);
                }
                this.session = jsch.getSession(this.user, this.host, this.port);
                if (null == this.keyFile || this.keyFile.isEmpty()) {
                    this.session.setPassword(password);
                    this.userData = password;
                }
                password = null;
                Logger.fine(this.getClass(), (String)("Session created: " + String.valueOf(this.session)));
            }
        }
        catch (Exception e) {
            String msg = "Unable to create session";
            Logger.severe(this.getClass(), (String)msg, (Throwable)e);
            throw new IOException(msg, e);
        }
    }

    @Override
    public JSchLocation clone() {
        JSchLocation clone = new JSchLocation(this.host, this.port, this.user, this.keyFile);
        try {
            clone.setPassword(this.userData);
        }
        catch (IOException e) {
            Logger.severe(this.getClass(), (String)"Unable to get new session");
            clone = null;
        }
        return clone;
    }

    @Override
    public void disconnect() {
        if (this.session != null) {
            this.session.disconnect();
            Logger.fine(this.getClass(), (String)String.valueOf(this));
        }
    }

    @Override
    public InputStream asInputStream(Path path, long position, long size) throws IOException {
        throw new UnsupportedOperationException("Target usage only! TODO: Support as source?");
    }

    @Override
    public MD5 getMd5(Path path, long offset, long size) {
        throw new UnsupportedOperationException("Target usage only! TODO: Support as source?");
    }

    public long copy(InputStream in, String target, CopyOption ... options) throws IOException {
        return this.copy(in, target, (TransferTaskProgressMonitor)null, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long copy(InputStream in, String target, TransferTaskProgressMonitor aMonitor, CopyOption ... options) throws IOException {
        Logger.fine(this.getClass(), (String)(in + ", " + target + ", " + Arrays.toString(options)));
        assert (this.session != null && this.session.isConnected());
        int sftpOption = SftpCopyOption.OVERWRITE.sftpCode();
        if (options != null && options.length > 0 && StandardCopyOption.REPLACE_EXISTING != options[0]) {
            sftpOption = ((SftpCopyOption)options[0]).sftpCode();
        }
        JSchProgressMonitor monitor = new JSchProgressMonitor(aMonitor);
        ChannelSftp sftp = null;
        try {
            Session session = this.session;
            synchronized (session) {
                assert (this.session != null && this.session.isConnected());
                sftp = (ChannelSftp)this.session.openChannel("sftp");
            }
            sftp.connect();
            long alreadySent = 0L;
            try {
                alreadySent = sftp.lstat(target).getSize();
                if (alreadySent > 0L) {
                    Logger.info(this.getClass(), (String)(target + " exists, skipping " + alreadySent + " bytes."));
                    in.skip(alreadySent);
                    sftpOption = SftpCopyOption.APPEND.sftpCode();
                }
            }
            catch (Exception e) {
                Logger.ignore(this.getClass(), (Throwable)e);
            }
            sftp.put(in, target, (SftpProgressMonitor)monitor, sftpOption);
        }
        catch (Exception e) {
            String msg = "Unable to copy to " + target;
            Logger.fine(this.getClass(), (String)msg, (Throwable)e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(msg, e);
        }
        finally {
            if (sftp != null && sftp.isConnected()) {
                sftp.disconnect();
            }
        }
        long written = monitor.written;
        Logger.fine(this.getClass(), (String)(written + " bytes written"));
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copyExecutable(ByteArrayInputStream input, String fqScriptName) throws IOException {
        Logger.fine(this.getClass(), (String)(input + ", " + fqScriptName));
        assert (this.session != null && this.session.isConnected());
        int sftpOption = SftpCopyOption.OVERWRITE.sftpCode();
        JSchProgressMonitor monitor = new JSchProgressMonitor(null);
        ChannelSftp sftp = null;
        try {
            Session session = this.session;
            synchronized (session) {
                assert (this.session != null && this.session.isConnected());
                sftp = (ChannelSftp)this.session.openChannel("sftp");
            }
            sftp.connect();
            sftp.put((InputStream)input, fqScriptName, (SftpProgressMonitor)monitor, sftpOption);
            sftp.chmod(510, fqScriptName);
        }
        catch (Exception e) {
            String msg = "Unable to copy to " + fqScriptName;
            Logger.fine(this.getClass(), (String)msg, (Throwable)e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(msg, e);
        }
        finally {
            if (sftp != null && sftp.isConnected()) {
                sftp.disconnect();
            }
        }
        long written = monitor.written;
        Logger.fine(this.getClass(), (String)(written + " bytes written"));
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifySize(String path, long size) {
        Logger.fine(this.getClass(), (String)(path + ", size=" + size));
        ChannelSftp sftp = null;
        boolean verified = false;
        try {
            sftp = (ChannelSftp)this.session.openChannel("sftp");
            sftp.connect();
            verified = size == sftp.stat(path).getSize();
        }
        catch (JSchException e) {
            Logger.severe(this.getClass(), (String)"Unable to open sftp channel.", (Throwable)e);
        }
        catch (Exception e) {
            Logger.severe(this.getClass(), (String)"Unable to stat size.", (Throwable)e);
        }
        finally {
            if (sftp != null && sftp.isConnected()) {
                sftp.disconnect();
            }
        }
        Logger.fine(this.getClass(), (String)String.valueOf(verified));
        return verified;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getTargetScript(List<FileInfo> fileInfos) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptOutput executeScript(String script, String scriptName, String targetDir) {
        assert (script != null);
        Logger.finer(this.getClass(), (String)("script = \"" + script + "\""));
        String myScript = script + "\nexit $?\n";
        ChannelShell shell = null;
        ScriptOutput scriptOutput = new ScriptOutput();
        try {
            Session session = this.session;
            synchronized (session) {
                assert (this.session != null && this.session.isConnected());
                shell = (ChannelShell)this.session.openChannel("shell");
            }
            ByteArrayInputStream input = new ByteArrayInputStream(myScript.getBytes());
            String fqScriptName = targetDir + scriptName;
            this.copyExecutable(input, fqScriptName);
            myScript = fqScriptName + "\nexit $?\n";
            input = new ByteArrayInputStream(myScript.getBytes());
            ByteArrayOutputStream stdout = new ByteArrayOutputStream(2048);
            ByteArrayOutputStream stderr = new ByteArrayOutputStream(2048);
            shell.setInputStream((InputStream)input);
            shell.setOutputStream((OutputStream)stdout);
            shell.setExtOutputStream((OutputStream)stderr);
            shell.connect(this.timeout);
            do {
                Thread.sleep(125L);
            } while (!shell.isEOF());
            scriptOutput.stdout = stdout.toString();
            scriptOutput.stderr = stderr.toString();
            scriptOutput.rc = shell.getExitStatus();
            shell.disconnect();
        }
        catch (JSchException e) {
            Logger.severe(this.getClass(), (String)"Unable to open shell channel.", (Throwable)e);
        }
        catch (Exception e) {
            Logger.severe(this.getClass(), (String)"Unable to execute script.", (Throwable)e);
        }
        return scriptOutput;
    }

    @Override
    public String toString() {
        return this.user + '@' + this.host + ' ' + super.toString();
    }

    @Override
    public boolean doPreProcessing(String transferId, List<FileInfo> fileInfos, String targetDir) throws IOException {
        String logFile = transferId + ".log";
        String scriptName = transferId + ".bash";
        ScriptOutput result = null;
        try {
            String executeScriptStr = DataFileScriptGenerator.generatePreTransferScript(fileInfos, targetDir, logFile);
            result = this.logExecuteScript("doPreprocessingOnTarget", executeScriptStr, scriptName, targetDir);
            DataFileScriptGenerator.evaluate(fileInfos, result);
            if (result.rc == 5) {
                executeScriptStr = DataFileScriptGenerator.generateChunkCheckScript(fileInfos, targetDir, logFile);
                result = this.logExecuteScript("doRequestedChunkChecks", executeScriptStr, scriptName, targetDir);
                DataFileScriptGenerator.evaluate(fileInfos, result);
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            String msg = TransferMessages.getString("TransferControlTask.doPreprocessingOnTarget.fail");
            if (result != null && result.rc == 6) {
                msg = TransferMessages.getString("TransferControlTask.doPreprocessingOnTarget.noSpace");
                throw new IOException(msg, t);
            }
            if (result == null || result.rc != 7) {
                Logger.warn(this.getClass(), (String)msg, (Throwable)t);
            }
            return false;
        }
    }

    @Override
    public void doPostProcessing(String transferId, List<FileInfo> fileInfos, String targetDir) throws IOException, TransferRestartRequest {
        String logFile = transferId + ".log";
        String scriptName = transferId + ".bash";
        String executeScriptStr = DataFileScriptGenerator.generatePostTransferScript(fileInfos, targetDir, logFile);
        ScriptOutput result = this.logExecuteScript("doPostprocessingOnTarget", executeScriptStr, scriptName, targetDir);
        DataFileScriptGenerator.evaluate(fileInfos, result);
    }

    public static enum SftpCopyOption implements CopyOption
    {
        OVERWRITE(0),
        RESUME(1),
        APPEND(2);

        private int code;

        private SftpCopyOption(int c) {
            this.code = c;
        }

        public int sftpCode() {
            return this.code;
        }
    }

    public static class JSchProgressMonitor
    implements SftpProgressMonitor {
        SftpProgressMonitor monitor;
        public volatile long written;
        public String target;
        public long max;
        public long start;
        public volatile long prevReportedByte;
        public volatile long prevReportedTime;
        private DecimalFormat df = new DecimalFormat("#00.0000");

        public JSchProgressMonitor(SftpProgressMonitor aMonitor) {
            this.monitor = aMonitor;
        }

        public void init(int op, String source, String target, long max) {
            Logger.fine(this.getClass(), (String)("sftp upload: " + target));
            this.target = target;
            if (this.start == 0L) {
                this.prevReportedTime = this.start = System.nanoTime();
            }
            if (this.monitor != null) {
                this.monitor.init(op, source, target, max);
            }
        }

        public boolean count(long count) {
            boolean ok = true;
            if (this.monitor != null) {
                ok = this.monitor.count(count);
            }
            this.written += count;
            if (this.max > 0L && this.written > this.max / 2L) assert (count >= 0L || count <= 0L);
            return ok;
        }

        public void end() {
            if (null == this.monitor) {
                this.logStatus();
            } else {
                this.monitor.end();
            }
        }

        private void logStatus() {
            long now = System.nanoTime();
            double elapsed = (double)(now - this.prevReportedTime) / 1.0E9;
            double size = ((double)this.written - (double)this.prevReportedByte) / 1048576.0;
            double rate = size / elapsed;
            double elapsedT = (double)(now - this.start) / 1.0E9;
            double sizeT = (double)this.written / 1048576.0;
            double rateT = sizeT / elapsedT;
            String format = "%s %s %s + %sMiB / %ss = %s MiB/s Total: %sMiB / %ss = %s MiB/s";
            String msg = String.format(format, Integer.toHexString(this.hashCode()), this.monitor == null ? "0" : Integer.toHexString(this.monitor.hashCode()), this.target, this.df.format(size), this.df.format(elapsed), this.df.format(rate), this.df.format(sizeT), this.df.format(elapsedT), this.df.format(rateT));
            Logger.info(this.getClass(), (String)msg);
            this.prevReportedTime = now;
            this.prevReportedByte = this.written;
        }
    }
}

