/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.jdevimpl.db.DBArgusUtil;
import oracle.jdevimpl.debugger.probe.DebugProbe;
import oracle.jdevimpl.debugger.probe.DebugProbeArb;
import oracle.jdevimpl.debugger.probe.DebugProbeClassInfo;
import oracle.jdevimpl.debugger.probe.DebugProbeMethodInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugMethodInfo;

final class DebugProbeLocation
implements DebugLocation {
    DebugProbe dp;
    int piLibunitType;
    String piOwner;
    String piName;
    int piLineNumber;
    String piEntryPointName;
    private DebugProbeClassInfo classInfo;
    private DebugProbeMethodInfo methodInfo;
    static final int LibunitType_cursor = 0;
    static final int LibunitType_procedure = 7;
    static final int LibunitType_function = 8;
    static final int LibunitType_package = 9;
    static final int LibunitType_package_body = 11;
    static final int LibunitType_trigger = 12;
    static final int LibunitType_Unknown = -1;
    static final int namespace_cursor = 0;
    static final int namespace_pkgspec_or_toplevel = 1;
    static final int namespace_pkg_body = 2;
    static final int namespace_trigger = 3;
    static final int namespace_none = 127;

    DebugProbeLocation(DebugProbe debugProbe, DebugProbeClassInfo debugProbeClassInfo, int n, String string) {
        this(debugProbe, debugProbeClassInfo.piLibunitType, debugProbeClassInfo.piOwner, debugProbeClassInfo.piName, n, string);
        this.classInfo = debugProbeClassInfo;
    }

    DebugProbeLocation(DebugProbe debugProbe, int n, String string, String string2, int n2, String string3) {
        this.dp = debugProbe;
        this.piLibunitType = n;
        this.piOwner = string;
        this.piName = string2;
        this.piLineNumber = n2;
        if (string3 == null && (n == 7 || n == 8)) {
            string3 = string2;
        }
        this.piEntryPointName = string3;
    }

    boolean isAnonymousBlock() {
        return this.piLibunitType == 0;
    }

    public DebugMethodInfo getMethod() {
        if (this.methodInfo == null && this.piEntryPointName != null) {
            this.getClassInfo();
            if (this.classInfo != null) {
                this.methodInfo = new DebugProbeMethodInfo(this.dp, this.classInfo, this.piEntryPointName);
            }
        }
        return this.methodInfo;
    }

    public DebugClassInfo getClassInfo() {
        if (this.classInfo == null) {
            this.classInfo = this.dp.getClassInfoForLocation(this);
        }
        return this.classInfo;
    }

    public String getPath() {
        return "";
    }

    public String getFilename() {
        if (this.piName != null) {
            return this.piName + ".pls";
        }
        return null;
    }

    public int getLine() {
        return this.piLineNumber;
    }

    public boolean isLineExact() {
        return true;
    }

    public int getBytecodeOffset() {
        return -1;
    }

    public boolean isBytecodeExact() {
        return false;
    }

    public long getAddress() {
        return 0L;
    }

    public String getDescription() {
        return null;
    }

    static DebugProbeLocation makeLocation(DebugProbe debugProbe, String string, String string2, int n) {
        DebugProbeLocation debugProbeLocation = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (arrayList.size() == 3 && arrayList.get(0).equals("$Oracle") && string2.endsWith(".pls")) {
            String string3 = (String)arrayList.get(1);
            int n2 = DebugProbeLocation.parseLibunitType(string3);
            String string4 = (String)arrayList.get(2);
            String string5 = string2.substring(0, string2.length() - 4);
            debugProbeLocation = new DebugProbeLocation(debugProbe, n2, string4, string5, n, null);
        }
        return debugProbeLocation;
    }

    static String formatLibunitType(int n) {
        switch (n) {
            default: {
                return DebugProbeArb.getString("UNKNOWN_LIBUNITTYPE");
            }
            case 0: {
                return DBArgusUtil.getArgusNameForType("BLOCK");
            }
            case 7: {
                return DBArgusUtil.getArgusNameForType("PROCEDURE");
            }
            case 8: {
                return DBArgusUtil.getArgusNameForType("FUNCTION");
            }
            case 9: {
                return DBArgusUtil.getArgusNameForType("PACKAGE");
            }
            case 11: {
                return DBArgusUtil.getArgusNameForType("PACKAGE", "Body");
            }
            case 12: 
        }
        return DBArgusUtil.getArgusNameForType("TRIGGER");
    }

    static int parseLibunitType(String string) {
        if (string.equals(DBArgusUtil.getArgusNameForType("BLOCK"))) {
            return 0;
        }
        if (string.equals(DBArgusUtil.getArgusNameForType("PROCEDURE"))) {
            return 7;
        }
        if (string.equals(DBArgusUtil.getArgusNameForType("FUNCTION"))) {
            return 8;
        }
        if (string.equals(DBArgusUtil.getArgusNameForType("PACKAGE"))) {
            return 9;
        }
        if (string.equals(DBArgusUtil.getArgusNameForType("PACKAGE", "Body"))) {
            return 11;
        }
        if (string.equals(DBArgusUtil.getArgusNameForType("TRIGGER"))) {
            return 12;
        }
        return -1;
    }

    static int getNameSpaceFromLibunitType(int n) {
        switch (n) {
            default: {
                return 127;
            }
            case 0: {
                return 0;
            }
            case 7: 
            case 8: 
            case 9: {
                return 1;
            }
            case 11: {
                return 2;
            }
            case 12: 
        }
        return 3;
    }
}

