/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.probe;

import java.sql.CallableStatement;
import oracle.jdevimpl.debugger.probe.DebugProbe;

final class DebugProbeRuntimeInfo {
    DebugProbe dp;
    private boolean oerSupported;
    private String info_request;
    int reason;
    int breakpoint;
    int oer;
    int stackDepth;
    int lineNumber;
    static final int reason_none = 0;
    static final int reason_interpreter_starting = 2;
    static final int reason_breakpoint = 3;
    static final int reason_enter = 6;
    static final int reason_return = 7;
    static final int reason_finish = 8;
    static final int reason_line = 9;
    static final int reason_interrupt = 10;
    static final int reason_exception = 11;
    static final int reason_exit = 15;
    static final int reason_handler = 16;
    static final int reason_timeout = 17;
    static final int reason_instantiate = 20;
    static final int reason_abort = 21;
    static final int reason_knl_exit = 25;
    static final int reason_oer_breakpoint = 26;

    DebugProbeRuntimeInfo(DebugProbe debugProbe) {
        this.dp = debugProbe;
        this.oerSupported = debugProbe.checkVersion(2, 4);
    }

    String info_request() {
        if (this.info_request == null) {
            this.info_request = "DBMS_DEBUG.info_getStackDepth + DBMS_DEBUG.info_getBreakpoint";
            if (this.oerSupported) {
                this.info_request = this.info_request + " + DBMS_DEBUG.info_getOerInfo";
            }
        }
        return this.info_request;
    }

    String code(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ? := " + string + ".Reason;\n");
        stringBuffer.append("  ? := " + string + ".Breakpoint;\n");
        if (this.oerSupported) {
            stringBuffer.append("  ? := " + string + ".oer;\n");
        }
        stringBuffer.append("  ? := " + string + ".StackDepth;\n");
        stringBuffer.append("  ? := " + string + ".Line#;\n");
        return stringBuffer.toString();
    }

    int registerParameters(CallableStatement callableStatement, int n) throws Exception {
        callableStatement.registerOutParameter(n++, 4);
        callableStatement.registerOutParameter(n++, 4);
        if (this.oerSupported) {
            callableStatement.registerOutParameter(n++, 4);
        }
        callableStatement.registerOutParameter(n++, 4);
        callableStatement.registerOutParameter(n++, 4);
        return n;
    }

    int getParameters(CallableStatement callableStatement, int n) throws Exception {
        this.reason = callableStatement.getInt(n++);
        this.breakpoint = callableStatement.getInt(n++);
        if (this.oerSupported) {
            this.oer = callableStatement.getInt(n++);
        }
        this.stackDepth = callableStatement.getInt(n++);
        this.lineNumber = callableStatement.getInt(n++);
        return n;
    }

    String dump(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("  reason:     ");
        stringBuffer.append(this.getReason());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("  breakpoint: ");
        stringBuffer.append(this.breakpoint);
        stringBuffer.append("\n");
        if (this.oerSupported) {
            stringBuffer.append(string);
        }
        stringBuffer.append("  oer:        ");
        stringBuffer.append(this.oer);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("  stackDepth: ");
        stringBuffer.append(this.stackDepth);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("  lineNumber: ");
        stringBuffer.append(this.lineNumber);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String getReason() {
        switch (this.reason) {
            default: {
                return Integer.toString(this.reason);
            }
            case 0: {
                return "reason_none";
            }
            case 2: {
                return "reason_interpreter_starting";
            }
            case 3: {
                return "reason_breakpoint";
            }
            case 6: {
                return "reason_enter";
            }
            case 7: {
                return "reason_return";
            }
            case 8: {
                return "reason_finish";
            }
            case 9: {
                return "reason_line";
            }
            case 10: {
                return "reason_interrupt";
            }
            case 11: {
                return "reason_exception";
            }
            case 15: {
                return "reason_exit";
            }
            case 16: {
                return "reason_handler";
            }
            case 17: {
                return "reason_timeout";
            }
            case 20: {
                return "reason_instantiate";
            }
            case 21: {
                return "reason_abort";
            }
            case 25: 
        }
        return "reason_knl_exit";
    }

    boolean isOerSupported() {
        return this.oerSupported;
    }

    int getSQLCode() {
        if (this.oer == 1403) {
            return 100;
        }
        return -this.oer;
    }
}

