/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.codec;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;

public class GIFEncoder {
    private static final boolean DEBUG = false;
    private OutputStream output = null;
    private final char[] MAGIC_ID = new char[]{'G', 'I', 'F', '8', '7', 'a'};
    private final int GIF_IMG_CODE = 44;
    private final int GIF_END_CODE = 59;
    private int width = 0;
    private int height = 0;
    private int initialCodeSize = 0;
    private int clearCode = 0;
    private int endCode = 0;
    private int codeSize = 0;
    private int numCodes = 0;
    private byte[] lzwByteDict = null;
    private int[] lzwParentDict = null;
    private int[] lzwHash = null;
    private final int NO_PIXEL = -1;
    private final int HASH_FREE = 65535;
    private final int HASH_ROOT = 65535;
    private final int HASH_SIZE = 9973;
    private final int HASH_STEP = 2039;
    private final int MAX_BITS = 12;
    private final int MAX_STR = 4096;
    private byte[] bitStore = null;
    private int bitStoreOff = 0;
    private int bitOffset = 0;
    private int pixrX = 0;
    private int pixrY = 0;
    private int pixrMinX = 0;
    private int pixrMinY = 0;
    private Raster pixrSrc = null;
    private final int[] maxCode = new int[]{0, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4095};
    private final int[] bitOffsetMask = new int[]{0, 1, 3, 7, 15, 31, 63, 127};

    public GIFEncoder(OutputStream output) {
        this.output = output;
    }

    public void encode(RenderedImage im) throws IOException {
        this.width = im.getWidth();
        this.height = im.getHeight();
        SampleModel sm = im.getSampleModel();
        ColorModel cm = im.getColorModel();
        int bitsPerPixel = 0;
        int paletteEntries = 0;
        int gifPaletteEntries = 0;
        byte[] r = null;
        byte[] g = null;
        byte[] b = null;
        if (cm instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)cm;
            paletteEntries = icm.getMapSize();
            while (paletteEntries > 1 << bitsPerPixel) {
                ++bitsPerPixel;
            }
            gifPaletteEntries = (int)Math.pow(2.0, bitsPerPixel);
            if (gifPaletteEntries > 256) {
                throw new RuntimeException("Palette too large for GIF encoding");
            }
            r = new byte[gifPaletteEntries];
            g = new byte[gifPaletteEntries];
            b = new byte[gifPaletteEntries];
            icm.getReds(r);
            icm.getGreens(g);
            icm.getBlues(b);
        } else if (sm.getNumBands() == 1) {
            bitsPerPixel = sm.getSampleSize()[0];
            gifPaletteEntries = paletteEntries = (int)Math.pow(2.0, bitsPerPixel);
            r = new byte[gifPaletteEntries];
            g = new byte[gifPaletteEntries];
            b = new byte[gifPaletteEntries];
            int i = 0;
            while (i < gifPaletteEntries) {
                r[i] = (byte)i;
                g[i] = (byte)i;
                b[i] = (byte)i;
                ++i;
            }
        } else {
            throw new RuntimeException("Non-encodable rendered image");
        }
        this.writeHeader(bitsPerPixel);
        this.writeColorTable(r, g, b);
        this.writeLocalHeader();
        this.initialCodeSize = bitsPerPixel < 2 ? 2 : bitsPerPixel;
        this.encodeRaster(im);
        this.output.write(59);
    }

    private void writeHeader(int bpp) throws IOException {
        int i = 0;
        while (i < this.MAGIC_ID.length) {
            this.output.write((byte)this.MAGIC_ID[i]);
            ++i;
        }
        this.writeUB2(this.width);
        this.writeUB2(this.height);
        int bitfield = 0x80 | bpp - 1 << 4 | bpp - 1;
        this.output.write(bitfield);
        this.output.write(0);
        this.output.write(0);
    }

    private void writeColorTable(byte[] r, byte[] g, byte[] b) throws IOException {
        int i = 0;
        while (i < r.length) {
            this.output.write(r[i]);
            this.output.write(g[i]);
            this.output.write(b[i]);
            ++i;
        }
    }

    private void writeLocalHeader() throws IOException {
        this.output.write(44);
        this.writeUB2(0);
        this.writeUB2(0);
        this.writeUB2(this.width);
        this.writeUB2(this.height);
        int bitfield = 0;
        this.output.write(bitfield);
    }

    private void encodeRaster(RenderedImage im) throws IOException {
        this.initLZWEncoder();
        this.output.write(this.initialCodeSize);
        this.initBitStreamer();
        this.initPixelReader(im);
        this.writeCode(this.clearCode);
        int prefix = 65535;
        int pixelVal = 0;
        while ((pixelVal = this.getNextPixelVal()) != -1) {
            int currentCode = this.searchDictionary((byte)pixelVal, prefix);
            if (currentCode != 65535) {
                prefix = currentCode;
                continue;
            }
            this.writeCode(prefix);
            if (this.addCode((byte)pixelVal, prefix) == this.maxCode[this.codeSize]) {
                if (this.codeSize == 12) {
                    this.writeCode(this.clearCode);
                    this.initLZWDictionary();
                } else {
                    ++this.codeSize;
                }
            }
            prefix = pixelVal;
        }
        if (prefix != 65535) {
            this.writeCode(prefix);
        }
        this.writeCode(this.endCode);
        this.flushBitStreamer();
    }

    private void initLZWEncoder() {
        this.clearCode = 1 << this.initialCodeSize;
        this.endCode = this.clearCode + 1;
        this.lzwByteDict = new byte[4096];
        this.lzwParentDict = new int[4096];
        this.lzwHash = new int[9973];
        this.initLZWDictionary();
    }

    private void initLZWDictionary() {
        this.numCodes = 0;
        this.codeSize = this.initialCodeSize + 1;
        int j = 0;
        while (j < this.lzwHash.length) {
            this.lzwHash[j] = 65535;
            ++j;
        }
        int i = 0;
        while (i <= this.endCode) {
            this.addCode((byte)i, 65535);
            ++i;
        }
    }

    private void initBitStreamer() {
        this.bitStore = new byte[257];
        this.bitStoreOff = 0;
        this.bitOffset = 0;
    }

    private void initPixelReader(RenderedImage im) {
        this.pixrMinX = im.getMinX();
        this.pixrMinY = im.getMinY();
        this.pixrX = this.pixrMinX + this.width;
        this.pixrY = this.pixrMinY - 1;
        this.pixrSrc = im.getData(new Rectangle(this.pixrMinX, this.pixrMinY, this.width, this.height));
    }

    private int getNextPixelVal() {
        if (++this.pixrX >= this.pixrMinX + this.width) {
            this.pixrX = this.pixrMinX;
            ++this.pixrY;
            if (this.pixrY >= this.pixrMinY + this.height) {
                return -1;
            }
        }
        return this.pixrSrc.getSample(this.pixrX, this.pixrY, 0);
    }

    private void writeCode(int code) throws IOException {
        int scode = code << this.bitOffset | this.bitStore[this.bitStoreOff] & this.bitOffsetMask[this.bitOffset];
        int bits = this.codeSize + this.bitOffset;
        this.bitOffset = bits % 8;
        while (bits > 0) {
            this.bitStore[this.bitStoreOff] = (byte)(0xFF & scode);
            scode >>= 8;
            if ((bits -= 8) < 0) continue;
            ++this.bitStoreOff;
        }
        if (this.bitStoreOff > 254) {
            this.output.write(255);
            this.output.write(this.bitStore, 0, 255);
            this.bitStoreOff -= 255;
            bits = this.bitStoreOff * 8 + this.bitOffset;
            if (bits > 0) {
                this.bitStore[0] = this.bitStore[255];
            }
            if (bits > 8) {
                this.bitStore[1] = this.bitStore[256];
            }
        }
    }

    private void flushBitStreamer() throws IOException {
        if (this.bitOffset != 0) {
            ++this.bitStoreOff;
        }
        if (this.bitStoreOff != 0) {
            this.output.write(this.bitStoreOff);
            this.output.write(this.bitStore, 0, this.bitStoreOff);
        }
        this.output.write(0);
    }

    private int addCode(byte k, int prefix) {
        if (this.numCodes >= 4096) {
            return 65535;
        }
        int hashIdx = this.hash(k, prefix);
        while (this.lzwHash[hashIdx] != 65535) {
            hashIdx = (hashIdx + 2039) % 9973;
        }
        this.lzwHash[hashIdx] = this.numCodes;
        this.lzwByteDict[this.numCodes] = k;
        this.lzwParentDict[this.numCodes] = prefix;
        return this.numCodes++;
    }

    private int searchDictionary(byte k, int prefix) {
        int hashIdx = this.hash(k, prefix);
        int nextIdx = 0;
        while ((nextIdx = this.lzwHash[hashIdx]) != 65535) {
            if (this.lzwParentDict[nextIdx] == prefix && this.lzwByteDict[nextIdx] == k) {
                return nextIdx;
            }
            hashIdx = (hashIdx + 2039) % 9973;
        }
        return 65535;
    }

    private int hash(byte k, int prefix) {
        return ((k << 8 ^ prefix) & 0xFFFF) % 9973;
    }

    private void writeUB2(int data) throws IOException {
        this.output.write(data & 0xFF);
        this.output.write((data & 0xFF00) >> 8);
    }
}

