/*
 * Decompiled with CFR 0.152.
 */
package oracle.charts.radarchart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Vector;
import oracle.charts.Chart;
import oracle.charts.internal.Errorfcn;
import oracle.charts.internal.MsgUtil;
import oracle.charts.radarchart.RadarAxisDesc;
import oracle.charts.radarchart.RadarGridDesc;
import oracle.charts.radarchart.RadarSeriesDesc;
import oracle.charts.radarchart.RadarStyleDesc;
import oracle.charts.types.ChartException;
import oracle.charts.types.ImageMapAreaDesc;

public class RadarChart
extends Chart {
    BasicStroke DefaultStroke = new BasicStroke(1.0f, 0, 2);
    BasicStroke DashedStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f, 1.0f}, 0.0f);
    int LegendHeight = 0;
    int LegendWidth = 0;
    Point Center;
    private int AvailableWidth = 0;
    private int AvailableHeight = 0;
    int Diameter = 0;
    double Radius = 0.0;
    double Radius2 = 0.0;
    double AngleStep = 0.0;
    int gridLines = 5;
    private double seriesMaxValue = 0.0;
    private boolean calculateMaxValue = true;
    boolean DrawBufferCalled = false;
    RenderingHints RHOriginal = null;
    RenderingHints RHLine = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    private boolean fontMetricsGot = false;
    private Font font = new Font("sansserif", 1, 12);
    private FontMetrics fontmet;
    private boolean fontMetricsGridGot = false;
    private FontMetrics fontmetGrid;
    boolean SizeChanged = false;
    int displayHeight = super.getHeight();
    int displayWidth = super.getWidth();
    boolean drawBackgroundRect = true;
    BufferedImage BI = null;
    Vector chartSeriesDesc = new Vector();
    RadarAxisDesc AxisD = null;
    RadarGridDesc GridD = new RadarGridDesc();
    RadarStyleDesc StyleD = new RadarStyleDesc();
    boolean genImageMapCoords = false;
    public int[][] imageMapCoordsAxisLabels;
    public int imageMapShapeAxisLabels = 0;
    private ImageMapAreaDesc ImageMapTypeAxis = new ImageMapAreaDesc();
    private ImageMapAreaDesc ImageMapTypeAxisLabels = new ImageMapAreaDesc();
    public static final int IMAGE_MAP_TYPE_AXIS_LABELS = 1;

    public RadarChart() {
        this.L2.setMaximumSize(this.getWidth(), this.getHeight());
        this.L2.setBorders(this.getBorderLeft(), this.getBorderRight(), this.getBorderTop(), this.getBorderBottom());
    }

    private void addLegend(Graphics2D g2) {
        if (!this.StyleD.getLegendEnable()) {
            return;
        }
        this.L2.clearLegend();
        this.L2.resetLegendReduce();
        int s = 0;
        while (s < this.chartSeriesDesc.size()) {
            RadarSeriesInternal rsi = (RadarSeriesInternal)this.chartSeriesDesc.elementAt(s);
            RadarSeriesDesc seriesD = rsi.seriesD;
            String seriesName = rsi.seriesD.getSeriesName();
            if (seriesName != "") {
                this.L2.setAddLegendItem(seriesName, rsi.seriesD.getFillColor());
            }
            ++s;
        }
        this.L2.setLegendColumns(this.chartSeriesDesc.size());
        this.LegendHeight = this.L2.getLegendHeight();
        this.LegendWidth = this.L2.getLegendWidth();
        this.L2.setLegendLocation(0, this.getHeight() - this.LegendHeight);
    }

    int getHeightOfTopAxisLabel() {
        int height = 0;
        String[] axisLabels = this.AxisD.getAxisLabels();
        if (axisLabels == null) {
            return 0;
        }
        if (axisLabels[0] != null && axisLabels[0] != "") {
            height = this.fontmet.getHeight();
        }
        return height;
    }

    int getHeightOfBottomAxisLabel() {
        int height = 0;
        String[] axisLabels = this.AxisD.getAxisLabels();
        if (axisLabels == null) {
            return 0;
        }
        if (axisLabels.length % 2 == 1) {
            return 0;
        }
        int index = axisLabels.length / 2;
        if (axisLabels[index] != null && axisLabels[index] != "") {
            height = this.fontmet.getHeight();
        }
        return height;
    }

    private void calcCenterPoint() {
        int topLabelHeight = this.getHeightOfTopAxisLabel();
        int cX = super.getBorderLeft() + this.AvailableWidth / 2;
        int cY = super.getBorderTop() + topLabelHeight + this.AvailableHeight / 2;
        switch (this.AxisD.getAxisLabels().length) {
            case 3: {
                if (this.PointUpOddAxis()) {
                    cY = super.getBorderTop() + topLabelHeight + 2 * this.AvailableHeight / 3;
                    break;
                }
                cY = super.getBorderTop() + topLabelHeight + this.AvailableHeight / 3;
                break;
            }
            case 5: {
                if (this.PointUpOddAxis()) {
                    cY = super.getBorderTop() + topLabelHeight + (int)Math.round(0.55 * (double)this.AvailableHeight);
                    break;
                }
                cY = super.getBorderTop() + topLabelHeight + (int)Math.round(0.45 * (double)this.AvailableHeight);
                break;
            }
            case 7: {
                if (this.PointUpOddAxis()) {
                    cY = super.getBorderTop() + topLabelHeight + (int)Math.round(0.53 * (double)this.AvailableHeight);
                    break;
                }
                cY = super.getBorderTop() + topLabelHeight + (int)Math.round(0.47 * (double)this.AvailableHeight);
                break;
            }
            case 9: {
                cY = this.PointUpOddAxis() ? super.getBorderTop() + topLabelHeight + (int)Math.round(0.52 * (double)this.AvailableHeight) : super.getBorderTop() + topLabelHeight + (int)Math.round(0.48 * (double)this.AvailableHeight);
            }
        }
        this.Center = new Point(cX, cY);
    }

    private void setAvailableWidth() {
        this.AvailableWidth = this.getWidth() - super.getBorderLeft() - super.getBorderRight();
    }

    private void setAvailableHeight() {
        this.AvailableHeight = this.getHeight() - super.getBorderTop() - super.getBorderBottom() - this.LegendHeight - this.getHeightOfBottomAxisLabel() - this.getHeightOfTopAxisLabel();
    }

    private void setDiameter() {
        this.Diameter = Math.min(this.AvailableWidth, this.AvailableHeight);
        switch (this.AxisD.getAxisLabels().length) {
            case 3: {
                this.Radius = ((double)this.Diameter / 2.0 + (double)this.Diameter * Math.sin(Math.PI / (double)this.AxisD.getAxisLabels().length)) / 2.0;
                this.Radius2 = this.Radius / 2.0;
                return;
            }
            case 4: {
                if (this.PointUpEvenAxis()) {
                    this.Radius = (double)this.Diameter / 2.0;
                    return;
                }
                this.Radius = (double)this.Diameter * Math.sin(Math.PI / (double)this.AxisD.getAxisLabels().length);
                this.Radius2 = (double)this.Diameter / 2.0;
                return;
            }
            case 5: {
                this.Radius = ((double)this.Diameter / 2.0 + (double)this.Diameter * Math.sin(Math.PI / (double)this.AxisD.getAxisLabels().length)) / 2.0;
                break;
            }
            case 6: {
                if (this.PointUpEvenAxis()) {
                    this.Radius = (double)this.Diameter / 2.0;
                    break;
                }
                this.Radius = (double)this.Diameter / 2.0 * 1.2;
                break;
            }
            case 7: {
                this.Radius = (double)this.Diameter / 2.0 * 1.06;
                break;
            }
            case 8: {
                if (this.PointUpEvenAxis()) {
                    this.Radius = (double)this.Diameter / 2.0;
                    break;
                }
                this.Radius = (double)this.Diameter / 2.0 * 1.1;
                break;
            }
            case 9: {
                this.Radius = (double)this.Diameter / 2.0 * 1.03;
                break;
            }
            default: {
                this.Radius = (double)this.Diameter / 2.0;
            }
        }
        double theta = Math.PI * 2 / (double)this.AxisD.getAxisLabels().length * 0.5;
        double z = Math.sqrt(1.0 - theta * theta);
        this.Radius2 = z * this.Radius;
    }

    private void initDrawBuffer() {
        this.setAvailableHeight();
        this.setAvailableWidth();
        this.calcCenterPoint();
        this.setDiameter();
    }

    private void setAngleStep() {
        this.AngleStep = Math.PI * 2 / (double)this.AxisD.getAxisLabels().length;
    }

    public void drawBuffer(Graphics2D g2) throws ChartException {
        boolean debug = false;
        if (debug) {
            System.out.println("drawBuffer a.");
        }
        if (this.AxisD == null) {
            return;
        }
        if (this.AxisD.getAxisLabels() == null) {
            return;
        }
        if (this.AxisD.getAxisLabels().length < 3) {
            return;
        }
        String fcn = "drawBuffer()";
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.setGraphicsBuffer(g2);
            g2 = this.svgChartGraphics;
        }
        this.checkDrawBufferErrors(g2, fcn);
        if (debug) {
            System.out.println("drawBuffer b.");
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.clearSVG();
        }
        this.DrawBufferCalled = false;
        this.getFMetrics(g2);
        RenderingHints RHOriginal = null;
        if (this.isSetRenderingHintsChart()) {
            g2.setRenderingHints(super.getRenderingHintsChart());
        } else {
            RHOriginal = g2.getRenderingHints();
            this.setRenderingHints(g2);
        }
        this.drawBackground(g2);
        super.getTitle().setFontMetrics(g2);
        super.getSubtitle().setFontMetrics(g2);
        super.getFootnote().setFontMetrics(g2);
        if (debug) {
            System.out.println("drawBuffer c.");
        }
        int tempBordertop = 0;
        if (super.getTitle().getText() != "") {
            tempBordertop += super.getTitle().getHeight();
            super.getTitle().setLocation(0, 0);
            super.getTitle().setWidth(this.displayWidth);
        }
        if (super.getSubtitle().getText() != "") {
            tempBordertop += super.getSubtitle().getHeight();
            if (super.getTitle().getText() != "") {
                super.getSubtitle().setLocation(0, super.getTitle().getHeight());
            } else {
                super.getSubtitle().setLocation(0, 0);
            }
            super.getSubtitle().setWidth(this.displayWidth);
        }
        if (super.getTitle().getText() != "" && super.getSubtitle().getText() == "") {
            int whiteSp = super.getTitle().getHeight() / 6;
            tempBordertop += whiteSp;
        }
        if (tempBordertop != 0) {
            this.setBorderTopInternal(tempBordertop);
        }
        if (super.getFootnote().getText() != "") {
            int footnoteHeight = super.getFootnote().getHeight();
            int footnoteYOffset = (int)Math.round(1.5 * (double)footnoteHeight);
            super.getFootnote().setLocation(0, this.displayHeight - footnoteYOffset);
            super.getFootnote().setWidth(this.displayWidth);
            int padding = 10;
            super.setBorderBottomInternal(footnoteHeight + padding);
        }
        g2.setFont(this.font);
        this.getFMetrics(g2);
        this.addLegend(g2);
        this.initDrawBuffer();
        this.drawRadarAxis(g2);
        this.drawRadarGrid(g2);
        this.drawSeries(g2);
        this.drawRadarGridLabels(g2);
        this.L2.drawLegendBuffer(g2, this.svgChartGraphics, true);
        if (debug) {
            System.out.println("drawBuffer z.");
        }
    }

    private boolean isWithin(double variable, double testAgainst) {
        return variable < testAgainst + 1.0 && variable > testAgainst - 1.0;
    }

    private void drawRadarAxis(Graphics2D g2) {
        String[] axisLabels = this.AxisD.getAxisLabels();
        if (this.genImageMapCoords) {
            this.imageMapCoordsAxisLabels = new int[axisLabels.length][];
        }
        double angle = this.initAngle();
        int labelHeight = this.fontmet.getHeight();
        int i = 0;
        while (i < axisLabels.length) {
            block26: {
                int y;
                int x;
                int width;
                block28: {
                    int labelYOffset;
                    double labelYOffsetFactor;
                    double degrees;
                    block29: {
                        block27: {
                            double xcirc = Math.cos(angle) * this.Radius + (double)this.Center.x;
                            double ycirc = Math.sin(angle) * this.Radius + (double)this.Center.y;
                            g2.setColor(this.AxisD.getAxisColor());
                            g2.setStroke(this.DefaultStroke);
                            g2.drawLine(this.Center.x, this.Center.y, (int)Math.round(xcirc), (int)Math.round(ycirc));
                            if (axisLabels == null || axisLabels[i] == null || axisLabels[i] == "") break block26;
                            width = this.fontmet.stringWidth(axisLabels[i]);
                            x = (int)(Math.round(xcirc) - (long)(width / 2));
                            y = (int)Math.round(ycirc);
                            degrees = Math.toDegrees(angle);
                            if (!(degrees < -89.0) || !(degrees > -91.0)) break block27;
                            labelYOffsetFactor = (double)labelHeight * 0.4;
                            labelYOffset = (int)Math.round(labelYOffsetFactor);
                            y -= labelYOffset;
                            break block28;
                        }
                        if (!(Math.sin(angle) > 0.0)) break block29;
                        labelYOffsetFactor = (double)labelHeight * 1.0;
                        labelYOffset = (int)Math.round(labelYOffsetFactor * Math.sin(angle));
                        y += labelYOffset;
                        switch (this.AxisD.getAxisLabels().length) {
                            case 3: {
                                y = (int)((double)y + (double)labelHeight * 0.4);
                                break;
                            }
                            case 4: {
                                if (!this.isInner()) break;
                                y = (int)((double)y + (double)labelHeight * 0.4);
                                break;
                            }
                            case 5: {
                                if (this.isWithin(degrees, 126.0) || this.isWithin(degrees, 54.0)) {
                                    y = (int)((double)y + (double)labelHeight * 0.2);
                                    break;
                                }
                                break block28;
                            }
                            case 6: 
                            case 8: {
                                if (!this.isInner()) break;
                                y = (int)((double)y + (double)labelHeight * 0.1);
                                break;
                            }
                            case 7: {
                                if (this.isWithin(degrees, 115.7) || this.isWithin(degrees, 64.2)) {
                                    y = (int)((double)y + (double)labelHeight * 0.2);
                                    break;
                                }
                                break block28;
                            }
                            case 9: {
                                if (this.isWithin(degrees, 110.0) || this.isWithin(degrees, 70.0)) {
                                    y = (int)((double)y + (double)labelHeight * 0.2);
                                }
                                break block28;
                            }
                        }
                        break block28;
                    }
                    if (Math.sin(angle) < 0.0) {
                        labelYOffsetFactor = (double)labelHeight * 0.2;
                        labelYOffset = (int)Math.round(labelYOffsetFactor);
                        y -= labelYOffset;
                        switch (this.AxisD.getAxisLabels().length) {
                            case 3: {
                                y = (int)((double)y - (double)labelHeight * 0.3);
                                break;
                            }
                            case 4: {
                                if (!this.isInner()) break;
                                y = (int)((double)y - (double)labelHeight * 0.3);
                                break;
                            }
                            case 5: {
                                if (!this.isWithin(degrees, -126.0) && !this.isWithin(degrees, -54.0)) break;
                                y = (int)((double)y - (double)labelHeight * 0.2);
                                break;
                            }
                            case 6: 
                            case 8: {
                                if (!this.isInner()) break;
                                y = (int)((double)y - (double)labelHeight * 0.2);
                                break;
                            }
                            case 7: {
                                if (!this.isWithin(degrees, -115.7) && !this.isWithin(degrees, -64.2)) break;
                                y = (int)((double)y - (double)labelHeight * 0.2);
                                break;
                            }
                            case 9: {
                                if (!this.isWithin(degrees, -110.0) && !this.isWithin(degrees, -70.0)) break;
                                y = (int)((double)y - (double)labelHeight * 0.2);
                            }
                        }
                    }
                }
                double cosThresh = 0.3;
                if (this.AxisD.getAxisLabels().length == 3) {
                    if (!(Math.cos(angle) > cosThresh) && Math.cos(angle) < -cosThresh) {
                        // empty if block
                    }
                } else if ((this.AxisD.getAxisLabels().length != 4 || !this.isInner()) && Math.abs(Math.cos(angle)) > cosThresh) {
                    x += (int)((double)width / 2.0 * Math.cos(angle));
                }
                g2.setColor(this.AxisD.getLabelColor());
                g2.drawString(axisLabels[i], x, y);
                this.copyImageMapRect(i, x, y - labelHeight, x + this.fontmet.stringWidth(axisLabels[i]), y);
            }
            angle += this.AngleStep;
            ++i;
        }
    }

    private void copyImageMapRect(int index, int xCorner0, int yCorner0, int xCorner1, int yCorner1) {
        if (!this.genImageMapCoords) {
            return;
        }
        this.imageMapShapeAxisLabels = 0;
        this.imageMapCoordsAxisLabels[index] = new int[4];
        this.imageMapCoordsAxisLabels[index][0] = xCorner0;
        this.imageMapCoordsAxisLabels[index][1] = yCorner0;
        this.imageMapCoordsAxisLabels[index][2] = xCorner1;
        this.imageMapCoordsAxisLabels[index][3] = yCorner1;
    }

    private void drawRadarGrid(Graphics2D g2) {
        double angle = this.initAngle();
        String[] axisLabels = this.AxisD.getAxisLabels();
        g2.setStroke(this.DashedStroke);
        g2.setColor(this.GridD.getGridColor());
        boolean ringColor = false;
        if (this.GridD.getRingColors() != null) {
            ringColor = true;
        }
        double radStep = this.Radius / (double)this.gridLines;
        int ringNumber = this.gridLines - 1;
        double innerRadius = this.Radius;
        while (innerRadius > 1.0) {
            angle = this.initAngle();
            double xcircPrev = Math.cos(angle) * innerRadius + (double)this.Center.x;
            double ycircPrev = Math.sin(angle) * innerRadius + (double)this.Center.y;
            if (ringColor) {
                int[] x = new int[axisLabels.length + 1];
                int[] y = new int[axisLabels.length + 1];
                int i = 0;
                while (i < axisLabels.length) {
                    double xcirc = Math.cos(angle += this.AngleStep) * innerRadius + (double)this.Center.x;
                    double ycirc = Math.sin(angle) * innerRadius + (double)this.Center.y;
                    x[i] = (int)Math.round(xcirc);
                    y[i] = (int)Math.round(ycirc);
                    ++i;
                }
                x[axisLabels.length] = x[0];
                y[axisLabels.length] = y[0];
                if (this.GridD.getRingColors().length > ringNumber) {
                    g2.setColor(this.GridD.getRingColors()[ringNumber]);
                }
                g2.fillPolygon(x, y, axisLabels.length + 1);
            }
            --ringNumber;
            innerRadius -= radStep;
        }
        double innerRadius2 = 0.0;
        int k = 0;
        while (k < this.gridLines) {
            g2.setColor(this.GridD.getGridColor());
            angle = this.initAngle();
            double xcircPrev = Math.cos(angle) * (innerRadius2 += radStep) + (double)this.Center.x;
            double ycircPrev = Math.sin(angle) * innerRadius2 + (double)this.Center.y;
            int i = 0;
            while (i < axisLabels.length) {
                double xcirc = Math.cos(angle += this.AngleStep) * innerRadius2 + (double)this.Center.x;
                double ycirc = Math.sin(angle) * innerRadius2 + (double)this.Center.y;
                g2.drawLine((int)Math.round(xcircPrev), (int)Math.round(ycircPrev), (int)Math.round(xcirc), (int)Math.round(ycirc));
                xcircPrev = xcirc;
                ycircPrev = ycirc;
                ++i;
            }
            ++k;
        }
    }

    boolean PointUpOddAxis() {
        return this.GridD.getGridLabelAlignment() == 1 || this.GridD.getGridLabelAlignment() == 2;
    }

    boolean PointUpEvenAxis() {
        return this.GridD.getGridLabelAlignment() == 3 || this.GridD.getGridLabelAlignment() == 2;
    }

    boolean isInner() {
        return this.GridD.getGridLabelAlignment() == 1 || this.GridD.getGridLabelAlignment() == 0;
    }

    private void drawRadarGridLabels(Graphics2D g2) {
        double zStep;
        boolean debug = false;
        if (debug) {
            System.out.println("drawRadarGridLabels()");
        }
        double angle = this.initAngle();
        String[] axisLabels = this.AxisD.getAxisLabels();
        double maxValue = this.getMaxSeries();
        String label = "";
        g2.setFont(this.GridD.getFont());
        this.getFMetricsGrid(g2);
        int labelHeightOffset = this.fontmetGrid.getAscent() / 2;
        g2.setStroke(this.DefaultStroke);
        g2.setColor(Color.black);
        double radStep = this.Radius / (double)this.gridLines;
        double radStep2 = this.Radius2 / (double)this.gridLines;
        if (debug) {
            System.out.println("drawRadarGridLabels() + gridlines " + this.gridLines + " rad " + radStep + " rad2 " + radStep2);
        }
        double z = zStep = maxValue / (double)this.gridLines;
        boolean hasUserDefinedGridLabels = false;
        if (this.GridD.getUserDefinedGridLabels() != null) {
            hasUserDefinedGridLabels = true;
        }
        int i = 0;
        double innerRadius = 0.0;
        angle = this.initAngle();
        boolean inner = false;
        if (this.isInner()) {
            inner = true;
        }
        angle = this.GridD.getGridLabelAlignment() == 2 || this.GridD.getGridLabelAlignment() == 0 ? -1.5707963267948966 : 1.5707963267948966;
        int k = 0;
        while (k < this.gridLines) {
            innerRadius = inner ? (innerRadius += radStep2) : (innerRadius += radStep);
            double xcirc = Math.cos(angle) * innerRadius + (double)this.Center.x;
            double ycirc = Math.sin(angle) * innerRadius + (double)this.Center.y;
            int x = (int)Math.round(xcirc);
            int y = (int)Math.round(ycirc);
            if (hasUserDefinedGridLabels) {
                if (this.GridD.getUserDefinedGridLabels().length >= i) {
                    label = this.GridD.getUserDefinedGridLabels()[i];
                }
            } else {
                label = this.GridD.getNumberFormat().format(z);
            }
            if (debug) {
                System.out.println("drawRadarGridLabels() " + label + " x: " + x + " y: " + y);
            }
            if (debug) {
                System.out.println("drawRadarGridLabels() " + label + " x: " + x + " y: " + y);
            }
            switch (this.GridD.getGridLabelAlignment()) {
                case 2: {
                    g2.drawString(label, x + 3, y + labelHeightOffset);
                    break;
                }
                case 3: {
                    g2.drawString(label, x + 3, y - 2);
                    break;
                }
                case 1: {
                    y = (int)Math.round(Math.sin(angle) * (innerRadius - radStep2 * 0.5) + (double)this.Center.y);
                    int width = this.fontmet.stringWidth(label);
                    g2.drawString(label, x - width / 2, y += this.fontmetGrid.getAscent() / 2);
                    break;
                }
                case 0: {
                    y = (int)Math.round(Math.sin(angle) * (innerRadius - radStep2 * 0.5) + (double)this.Center.y);
                    int width = this.fontmet.stringWidth(label);
                    g2.drawString(label, x - width / 2, y += this.fontmetGrid.getAscent() / 3);
                }
            }
            z += zStep;
            ++i;
            ++k;
        }
    }

    public void useCalculatedSeriesMaxValue() {
        this.seriesMaxValue = 0.0;
        this.calculateMaxValue = true;
    }

    public void setSeriesMaximumValue(double maxValue) {
        if (maxValue == Double.MIN_VALUE) {
            this.seriesMaxValue = 0.0;
            this.calculateMaxValue = true;
        } else {
            this.seriesMaxValue = maxValue;
            this.calculateMaxValue = false;
        }
    }

    private double getMaxSeries() {
        if (!this.calculateMaxValue) {
            return this.seriesMaxValue;
        }
        double max = Double.MIN_VALUE;
        int s = 0;
        while (s < this.chartSeriesDesc.size()) {
            RadarSeriesInternal rsi = (RadarSeriesInternal)this.chartSeriesDesc.elementAt(s);
            RadarSeriesDesc seriesD = rsi.seriesD;
            double[] points = seriesD.getSeriesPoints();
            int i = 0;
            while (i < points.length) {
                if (points[i] > max) {
                    max = points[i];
                }
                ++i;
            }
            ++s;
        }
        return max;
    }

    private void setScaleSeries() {
        double max = this.getMaxSeries();
        double scaleFactor = this.Radius / max;
        int s = 0;
        while (s < this.chartSeriesDesc.size()) {
            RadarSeriesInternal rsi = (RadarSeriesInternal)this.chartSeriesDesc.elementAt(s);
            RadarSeriesDesc seriesD = rsi.seriesD;
            double[] points = seriesD.getSeriesPoints();
            int i = 0;
            while (i < points.length) {
                rsi.pointsScaled[i] = points[i] * scaleFactor;
                ++i;
            }
            ++s;
        }
    }

    private void drawSeries(Graphics2D g2) {
        int s = 0;
        while (s < this.chartSeriesDesc.size()) {
            RadarSeriesInternal rsi = (RadarSeriesInternal)this.chartSeriesDesc.elementAt(s);
            RadarSeriesDesc seriesD = rsi.seriesD;
            double[] points = seriesD.getSeriesPoints();
            int[] polyX = new int[points.length + 1];
            int[] polyY = new int[points.length + 1];
            this.setScaleSeries();
            double angle = this.initAngle();
            int i = 0;
            while (i < points.length) {
                polyX[i] = (int)Math.round(Math.cos(angle) * rsi.pointsScaled[i]) + this.Center.x;
                polyY[i] = (int)Math.round(Math.sin(angle) * rsi.pointsScaled[i]) + this.Center.y;
                angle += this.AngleStep;
                ++i;
            }
            polyX[points.length] = polyX[0];
            polyY[points.length] = polyY[0];
            g2.setColor(seriesD.getFillColor());
            g2.fillPolygon(polyX, polyY, points.length + 1);
            ++s;
        }
    }

    double initAngle() {
        double halfSectorAngle = this.AngleStep / 2.0;
        if (this.GridD.getGridLabelAlignment() == 0) {
            return -1.5707963267948966 - halfSectorAngle;
        }
        if (this.GridD.getGridLabelAlignment() == 1) {
            if (this.AxisD.getAxisLabels().length % 2 == 0) {
                return -1.5707963267948966 - halfSectorAngle;
            }
            return -1.5707963267948966;
        }
        if (this.GridD.getGridLabelAlignment() == 3) {
            if (this.AxisD.getAxisLabels().length % 2 == 0) {
                return -1.5707963267948966;
            }
            return -1.5707963267948966 - halfSectorAngle;
        }
        return -1.5707963267948966;
    }

    private String formatCoord(double x, double y) {
        return "(" + x + ", " + y + ")";
    }

    protected void checkDrawBufferErrors(Graphics2D g2, String fcn) throws ChartException {
        if (g2 == null) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-105"));
        }
        if (this.getHeight() == 0 || this.getWidth() == 0) {
            Errorfcn.chartError(fcn, MsgUtil.getMsg("CHT-104"));
            return;
        }
    }

    public void setFont(Font f) {
        this.font = f;
        this.fontMetricsGot = false;
    }

    private void getFMetrics(Graphics2D g2) {
        if (this.fontMetricsGot) {
            return;
        }
        this.fontmet = g2.getFontMetrics(this.font);
        this.fontMetricsGot = true;
    }

    private void getFMetricsGrid(Graphics2D g2) {
        if (this.fontMetricsGridGot) {
            return;
        }
        this.fontmetGrid = g2.getFontMetrics(this.GridD.getFont());
        this.fontMetricsGridGot = true;
    }

    private void setRenderingHints(Graphics2D g2) {
        if (this.isSetRenderingHintsChart()) {
            g2.setRenderingHints(super.getRenderingHintsChart());
        } else {
            this.RHOriginal = g2.getRenderingHints();
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            hints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            g2.setRenderingHints(hints);
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        if (w > 0 || h > 0) {
            this.setSize(w, h);
        }
        super.setBounds(x, y, w, h);
    }

    public void setBounds(Rectangle rect) {
        if (rect.width > 0 || rect.height > 0) {
            this.setSize(rect.width, rect.height);
        }
        super.setBounds(rect);
    }

    public void setSize(Dimension d) {
        if (d.width > 0 || d.height > 0) {
            this.setSize(d.height, d.width);
        }
    }

    public void setSize(int width, int height) {
        if (width <= 0 && height <= 0) {
            return;
        }
        this.SizeChanged = true;
        if (width == 0) {
            this.setHeightInternal(height);
        } else if (height == 0) {
            this.setWidthInternal(width);
        } else {
            super.setSizeInternal(width, height);
        }
        this.displayHeight = super.getHeight();
        this.displayWidth = super.getWidth();
    }

    private void drawBackground(Graphics2D g2) {
        if (this.drawBackgroundRect) {
            if (this.svgChartGraphics.getEnableSVG()) {
                this.svgChartGraphics.startGroup("cb_background");
            }
            g2.setColor(super.getBackground());
            g2.fillRect(0, 0, this.displayWidth, this.displayHeight);
            g2.setColor(this.getEdgeColor());
            g2.drawRect(0, 0, this.displayWidth - 1, this.displayHeight - 1);
            if (this.svgChartGraphics.getEnableSVG()) {
                this.svgChartGraphics.endGroup();
            }
        }
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.startGroup("cb_titles");
        }
        super.getTitle().drawBuffer(g2);
        super.getSubtitle().drawBuffer(g2);
        super.getFootnote().drawBuffer(g2);
        if (this.svgChartGraphics.getEnableSVG()) {
            this.svgChartGraphics.endGroup();
        }
    }

    public void paint(Graphics g) {
        if (this.BI == null || this.SizeChanged) {
            this.SizeChanged = false;
            this.displayWidth = this.getWidth();
            this.displayHeight = this.getHeight();
            this.BI = new BufferedImage(this.displayWidth, this.displayHeight, 1);
        }
        Graphics2D g2 = this.BI.createGraphics();
        try {
            this.drawBuffer(g2);
        }
        catch (ChartException e) {
            System.out.println(e.getMessage());
        }
        g.drawImage(this.BI, 0, 0, this);
    }

    private void checkDuplicateSeries(String functionName, String seriesName) throws ChartException {
        int s = this.LookupSeries(seriesName);
        if (s != -1) {
            throw new ChartException(MsgUtil.getMsg("CHT-500") + functionName + " " + MsgUtil.getMsg("CHT-111") + "\"" + seriesName + "\"");
        }
    }

    protected int LookupSeries(String seriesName) {
        int s = 0;
        while (s < this.chartSeriesDesc.size()) {
            RadarSeriesInternal rsi = (RadarSeriesInternal)this.chartSeriesDesc.elementAt(s);
            if (rsi.seriesD.getSeriesName().equals(seriesName)) {
                return s;
            }
            ++s;
        }
        return -1;
    }

    public void setAxisDesc(RadarAxisDesc axisD) throws ChartException {
        this.AxisD = axisD;
        this.setAngleStep();
    }

    public void setGridDesc(RadarGridDesc gridD) throws ChartException {
        this.GridD = gridD;
    }

    public void setStyleDesc(RadarStyleDesc styleD) throws ChartException {
        this.StyleD = styleD;
    }

    public void setSeriesDesc(RadarSeriesDesc seriesD) throws ChartException {
        if (this.AxisD == null) {
            System.out.println("need to call setAxisDesc() ");
            return;
        }
        this.checkDuplicateSeries("setSeries", seriesD.getSeriesName());
        RadarSeriesInternal rs = new RadarSeriesInternal();
        rs.seriesD = seriesD;
        int length = seriesD.getSeriesPoints().length;
        rs.pointsScaled = new double[length];
        this.chartSeriesDesc.addElement(rs);
    }

    public void setEnableImageMapArea() throws ChartException {
        this.genImageMapCoords = true;
    }

    public ImageMapAreaDesc getImageMapAreaDesc(int imageMapType) {
        switch (imageMapType) {
            case 1: {
                this.ImageMapTypeAxisLabels.setCoords(this.imageMapCoordsAxisLabels);
                this.ImageMapTypeAxisLabels.setShape(this.imageMapShapeAxisLabels);
                return this.ImageMapTypeAxisLabels;
            }
        }
        return null;
    }

    private class RadarSeriesInternal {
        public RadarSeriesDesc seriesD;
        public double[] pointsScaled;

        RadarSeriesInternal() {
        }
    }
}

