/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.util.HashMap;
import java.util.Map;
import oracle.jdevimpl.vcs.svn.res.Resource;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNEventParser {
    private static final Map<SVNEventAction, String> actionMap = new HashMap<SVNEventAction, String>();

    public SVNEventParser() {
        actionMap.put(SVNEventAction.UPDATE_UPDATE, Resource.get("EVENT_UPDATE_UPDATE"));
        actionMap.put(SVNEventAction.UPDATE_ADD, "    " + Resource.get("EVENT_UPDATE_ADD"));
        actionMap.put(SVNEventAction.UPDATE_DELETE, "    " + Resource.get("EVENT_UPDATE_DELETE"));
    }

    public String parse(SVNEvent event) {
        StringBuilder sb = new StringBuilder();
        if (actionMap.containsKey(event.getAction())) {
            sb.append(actionMap.get(event.getAction()));
            sb.append(' ');
        } else {
            sb.append(event.getAction().toString().replaceAll("_", " "));
            sb.append(' ');
        }
        this.conflict(event, sb);
        this.mergeRange(event, sb);
        if (event.getFile() != null) {
            sb.append(event.getFile().getPath());
        }
        return sb.toString();
    }

    private void conflict(SVNEvent event, StringBuilder sb) {
        if (event.getAction() == SVNEventAction.UPDATE_UPDATE) {
            if (event.getContentsStatus() == SVNStatusType.CONFLICTED) {
                sb.append(Resource.get("EVENT_CONTENT_CONFLICT"));
                sb.append(' ');
            }
            if (event.getPropertiesStatus() == SVNStatusType.CONFLICTED) {
                sb.append(Resource.get("EVENT_PROP_CONFLICT"));
                sb.append(' ');
            }
        }
    }

    private void mergeRange(SVNEvent event, StringBuilder sb) {
        if (event.getMergeRange() != null) {
            sb.append(Resource.get("EVENT_MERGE_FROM"));
            sb.append(" r");
            sb.append(event.getMergeRange().getStartRevision());
            sb.append(' ');
            sb.append(Resource.get("EVENT_MERGE_TO"));
            sb.append(" r");
            sb.append(event.getMergeRange().getEndRevision());
            sb.append(' ');
            sb.append(Resource.get("EVENT_MERGE_INTO"));
            sb.append(' ');
        }
    }
}

