/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.commithistory;

import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.commithistory.SVNCommitVersionCompare;
import oracle.jdevimpl.vcs.svn.commithistory.SVNCommitVersionDockableWindow;
import oracle.jdevimpl.vcs.svn.commithistory.SVNCommitVersionExport;

public class SVNCommitVersionController
implements Controller {
    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (context.getView() instanceof SVNCommitVersionDockableWindow) {
            if (cmdId == 51) {
                ((SVNCommitVersionDockableWindow)context.getView()).refresh();
                return true;
            }
            if (cmdId == Ide.findCmdID((String)SVNCommitVersionCompare.COMMAND_ID)) {
                this.invokeCompare(context);
                return true;
            }
            if (cmdId == Ide.findCmdID((String)SVNCommitVersionExport.COMMAND_ID)) {
                this.invokeExport(context);
                return true;
            }
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (context.getView() instanceof SVNCommitVersionDockableWindow) {
            if (cmdId == 51) {
                action.setEnabled(!((SVNCommitVersionDockableWindow)context.getView()).isBusy());
                return true;
            }
            if (cmdId == Ide.findCmdID((String)SVNCommitVersionCompare.COMMAND_ID)) {
                if (context.containsProperty("commit-version-file-path")) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == Ide.findCmdID((String)SVNCommitVersionExport.COMMAND_ID)) {
                action.setEnabled(true);
                return true;
            }
        }
        return false;
    }

    private boolean invokeCompare(Context context) {
        return this.invokeCommand((Command)new SVNCommitVersionCompare(), context);
    }

    private boolean invokeExport(Context context) {
        return this.invokeCommand((Command)new SVNCommitVersionExport(), context);
    }

    private boolean invokeCommand(Command command, Context context) {
        try {
            command.setContext(context);
            CommandProcessor.getInstance().invoke(command);
            return true;
        }
        catch (Exception e) {
            SVNProfile.getQualifiedLogger(SVNCommitVersionController.class.getName()).log(Level.SEVERE, e.getMessage());
            return false;
        }
    }
}

