/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.op;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.net.URLFileSystem;
import oracle.ide.vhv.VHVContext;
import oracle.ide.vhv.VHVInContextResource;
import oracle.javatools.compare.CompareContributor;
import oracle.jdeveloper.compare.BinaryCompareContributor;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.compare.PatchCompareDescriptor;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.versiontree.VersionTreeCompareCommand;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.compare.SVNResourceInfo;
import oracle.jdevimpl.vcs.svn.history.SVNHistoryEntryProducer;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNOperationVHVComparePrevious
extends VersionTreeCompareCommand {
    public static final String COMMAND_ID = SVNOperationVHVComparePrevious.class.getName();

    public SVNOperationVHVComparePrevious() {
        super(Ide.findOrCreateCmdID((String)COMMAND_ID));
    }

    public SVNOperationVHVComparePrevious(int cmdId) {
        super(cmdId);
    }

    protected VHVInContextResource getLeftResource() {
        return VHVContext.getPreviousResource((Context)this.context);
    }

    protected CompareContributor createContributor(URL url, VHVInContextResource inContextResource) throws Exception {
        VHVInContextResource compareResource = inContextResource;
        try {
            SVNUrl svnurl = new SVNUrl(compareResource.getBranch().getPath());
            SVNRevision revision = (SVNRevision)compareResource.getVersionNumber();
            return this.createRevisionContributor(url, svnurl, revision);
        }
        catch (MalformedURLException me) {
            return null;
        }
    }

    private CompareContributor createRevisionContributor(URL url, SVNUrl svnurl, SVNRevision revision) throws Exception {
        BinaryCompareContributor contributor;
        String filename = URLFileSystem.getFileName((URL)url);
        String shortLabel = filename + "@" + revision;
        ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNHistoryEntryProducer.CLIENT_CONTEXT);
        SVNRepositoryInfo repoInfo = SVNUtil.resolveRepository(svnurl);
        SVNClientInteraction.getInstance().beginInteraction(client, repoInfo);
        InputStream is = client.getContent(svnurl, revision);
        SVNClientInteraction.getInstance().endInteraction();
        if (VCSFileSystemUtils.isContentTypeBinary((URL)url)) {
            contributor = new BinaryCompareContributor(is, filename, shortLabel, shortLabel);
        } else {
            InputStreamTextContributor compareContributor = new InputStreamTextContributor(is, shortLabel, shortLabel, URLFileSystem.getSuffix((URL)url));
            compareContributor.setPatchDescriptor(new PatchCompareDescriptor(filename));
            compareContributor.getPatchDescriptor().setPatchParentURL(URLFileSystem.getParent((URL)url));
            compareContributor.getPatchDescriptor().setRevision(revision.toString());
            contributor = compareContributor;
        }
        contributor.setProperty("SVNCompareModelExtension.RESOURCE_INFO", (Object)new SVNResourceInfo(svnurl, revision));
        return contributor;
    }
}

