/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import javax.swing.Icon;
import javax.swing.JLabel;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class DBObjectLabel
extends JLabel {
    private boolean m_hideWhenNull;

    public DBObjectLabel() {
    }

    public DBObjectLabel(DBObject dBObject, boolean bl) {
        this.setObject(dBObject, bl);
    }

    public void setHideWhenNull(boolean bl) {
        this.m_hideWhenNull = bl;
    }

    public void setObject(DBObject dBObject, boolean bl) {
        if (dBObject == null) {
            this.setIcon(null);
            this.setText("" + null);
            this.setToolTipText(null);
        } else {
            String string = bl ? DBUtil.getFullyQualifiedName((DBObject)dBObject) : dBObject.getName();
            this.setText(string);
            Icon icon = DBTypeDisplayRegistry.getNodeIcon(dBObject.getType());
            if (icon == null) {
                icon = OracleIcons.getIcon((String)"column.png");
            }
            this.setIcon(icon);
            DBObject dBObject2 = dBObject;
            String string2 = DBTypeDisplayRegistry.getSingularDisplayName(dBObject2.getType());
            while (string2 == null && (dBObject2 = dBObject2.getParent()) != null) {
                string2 = DBTypeDisplayRegistry.getSingularDisplayName(dBObject2.getType());
            }
            this.setToolTipText(string2 + " " + string);
            this.setVisible(!this.m_hideWhenNull || ModelUtil.hasLength((String)string) && !string.equals("null"));
        }
    }
}

