/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.execute;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import oracle.ide.db.execute.DBRequestProcessor;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.javatools.db.internal.DBCore;
import org.openide.util.RequestProcessor;

public class DBRequestProcessorFactory {
    private final ReentrantLock m_scheduleLock = new ReentrantLock();
    private Timer m_timer;
    private ExecutorService m_dbExecutor;
    private final Map<String, DBRequestProcessor> m_nodeExecutors = new HashMap<String, DBRequestProcessor>();
    private final NodeListener m_listener = new NodeListener(){

        public void nodeWillClose(NodeEvent nodeEvent) {
            Node node = nodeEvent.getNode();
            if (node instanceof DBObjectNode) {
                DBRequestProcessorFactory.this.m_scheduleLock.lock();
                try {
                    DBRequestProcessorFactory.this.shutdown((DBObjectNode)node, null);
                }
                finally {
                    DBRequestProcessorFactory.this.m_scheduleLock.unlock();
                }
            }
        }
    };

    Timer getTimer() {
        assert (this.m_scheduleLock.isHeldByCurrentThread());
        if (this.m_timer == null) {
            this.m_timer = new Timer(this.getClass().getSimpleName() + "_Timer", true);
        }
        return this.m_timer;
    }

    private ExecutorService getDatabaseExecutor() {
        assert (this.m_scheduleLock.isHeldByCurrentThread());
        if (this.m_dbExecutor == null) {
            this.m_dbExecutor = DatabaseUIExtensionHook.getHook().getDBExecutor();
            if (this.m_dbExecutor == null) {
                this.m_dbExecutor = new RequestProcessor("DBRequestProcessor_DatabaseProcessor", 1, true);
            }
        }
        return this.m_dbExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBRequestProcessor getNodeProcessor(DBObjectNode dBObjectNode) {
        this.m_scheduleLock.lock();
        try {
            Object object;
            String string = this.getKey(dBObjectNode);
            DBRequestProcessor dBRequestProcessor = this.m_nodeExecutors.get(string);
            if (dBRequestProcessor == null) {
                object = dBObjectNode.getProviderType();
                ExecutorService executorService = "db".equals(object) ? this.getDatabaseExecutor() : null;
                dBRequestProcessor = new DBRequestProcessor(executorService, dBObjectNode, this.m_scheduleLock);
                this.m_nodeExecutors.put(string, dBRequestProcessor);
                if (dBObjectNode instanceof Node) {
                    ((Node)dBObjectNode).addNodeListener(this.m_listener);
                }
            }
            object = dBRequestProcessor;
            return object;
        }
        finally {
            this.m_scheduleLock.unlock();
        }
    }

    private void shutdown(DBObjectNode dBObjectNode, DBRequestProcessor dBRequestProcessor) {
        assert (this.m_scheduleLock.isHeldByCurrentThread());
        if (dBObjectNode instanceof Node) {
            ((Node)dBObjectNode).removeNodeListener(this.m_listener);
        }
        String string = this.getKey(dBObjectNode);
        if (dBRequestProcessor == null) {
            dBRequestProcessor = this.m_nodeExecutors.remove(string);
        } else {
            DBRequestProcessor dBRequestProcessor2 = this.m_nodeExecutors.get(string);
            if (dBRequestProcessor2 == dBRequestProcessor) {
                this.m_nodeExecutors.remove(string);
            }
        }
        if (dBRequestProcessor != null) {
            dBRequestProcessor.shutdown();
        }
        if (this.m_nodeExecutors.isEmpty() && this.m_timer != null) {
            this.m_timer.cancel();
            this.m_timer = null;
        }
    }

    private String getKey(DBObjectNode dBObjectNode) {
        return dBObjectNode.getURL().toString();
    }

    void notifyProcessorEmpty(DBObjectNode dBObjectNode, DBRequestProcessor dBRequestProcessor) {
        if (!(dBObjectNode instanceof Node) || !((Node)dBObjectNode).isOpen()) {
            this.shutdown(dBObjectNode, dBRequestProcessor);
        }
    }

    static synchronized DBRequestProcessorFactory getInstance() {
        DBCore dBCore = DBCore.getInstance();
        DBRequestProcessorFactory dBRequestProcessorFactory = (DBRequestProcessorFactory)dBCore.get(DBRequestProcessorFactory.class);
        if (dBRequestProcessorFactory == null) {
            dBRequestProcessorFactory = new DBRequestProcessorFactory();
            dBCore.put((Object)dBRequestProcessorFactory);
        }
        return dBRequestProcessorFactory;
    }

    public static DBRequestProcessor getProcessor(DBObjectNode dBObjectNode) {
        if (dBObjectNode == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        return DBRequestProcessorFactory.getInstance().getNodeProcessor(dBObjectNode);
    }
}

