/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.plsql;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.plsql.PlSqlCompilerOptions;

public class PlSqlCompilerOptionsPanel
extends DefaultTraversablePanel {
    private JCheckBox m_chkDebug = new JCheckBox();
    private ComboBoxModel m_allModel = new ValueModel();
    private ComboBoxModel m_infoModel = new ValueModel();
    private ComboBoxModel m_sevModel = new ValueModel();
    private ComboBoxModel m_perfModel = new ValueModel();
    private JComboBox m_allCombo = new JComboBox();
    private JComboBox m_infoCombo = new JComboBox();
    private JComboBox m_sevCombo = new JComboBox();
    private JComboBox m_perfCombo = new JComboBox();
    private ListCellRenderer m_valRenderer = new ValueRenderer();

    public PlSqlCompilerOptionsPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        PlSqlCompilerOptions plSqlCompilerOptions = PlSqlCompilerOptionsPanel.findCompilerOptions(traversableContext);
        this.m_chkDebug.setSelected(plSqlCompilerOptions.isGeneratePlSqlDebugInfo());
        this.m_allModel.setSelectedItem(plSqlCompilerOptions.getWarningValue(PlSqlCompilerOptions.WarningCategory.ALL));
        this.m_infoModel.setSelectedItem(plSqlCompilerOptions.getWarningValue(PlSqlCompilerOptions.WarningCategory.INFORMATIONAL));
        this.m_sevModel.setSelectedItem(plSqlCompilerOptions.getWarningValue(PlSqlCompilerOptions.WarningCategory.SEVERE));
        this.m_perfModel.setSelectedItem(plSqlCompilerOptions.getWarningValue(PlSqlCompilerOptions.WarningCategory.PERFORMANCE));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        PlSqlCompilerOptions plSqlCompilerOptions = PlSqlCompilerOptionsPanel.findCompilerOptions(traversableContext);
        plSqlCompilerOptions.setGeneratePlSqlDebugInfo(this.m_chkDebug.isSelected());
        plSqlCompilerOptions.setWarningValue(PlSqlCompilerOptions.WarningCategory.ALL, (PlSqlCompilerOptions.WarningValue)this.m_allModel.getSelectedItem());
        plSqlCompilerOptions.setWarningValue(PlSqlCompilerOptions.WarningCategory.INFORMATIONAL, (PlSqlCompilerOptions.WarningValue)this.m_infoModel.getSelectedItem());
        plSqlCompilerOptions.setWarningValue(PlSqlCompilerOptions.WarningCategory.SEVERE, (PlSqlCompilerOptions.WarningValue)this.m_sevModel.getSelectedItem());
        plSqlCompilerOptions.setWarningValue(PlSqlCompilerOptions.WarningCategory.PERFORMANCE, (PlSqlCompilerOptions.WarningValue)this.m_perfModel.getSelectedItem());
    }

    private static PlSqlCompilerOptions findCompilerOptions(TraversableContext traversableContext) {
        return GlobalSettings.createGlobalSettings((PropertyStorage)traversableContext.getPropertyStorage()).getPlSqlCompilerOptions();
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        ResourceUtils.resButton((AbstractButton)this.m_chkDebug, (String)UIBundle.get("PLSQL_DEBUGINFO"));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.m_allCombo, (String)UIBundle.get("PLSQL_WARNING_CATEGORY_ALL"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.m_infoCombo, (String)UIBundle.get("PLSQL_WARNING_CATEGORY_INFO"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_sevCombo, (String)UIBundle.get("PLSQL_WARNING_CATEGORY_SEV"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_perfCombo, (String)UIBundle.get("PLSQL_WARNING_CATEGORY_PERF"));
        jLabel3.setText(PlSqlCompilerOptions.WarningCategory.INFORMATIONAL.name());
        jLabel.setText(PlSqlCompilerOptions.WarningCategory.SEVERE.name());
        jLabel2.setText(PlSqlCompilerOptions.WarningCategory.PERFORMANCE.name());
        this.m_allCombo.setModel(this.m_allModel);
        this.m_allCombo.setRenderer(this.m_valRenderer);
        this.m_infoCombo.setModel(this.m_infoModel);
        this.m_infoCombo.setRenderer(this.m_valRenderer);
        this.m_sevCombo.setModel(this.m_sevModel);
        this.m_sevCombo.setRenderer(this.m_valRenderer);
        this.m_perfCombo.setModel(this.m_perfModel);
        this.m_perfCombo.setRenderer(this.m_valRenderer);
        int n = 0;
        this.add(this.m_chkDebug, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 15, 0), 0, 0));
        this.add(jLabel4, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_allCombo, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(jLabel3, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_infoCombo, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(jLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_sevCombo, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.m_perfCombo, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private static class ValueRenderer
    extends DefaultListCellRenderer {
        private ValueRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                object = " ";
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }

    private static class ValueModel
    implements ComboBoxModel {
        private PlSqlCompilerOptions.WarningValue m_selObj;

        private ValueModel() {
        }

        @Override
        public void setSelectedItem(Object object) {
            this.m_selObj = (PlSqlCompilerOptions.WarningValue)object;
        }

        @Override
        public Object getSelectedItem() {
            return this.m_selObj;
        }

        @Override
        public int getSize() {
            return PlSqlCompilerOptions.WarningValue.values().length + 1;
        }

        @Override
        public Object getElementAt(int n) {
            return n == 0 ? null : PlSqlCompilerOptions.WarningValue.values()[n - 1];
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }
}

